<script type="text/javascript">
    $(function() {
        $("#form_template #periode").datepicker( {
            format: "mm-yyyy",
            viewMode: "months", 
            orientation: 'bottom',
            minViewMode: "months"
        });

        $("#form_template #cabang").select2({
            placeholder: "Pilih Cabang",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });
        
        $("#form_template #departemen").select2({
            placeholder: "Semua Departemen",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.departemen") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });

        $(".btn_unduh").click(function(){       
            var loading = Ladda.create(this);
            loading.start();

            // return false;


            var periode = $("#form_template #periode").val();
            if(periode == null){
                var periode = "-";
            }

            var cabang = $("#form_template #cabang").val();
            if(cabang == null){
                var cabang = "-";
            }

            var departemen= $("#form_template #departemen").val();
            if(departemen == null){
                var departemen = "-";
            }

            window.location.href = "<?= route('informasi.gaji.unduh.templateimport') ?>"+"/"+periode+"/"+cabang + '/' + departemen;
            setTimeout(function (){
                loading.stop();
            },1000);

            
        });
    });
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_template" class="card-body" disabled>
    <div class="form-group">
        <label>PERIODE</label>
        <input type="text" class="form-control" value="<?= date("m-Y") ?>" id="periode" autocomplete="off" required>
    </div>
        
    <div class="form-group">
        <label>Cabang</label>
        <select id="cabang" class="form-control" style="width: 100%;" required>
        </select>
    </div>

    <div class="form-group">
        <label>Departemen</label>
        <select id="departemen" class="form-control" style="width: 100%;">
        </select>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button class="btn_unduh ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>

