<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Verifikasi_m extends CI_Model {
    var $table = 'pkwt_data';
    public function __construct(){
		parent::__construct();
	}

    function get_datatables($tanggal_mulai="0000-00-00", $tanggal_selesai="0000-00-00", $id_cabang="", $id_departemen="", $id_karyawan=""){
        $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_cabang, $id_departemen, $id_karyawan);
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($tanggal_mulai="0000-00-00", $tanggal_selesai="0000-00-00", $id_cabang="", $id_departemen="", $id_karyawan=""){
        $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_cabang, $id_departemen, $id_karyawan);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($tanggal_mulai="0000-00-00", $tanggal_selesai="0000-00-00", $id_cabang="", $id_departemen="", $id_karyawan=""){
        $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_cabang, $id_departemen, $id_karyawan);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($tanggal_mulai="0000-00-00", $tanggal_selesai="0000-00-00", $id_cabang="", $id_departemen="", $id_karyawan=""){
        if($id_cabang != "all"){
            $this->db->join("data_karyawan AS karyawan", "data.id_karyawan = karyawan.id_karyawan");
            $this->db->where("karyawan.id_cabang", $id_cabang);
        }

        if($id_departemen != "all"){
            $this->db->where("karyawan.id_departemen", $id_departemen);
        }

        if($id_karyawan != "all"){
            $this->db->where('data.id_karyawan', $id_karyawan);
        }

        $this->db->select(" data.id_pkwt,
                            data.no_pkwt,
                            data.id_karyawan,
                            data.nik,
                            data.nm_karyawan,
                            data.lahir_tempat,
                            data.lahir_tgl,
                            data.alamat,
                            data.nm_lvl_user,
                            data.nm_jabatan,
                            data.nm_departemen,
                            data.nm_cabang,
                            data.tgl_pkwt,
                            data.tgl_pkwt_mulai,
                            data.tgl_pkwt_selesai,
                            data.nm_direktur,
                            data.ttd_direktur,
                            data.ttd_karyawan,
                            data.nm_draft_pkwt,
                            data.status,
                            data.apv_karyawan,
                            data.apv_direksi,
                            data.tgl_apv_karyawan,
                            data.tgl_apv_direksi,
                            data.user_apv_karyawan,
                            data.user_apv_direksi,
                            data.ket_tolak,
                            data.id_company,
                            data.user_input,
                            data.tgl_input,
                            data.user_update,
                            data.tgl_update")
                    ->from('pkwt_data AS data')
                    ->where("data.id_company",$this->id_company)
                    ->where("data.status !=", "0")
                    ->where("data.jenis_pkwt", "perpanjangan");

        $column_search = array('nik');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('','nik');

        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }
        else{
            $order_by = array("tgl_input"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id){
        $this->db->select(" data.id_pkwt,
                            data.no_pkwt,
                            data.id_karyawan,
                            data.nik,
                            data.nm_karyawan AS nama_lengkap,
                            data.lahir_tempat AS tempat_lahir,
                            data.lahir_tgl AS tgl_lahir,
                            data.alamat AS alamat_domisili,
                            data.nm_lvl_user AS nama_level_user,
                            data.nm_jabatan AS nama_jabatan,
                            data.nm_departemen AS nama_departemen,
                            data.nm_cabang AS nama_cabang,
                            data.tgl_pkwt,
                            data.tgl_pkwt_mulai,
                            data.tgl_pkwt_selesai,
                            data.nm_direktur,
                            data.ttd_direktur,
                            data.ttd_karyawan,
                            data.nm_draft_pkwt,
                            data.status,
                            data.apv_karyawan,
                            data.apv_direksi,
                            data.tgl_apv_karyawan,
                            data.tgl_apv_direksi,
                            data.user_apv_karyawan,
                            data.user_apv_direksi,
                            data.ket_tolak,
                            data.id_company,
                            data.user_input,
                            data.tgl_input,
                            data.user_update,
                            data.tgl_update");
        $this->db->from('pkwt_data AS data');
        $this->db->where("MD5(data.id_pkwt)",$id);
        $this->db->where("data.id_company",$this->id_company);

        $query = $this->db->get();
        return $query->row();
    }

    // public function master_tunj_trx(){
    //     $select = $this->db->select("tunj.id_komponen,
    //                                 tunj.no_urut,
    //                                 tunj.nm_komp")
    //                         ->from("pkwt_komp_tunj_trx AS tunj")
    //                         ->join('pkwt_data AS data', 'tunj.id_pkwt = data.id_pkwt')
    //                         ->where("tunj.id_company",$this->id_company)
    //                         ->order_by("tunj.no_urut ASC")
    //                         ->get()
    //                         ->result();

    //     $data = [];
    //     foreach ($select as $key) {
    //         $data[$key->id_komponen][] = [
    //             'id_komponen'   => $key->id_komponen,
    //             'nm_komp'       => $key->nm_komp,
    //             'no_urut'       => $key->no_urut
    //         ];
    //     }
    //     return $data;
    // }
}