<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Jabatan_m extends CI_Model
{
    var $table = 'master_jabatan';
    public function __construct()
    {
        parent::__construct();
    }

    function get_datatables($leveluser = 0)
    {
        $this->_get_datatables_query($leveluser);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($leveluser = 0)
    {
        $this->_get_datatables_query($leveluser);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($leveluser = 0)
    {
        $this->db->select("master_jabatan.id_jabatan")
            ->join("usergroup", "usergroup.id = master_jabatan.level_user")
            ->from($this->table);
        $this->db->where("id_company", $this->id_company);

        if ($leveluser != 0) {
            $this->db->where("usergroup.id", $leveluser);
        }

        return $this->db->count_all_results();
    }
    private function _get_datatables_query($leveluser = 0)
    {
        if ($this->adm_absensi == true) {
            $this->db->where_not_in('usergroup.id', ['1', '4', '6']);
        }  

        if ($leveluser != 0) {
            $this->db->where("usergroup.id", $leveluser);
        }

        if ($this->code_lang == 'en') {
            $this->db->select('usergroup.lang_en as level');
        } else {
            $this->db->select('usergroup.lang_id as level');
        }

        $this->db->select("master_jabatan.id_jabatan,
                            master_jabatan.kode_jabatan,
                            master_jabatan.nama,
                            master_jabatan.level_user,
                            usergroup.id")
            ->join("usergroup", "usergroup.id = master_jabatan.level_user")
            ->where("id_company", $this->id_company)
            ->from($this->table);

        $column_search = array('master_jabatan.kode_jabatan', 'master_jabatan.nama');

        $i = 0;

        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('', 'master_jabatan.kode_jabatan', 'master_jabatan.nama', 'usergroup.urutan');

        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("master_jabatan.tgl_input" => "DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id = null)
    {
        $select = $this->db->query("SELECT id_jabatan,
                                            kode_jabatan,
                                            nama, level_user
                                    FROM $this->table
                                    WHERE MD5(id_jabatan) = '$id'
                                    AND id_company = '" . $this->id_company . "'")->row();
        return $select;
    }

    public function getLevelUser()
    {
        if ($this->adm_absensi == true) {
            $this->db->where_not_in('id', ['1', '4', '6']);
        }   

        if ($this->paket_informasi_gaji == '1') {
            $select = $this->db->select("id, urutan, lang_" . $this->code_lang . " as level")
                ->from('usergroup')
                ->order_by('urutan')
                ->get()
                ->result();
        } else {
            $select = $this->db->select("id,urutan_payroll as urutan, lang_" . $this->code_lang . " as level")
                ->from('usergroup')
                ->where('id !=', '6')
                ->order_by('urutan')
                ->get()
                ->result();
        }
        return $select;
    }

    public function save($data, $id_jabatan = null, $level_user_lama)
    {
        $kode_jabatan = $data['kode_jabatan'];
        $level_user = $data['level_user'];
        if ($id_jabatan != null) {
            $data['user_update'] = $this->nik_karyawan." - ".$this->nm_karyawan;
            $data['tgl_update']  = date('Y-m-d h:i:s');

            $select = "SELECT kode_jabatan FROM master_jabatan WHERE kode_jabatan = ? AND md5(id_jabatan) != ? AND id_company = ?";
            $cek_kode = $this->db->query($select, array($kode_jabatan, $id_jabatan, $this->id_company));
            
            if ($cek_kode->num_rows() > 0) {
                $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_kode_digunakan') . '</font>');
                return __response_update(false, $message);
            } else {
                $this->db->trans_start();

                if ($level_user != $level_user_lama) {

                    $this->update_karyawan($id_jabatan, $level_user_lama, $level_user);
                }

                $this->db->where(array('md5(id_jabatan)' => $id_jabatan, 'id_company' => $this->id_company));
                $update = $this->db->update($this->table, $data);
                // $this->logger->create_log('master_jabatan', 'edit', $this->db->last_query());

                $this->db->trans_complete();

                if ($this->db->trans_status() === FALSE) {
                    $this->db->trans_rollback();
                    return __response_update(false);
                } else {
                    $this->db->trans_commit();
                    return  __response_update($update);
                }

            }
        } else {
            $data['user_input'] = $this->nik_karyawan." - ".$this->nm_karyawan;

            $select = "SELECT kode_jabatan FROM master_jabatan WHERE kode_jabatan = ?  AND id_company = ?";
            $cek_kode = $this->db->query($select, array($kode_jabatan, $this->id_company));
            
            if ($cek_kode->num_rows() > 0) {
                $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_kode_digunakan') . '</font>');
                return __response_save(false, $message);
            }  else {
                $nextId = $this->fungsi->getNextId($this->table, 'id_jabatan', $this->id_company, 3);
                $id_jabatan = array('id_jabatan' => $nextId);
                $save = $this->db->insert($this->table, array_merge($data, $id_jabatan));
                return __response_save($save);
            }
        }
    }

    public function delete($id = null)
    {
        $this->db->select("id_karyawan");
        $this->db->from("data_karyawan");
        $this->db->where("md5(id_jabatan)", $id);
        $this->db->where("id_company", $this->id_company);
        $cek_data = $this->db->get()->num_rows();

        if ($cek_data > 0) {
            $message = '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_hapus_jabatan') . '</font>';
            return __response_delete(false, ["message" => $message]);
        } else {
            $this->db->where(array('md5(id_jabatan)' => $id, 'id_company' => $this->id_company));
            $delete = $this->db->delete($this->table);
            $this->logger->create_log('master_jabatan', 'delete', $this->db->last_query());
            return  __response_delete($delete);
        }
    }

    public function update_karyawan($id_jabatan, $level_user_lama, $level_user)
    {
        //STAF
        if ($level_user_lama == '3' AND (in_array($level_user, array('4','6','7')))) { //staff menjadi supervisi/direksi/finance

            // cek data karyawan yang ada supervisi
            $cek_id_supervisi = $this->db->query("SELECT id_jabatan, id_karyawan 
                                                        FROM data_karyawan 
                                                        WHERE id_company = '$this->id_company'
                                                        AND MD5(id_jabatan) = '$id_jabatan'
                                                        AND supervisi != ''")->num_rows();

            if ($cek_id_supervisi > 0) {
                $this->_updateSpvByStaf($id_jabatan);
            }

            if ((in_array($level_user, array('4','6')))) {

                $cek_id_karyawan = $this->db->query("SELECT id_jabatan, id_karyawan, id_cabang
                                                FROM data_karyawan 
                                                WHERE id_company = '$this->id_company'
                                                AND MD5(id_jabatan) = '$id_jabatan'");

                if ($cek_id_karyawan->num_rows() > 0) {

                    $id_karyawan_arr = array();
                    foreach ($cek_id_karyawan->result() as $val) {
                        $id_karyawan_arr[] = $val->id_karyawan;
                    }
                    $this->_updateIdDepartemen($id_karyawan_arr);
                }
            }

            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);


        }else if($level_user_lama == '3' AND $level_user == '2'){//staff menjadi kepala departemen

            $id_p_kedep      = $this->fungsi->getNextId('p_kedep','id',$this->id_company,5);
            $last_id_p_kedep = substr($id_p_kedep,-5);
            $next_id_p_kedep = $last_id_p_kedep+1;

            // cek data karyawan yang ada supervisi
            $cek_id_supervisi = $this->db->query("SELECT id_jabatan, id_karyawan 
                                                        FROM data_karyawan 
                                                        WHERE id_company = '$this->id_company'
                                                        AND MD5(id_jabatan) = '$id_jabatan'
                                                        AND supervisi != ''")->num_rows();
            if ($cek_id_supervisi > 0) {
                // jika data lebih dari 0 maka update id supervisi menjadi kosong
                $this->_updateSpvByStaf($id_jabatan);
            }

            // data karyawan yang akan di insert ke tabel p_kedep
            $cek_data_karyawan = $this->db->query("SELECT id_karyawan, id_cabang, id_departemen
                                                    FROM data_karyawan 
                                                    WHERE id_company = '$this->id_company'
                                                    AND MD5(id_jabatan) = '$id_jabatan'");

            if ($cek_data_karyawan->num_rows() > 0) {

                $data_insert_p_kedep = array();
                foreach ($cek_data_karyawan->result() as $val) {
                    $data_kedep = array(
                                'id'            => $id_p_kedep, 
                                'id_karyawan'   => $val->id_karyawan, 
                                'id_cabang'     => $val->id_cabang, 
                                'id_departemen' => $val->id_departemen, 
                                'flag'          => '1', 
                                'id_company'    => $this->id_company,  
                            );
                    $id_p_kedep = substr($id_p_kedep,0,-5).sprintf("%05d", $next_id_p_kedep);
                    $next_id_p_kedep++;

                    $data_insert_p_kedep[] = $data_kedep;
                }

                $this->db->insert_batch('p_kedep', $data_insert_p_kedep);
            }

            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);

        }else if($level_user_lama == '3' AND $level_user == '5'){//staff menjadi kepala cabang

            $id_p_kacab      = $this->fungsi->getNextId('p_kacab','id',$this->id_company,5);
            $last_id_p_kacab = substr($id_p_kacab,-5);
            $next_id_p_kacab  = $last_id_p_kacab+1;

            // cek data karyawan yang ada supervisi
            $cek_id_supervisi = $this->db->query("SELECT id_jabatan, id_karyawan 
                                                        FROM data_karyawan 
                                                        WHERE id_company = '$this->id_company'
                                                        AND md5(id_jabatan) = '$id_jabatan'
                                                        AND supervisi != ''")->num_rows();
            if ($cek_id_supervisi > 0) {
                 // jika data lebih dari 0 maka update id supervisi menjadi kosong
                $this->_updateSpvByStaf($id_jabatan);
            }

            // data karyawan yang akan di insert ke tabel p_cabang
            $cek_data_karyawan = $this->db->query("SELECT id_karyawan, id_cabang
                                                    FROM data_karyawan 
                                                    WHERE id_company = '$this->id_company'
                                                    AND MD5(id_jabatan) = '$id_jabatan'");
            if ($cek_data_karyawan->num_rows() > 0) {
                $data_insert_p_kacab = array();
                $id_karyawan_arr     = array();
                foreach ($cek_data_karyawan->result() as $val) {
                    $data_kacab = array(
                                'id'            => $id_p_kacab, 
                                'id_karyawan'   => $val->id_karyawan, 
                                'id_cabang'     => $val->id_cabang, 
                                'flag'          => '1', 
                                'id_company'    => $this->id_company,  
                            );
                    $id_p_kacab = substr($id_p_kacab,0,-5).sprintf("%05d", $next_id_p_kacab);
                    $next_id_p_kacab++;

                    $data_insert_p_kacab[] = $data_kacab;

                    $id_karyawan_arr[] = $val->id_karyawan;
                }

                $this->_updateIdDepartemen($id_karyawan_arr);
                $this->db->insert_batch('p_kacab', $data_insert_p_kacab);
            }

            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);
        }

        //SUPERVISI
        if ($level_user_lama == '7' AND (in_array($level_user, array('3','4','6')))) { //supervisi menjadi staff/direksi/finance

            // cek data karyawan yang ada supervisi
            $cek_id_supervisi = $this->db->query("SELECT id_jabatan, id_karyawan 
                                                        FROM data_karyawan 
                                                        WHERE id_company = '$this->id_company'
                                                        AND MD5(id_jabatan) = '$id_jabatan'");
            if ($cek_id_supervisi->num_rows() > 0) {

                $id_supervisi_arr = array();
                foreach ($cek_id_supervisi->result() as $val) {
                    $id_supervisi_arr[] = $val->id_karyawan;   
                }

                $this->_updateSpvBySpv($id_supervisi_arr, $level_user);
            }

            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);
            
        }else if($level_user_lama == '7' AND $level_user == '2'){ //supervisi menjadi kepala departemen
            $id_p_kedep      = $this->fungsi->getNextId('p_kedep','id',$this->id_company,5);
            $last_id_p_kedep = substr($id_p_kedep,-5);
            $next_id_p_kedep = $last_id_p_kedep+1;

            $cek_data_karyawan = $this->db->query("SELECT id_karyawan, id_cabang, id_departemen 
                                                FROM data_karyawan 
                                                WHERE id_company = '$this->id_company'
                                                AND MD5(id_jabatan) = '$id_jabatan'");

            if($cek_data_karyawan->num_rows() > 0){
                // data karyawan yang akan di insert ke tabel p_kedep
                $data_insert_p_kedep = array();
                $id_supervisi_arr = array();
                foreach ($cek_data_karyawan->result() as $val) {
                    $data_kedep = array(
                                'id'            => $id_p_kedep, 
                                'id_karyawan'   => $val->id_karyawan, 
                                'id_cabang'     => $val->id_cabang, 
                                'id_departemen' => $val->id_departemen, 
                                'flag'          => '1', 
                                'id_company'    => $this->id_company,  
                            );
                    $id_p_kedep = substr($id_p_kedep,0,-5).sprintf("%05d", $next_id_p_kedep);
                    $next_id_p_kedep++;

                    $data_insert_p_kedep[] = $data_kedep;
                    $id_supervisi_arr[] = $val->id_karyawan;
                }

                $this->_updateSpvBySpv($id_supervisi_arr,$level_user);
                $this->db->insert_batch('p_kedep', $data_insert_p_kedep);
            }


            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);

        }else if($level_user_lama == '7' AND $level_user == '5'){//supervisi menjadi kepala cabang

            $id_p_kacab      = $this->fungsi->getNextId('p_kacab','id',$this->id_company,5);
            $last_id_p_kacab = substr($id_p_kacab,-5);
            $next_id_p_kacab  = $last_id_p_kacab+1;

            // cek data karyawan yang ada supervisi
            $cek_data_karyawan = $this->db->query("SELECT id_karyawan, id_cabang, id_departemen 
                                                FROM data_karyawan 
                                                WHERE id_company = '$this->id_company'
                                                AND MD5(id_jabatan) = '$id_jabatan'");            
            if($cek_data_karyawan->num_rows() > 0){
                $data_insert_p_kacab = array();
                $id_supervisi_arr    = array();
                foreach ($cek_data_karyawan->result() as $val) {
                    $data_kacab = array(
                                'id'            => $id_p_kacab, 
                                'id_karyawan'   => $val->id_karyawan, 
                                'id_cabang'     => $val->id_cabang, 
                                'flag'          => '1', 
                                'id_company'    => $this->id_company,  
                            );
                    $id_p_kacab = substr($id_p_kacab,0,-5).sprintf("%05d", $next_id_p_kacab);
                    $next_id_p_kacab++;

                    $data_insert_p_kacab[] = $data_kacab;
                    $id_supervisi_arr[]    = $val->id_karyawan; 
                }

                $this->_updateSpvBySpv($id_supervisi_arr,$level_user);
                $this->db->insert_batch('p_kacab', $data_insert_p_kacab);
            }

            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);
        }

        // KEPALA DEPARTEMEN
        if ($level_user_lama == '2' AND (in_array($level_user, array('3', '4','6','7')))) { //Kepala Departemen menjadi staff/Direksi/finance/Supervisi

            $cek_id_karyawan = $this->db->query("SELECT id_jabatan, id_karyawan 
                                                        FROM data_karyawan 
                                                        WHERE id_company = '$this->id_company'
                                                        AND md5(id_jabatan) = '$id_jabatan'");

            if ($cek_id_karyawan->num_rows() > 0) {
                $id_karyawan_arr = array();
                foreach ($cek_id_karyawan->result() as $val) {
                    $id_karyawan_arr[] = $val->id_karyawan;   
                }

                if (in_array($level_user, array('4','5','6'))) {
                    $this->_updateIdDepartemen($id_karyawan_arr);
                }

                $this->_deleteKedep($id_karyawan_arr);
            }

            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);
            
        }else if($level_user_lama == '2' AND $level_user == '5'){//kepala departemen menjadi kepala cabang
            $id_p_kacab      = $this->fungsi->getNextId('p_kacab','id',$this->id_company,5);
            $last_id_p_kacab = substr($id_p_kacab,-5);
            $next_id_p_kacab  = $last_id_p_kacab+1;

            $cek_id_karyawan = $this->db->query("SELECT id_jabatan, id_karyawan, id_cabang
                                                        FROM data_karyawan 
                                                        WHERE id_company = '$this->id_company'
                                                        AND MD5(id_jabatan) = '$id_jabatan'");
            if ($cek_id_karyawan->num_rows() >0) {

                $data_insert_p_kacab = array();
                $id_karyawan_arr     = array();
                foreach ($cek_id_karyawan->result() as $val) {
                    $data_kacab = array(
                                'id'            => $id_p_kacab, 
                                'id_karyawan'   => $val->id_karyawan, 
                                'id_cabang'     => $val->id_cabang, 
                                'flag'          => '1', 
                                'id_company'    => $this->id_company,  
                            );
                    $id_p_kacab = substr($id_p_kacab,0,-5).sprintf("%05d", $next_id_p_kacab);
                    $next_id_p_kacab++;

                    $data_insert_p_kacab[] = $data_kacab;
                    $id_karyawan_arr[]     = $val->id_karyawan;
                }

                $this->_deleteKedep($id_karyawan_arr);
                $this->_updateIdDepartemen($id_karyawan_arr);
                $this->db->insert_batch('p_kacab', $data_insert_p_kacab);
            }

            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);
        }

        // KEPALA CABANG
        if ($level_user_lama == '5' AND (in_array($level_user, array('3','4','6','7')))) { //Kepala Cabang menjadi staff/Direksi/finance/Supervisi

            $cek_id_karyawan = $this->db->query("SELECT id_jabatan, id_karyawan 
                                                        FROM data_karyawan 
                                                        WHERE id_company = '$this->id_company'
                                                        AND MD5(id_jabatan) = '$id_jabatan'");
            if ($cek_id_karyawan->num_rows() > 0) {
                $id_karyawan_arr = array();
                foreach ($cek_id_karyawan->result() as $val) {
                    $id_karyawan_arr[] = $val->id_karyawan;   
                }
                $this->_deleteKacab($id_karyawan_arr);
            }

            
        }else if($level_user_lama == '5' AND $level_user == '2'){//kepala departemen menjadi kepala cabang
            $id_p_kedep      = $this->fungsi->getNextId('p_kedep','id',$this->id_company,5);
            $last_id_p_kedep = substr($id_p_kedep,-5);
            $next_id_p_kedep = $last_id_p_kedep+1;

            $cek_id_karyawan = $this->db->query("SELECT id_jabatan, id_karyawan, id_cabang, id_departemen
                                                        FROM data_karyawan 
                                                        WHERE id_company = '$this->id_company'
                                                        AND MD5(id_jabatan) = '$id_jabatan'");
            if ($cek_id_karyawan->num_rows() >0) {
            
                // data karyawan yang akan di insert ke tabel p_kedep
                $data_insert_p_kedep = array();
                $id_karyawan_arr     = array();
                foreach ($cek_id_karyawan->result() as $val) {
                    $data_kedep = array(
                                'id'            => $id_p_kedep, 
                                'id_karyawan'   => $val->id_karyawan, 
                                'id_cabang'     => $val->id_cabang, 
                                'id_departemen' => $val->id_departemen, 
                                'flag'          => '1', 
                                'id_company'    => $this->id_company,  
                            );
                    $id_p_kedep = substr($id_p_kedep,0,-5).sprintf("%05d", $next_id_p_kedep);
                    $next_id_p_kedep++;

                    $data_insert_p_kedep[] = $data_kedep;
                    $id_karyawan_arr[]     = $val->id_karyawan;
                }

                $this->_deleteKacab($id_karyawan_arr);

                $this->db->insert_batch('p_kedep', $data_insert_p_kedep);
            }

            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);
        }

        // FINANCE
        if($level_user_lama == '6' AND $level_user == '2') { //finance menjadi kepala departemen
            $id_p_kedep      = $this->fungsi->getNextId('p_kedep','id',$this->id_company,5);
            $last_id_p_kedep = substr($id_p_kedep,-5);
            $next_id_p_kedep = $last_id_p_kedep+1;

            $cek_id_karyawan = $this->db->query("SELECT id_jabatan, id_karyawan, id_cabang, id_departemen
                                                        FROM data_karyawan 
                                                        WHERE id_company = '$this->id_company'
                                                        AND MD5(id_jabatan) = '$id_jabatan'");
            if($cek_id_karyawan->num_rows() > 0){
                $data_insert_p_kedep = array();
                foreach ($cek_id_karyawan->result() as $val) {
                    $data_kedep = array(
                                'id'            => $id_p_kedep, 
                                'id_karyawan'   => $val->id_karyawan, 
                                'id_cabang'     => $val->id_cabang, 
                                'id_departemen' => $val->id_departemen, 
                                'flag'          => '1', 
                                'id_company'    => $this->id_company,  
                            );
                    $id_p_kedep = substr($id_p_kedep,0,-5).sprintf("%05d", $next_id_p_kedep);
                    $next_id_p_kedep++;

                    $data_insert_p_kedep[] = $data_kedep;
                }

                $this->db->insert_batch('p_kedep', $data_insert_p_kedep);
            }

            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);

        }else if($level_user_lama == '6' AND $level_user == '5'){//finance menjadi kepala cabang
            $id_p_kacab      = $this->fungsi->getNextId('p_kacab','id',$this->id_company,5);
            $last_id_p_kacab = substr($id_p_kacab,-5);
            $next_id_p_kacab  = $last_id_p_kacab+1;

            $cek_id_karyawan = $this->db->query("SELECT id_jabatan, id_karyawan, id_cabang
                                                        FROM data_karyawan 
                                                        WHERE id_company = '$this->id_company'
                                                        AND MD5(id_jabatan) = '$id_jabatan'");
            if($cek_id_karyawan->num_rows() > 0){

                $data_insert_p_kacab = array();
                foreach ($cek_id_karyawan->result() as $val) {
                    $data_kacab = array(
                                'id'            => $id_p_kacab, 
                                'id_karyawan'   => $val->id_karyawan, 
                                'id_cabang'     => $val->id_cabang, 
                                'flag'          => '1', 
                                'id_company'    => $this->id_company,  
                            );
                    $id_p_kacab = substr($id_p_kacab,0,-5).sprintf("%05d", $next_id_p_kacab);
                    $next_id_p_kacab++;

                    $data_insert_p_kacab[] = $data_kacab;
                }

                $this->db->insert_batch('p_kacab', $data_insert_p_kacab);
            }

            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);
        }

        // Direksi
        if($level_user_lama == '4' AND $level_user == '2') { //Direksi menjadi kepala departemen
            $id_p_kedep      = $this->fungsi->getNextId('p_kedep','id',$this->id_company,5);
            $last_id_p_kedep = substr($id_p_kedep,-5);
            $next_id_p_kedep = $last_id_p_kedep+1;

            $cek_id_karyawan = $this->db->query("SELECT id_jabatan, id_karyawan, id_cabang, id_departemen
                                                        FROM data_karyawan 
                                                        WHERE id_company = '$this->id_company'
                                                        AND MD5(id_jabatan) = '$id_jabatan'");
            if($cek_id_karyawan->num_rows() > 0){
                $data_insert_p_kedep = array();
                foreach ($cek_id_karyawan->result() as $val) {
                    $data_kedep = array(
                                'id'            => $id_p_kedep, 
                                'id_karyawan'   => $val->id_karyawan, 
                                'id_cabang'     => $val->id_cabang, 
                                'id_departemen' => $val->id_departemen, 
                                'flag'          => '1', 
                                'id_company'    => $this->id_company,  
                            );
                    $id_p_kedep = substr($id_p_kedep,0,-5).sprintf("%05d", $next_id_p_kedep);
                    $next_id_p_kedep++;

                    $data_insert_p_kedep[] = $data_kedep;
                }

                $this->db->insert_batch('p_kedep', $data_insert_p_kedep);
            }

            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);

        }else if($level_user_lama == '4' AND $level_user == '5'){ //Direksi menjadi kepala cabang
            $id_p_kacab      = $this->fungsi->getNextId('p_kacab','id',$this->id_company,5);
            $last_id_p_kacab = substr($id_p_kacab,-5);
            $next_id_p_kacab  = $last_id_p_kacab+1;

            $cek_id_karyawan = $this->db->query("SELECT id_jabatan, id_karyawan, id_cabang
                                                        FROM data_karyawan 
                                                        WHERE id_company = '$this->id_company'
                                                        AND MD5(id_jabatan) = '$id_jabatan'");
            if($cek_id_karyawan->num_rows() > 0){
                $data_insert_p_kacab = array();
                foreach ($cek_id_karyawan->result() as $val) {
                    $data_kacab = array(
                                'id'            => $id_p_kacab, 
                                'id_karyawan'   => $val->id_karyawan, 
                                'id_cabang'     => $val->id_cabang, 
                                'flag'          => '1', 
                                'id_company'    => $this->id_company,  
                            );
                    $id_p_kacab = substr($id_p_kacab,0,-5).sprintf("%05d", $next_id_p_kacab);
                    $next_id_p_kacab++;

                    $data_insert_p_kacab[] = $data_kacab;
                }

                $this->db->insert_batch('p_kacab', $data_insert_p_kacab);
            }

            $log = "id jabatan ".$id_jabatan." di update. Level user lama ".$level_user_lama.". Level user baru ".$level_user;
            $this->logger->create_log('master_jabatan', 'edit', $log);
        }
    }

    private function _updateSpvBySpv($id_supervisi_arr,$level_user){

        if (in_array($level_user, array('4','5','6'))) {
            $this->db->set('id_departemen', '');
        }

        $this->db->set('supervisi', '');
        $this->db->where('id_company', $this->id_company);
        $this->db->where_in('supervisi', $id_supervisi_arr);
        $this->db->update('data_karyawan');
    }

    private function _updateSpvByStaf($id_jabatan){
        $this->db->set('supervisi', '');
        $this->db->where('id_company', $this->id_company);
        $this->db->where('MD5(id_jabatan)', $id_jabatan);
        $this->db->where('supervisi !=','');
        $this->db->update('data_karyawan');
    }

    private function _deleteKedep($id_karyawan_arr){
        $this->db->where('id_company',$this->id_company);
        $this->db->where_in('id_karyawan',$id_karyawan_arr);
        $this->db->delete("p_kedep");
    }

    private function _deleteKacab($id_karyawan_arr){
        $this->db->where('id_company',$this->id_company);
        $this->db->where_in('id_karyawan',$id_karyawan_arr);
        $this->db->delete("p_kacab");
    }

    private function _updateIdDepartemen($id_karyawan_arr)
    {
        $this->db->set('id_departemen', '');
        $this->db->where('id_company', $this->id_company);
        $this->db->where_in('id_karyawan',$id_karyawan_arr);
        $this->db->update('data_karyawan');
    }
}
