<?php 
include(__DIR__.'/GenerateId.php');

if(!function_exists('generate_id')) {
    function generate_id($jenis, $id_company) {
        $generate_id = new GenerateId($jenis, $id_company);
        return $generate_id->getId();
    }

    function generate_id_from_prev($jenis, $id_company, $id_prev) {
        $generate_id = new GenerateId($jenis, $id_company, $id_prev);
        $generate_id->setCustomInc(1);
        return $generate_id->getId();
    }
}

if(!function_exists('gen_uuid_v4')) {
    function gen_uuid_v4() {
        return sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
                            // 32 bits for "time_low"
                            mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ),
                    
                            // 16 bits for "time_mid"
                            mt_rand( 0, 0xffff ),
                    
                            // 16 bits for "time_hi_and_version",
                            // four most significant bits holds version number 4
                            mt_rand( 0, 0x0fff ) | 0x4000,
                    
                            // 16 bits, 8 bits for "clk_seq_hi_res",
                            // 8 bits for "clk_seq_low",
                            // two most significant bits holds zero and one for variant DCE1.1
                            mt_rand( 0, 0x3fff ) | 0x8000,
                    
                            // 48 bits for "node"
                            mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff )
                    );
    }
}