<style>
    th, td { 
        white-space: nowrap; 
    }
    div.dataTables_wrapper {
        margin: 0 auto;
    }
</style>
<table id="list_data" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr class="bg-tr">
            <th class="text-center" rowspan="2">NO</th>
            <th class="text-center" valign="middle" rowspan="2">NAMA KARYAWAN</th>
            <th class="text-center" rowspan="2">CABANG</th>
            <th class="text-center" rowspan="2">DEPARTEMEN</th>
            <th class="text-center" rowspan="2">JABATAN</th>
            <th class="text-center" colspan="<?= ($ttl_periode > 0)?count($kolom_header):''?>">PERIODE</th>
        </tr>
        <?php
            if($ttl_periode > 0){
        ?>
                <tr class="bg-tr">
                    <?php
                            foreach ($kolom_header as $row) { 
                    ?>
                                <th><?= $row; ?></th>
                    <?php 
                            }
                    ?>
                </tr>
        <?php 
                }
        ?>
    </thead>
    <tbody>
    </tbody>
</table>

<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({ 
                'searching'     : true,
                'paging'        : true,
                'lengthChange'  : true,
                'ordering'      : true,
                'info'          : true,
                'scrollX'       :true,
                'scrollCollapse': true,
                'fixedColumns'  :{
                    'leftColumns': 2,
                },
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan'
                                },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                    "url": "<?= route('pengaturan.shift.import.listdata') ?>",
                                    "type": "POST",
                                    "complete" : function(data){
                                                    reconfigure(data);
                                                }
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false},
                                        { "aTargets": [1], "bSortable": true},
                                        { "aTargets": "_all", "bSortable": false},

                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {

                            $('td:eq(0)', nRow).css({'text-align':'center'});

                            var kolom_header = "<?= count($kolom_header) ?>";
                            for(i=5; i<=kolom_header; i++){
                                $('td:eq('+i+')', nRow).css({'text-align':'center'});
                            }
                    },
        });
    });
</script>