<script type="text/javascript">
    $(document).ready(function () {

        var level_user = "<?= $this->level_user ?>";
        var id_cabang = "<?= $this->id_cabang ?>";
        if(level_user == "1" || level_user == "4"){
            dropdown_cabang();
        }

        dropdown_shift(id_cabang);
        dropdown_karyawan(id_cabang);
        tanggal();
        pickrange();

        $('#btn_new_input').click(function(){
            $(".data_shift").hide();
            $('#form_input input[type=text]').prop("disabled",false);
            $("#form_input input[type=text]").val('');
            $("#form_input :input").prop("disabled", false);
            $("#id_cabang").val('').trigger('change');
            $("#id_shift").val('').trigger('change');
            $("#id_karyawan").val('').trigger('change');

            $('#btn_save').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });

        $(document).on("click","#btn_save",function(e){
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            var level_user = "<?= $this->level_user ?>";
            if(level_user == "1" && level_user == "4"){
                if($("#id_cabang").val()==""){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Cabang belum dipilih</font>");
                    $("#id_cabang").focus();
                    return false;
                }
            }

            if($("#id_shift").val() =="" || $("#id_shift").val() == null){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Shift belum dipilih</font>");
                $('#id_shift').focus();
                return false;
            }else if($("#tanggal_mulai").val() ==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal Mulai belum diisi</font>");
                $('#tanggal_mulai').focus();
                return false;
            }else if($("#tanggal_selesai").val() ==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal Akhir belum diisi</font>");
                $('#tanggal_selesai').focus();
                return false;
            }if($("#id_karyawan").val() ==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Karyawan belum dipilih</font>");
                $('#id_karyawan').focus();
                return false;
            }

            loading.start();

            if(level_user == "1" && level_user == "4"){
                id_cabang = $("#id_cabang").val();
            }else{
                id_cabang = '<?= $this->id_cabang ?>';
            }
            var id_karyawan_arr = JSON.stringify($("#id_karyawan").val());
            var param = new FormData();
            param.append('id_cabang',id_cabang);
            param.append('id_shift',$("#id_shift").val());
            param.append('tanggal_mulai',$("#tanggal_mulai").val());
            param.append('tanggal_selesai',$("#tanggal_selesai").val());
            param.append('id_shift',$("#id_shift").val());
            param.append('id_karyawan',id_karyawan_arr);

            $.ajax({
                type: 'POST',
                url: "<?= site_url('pengaturan/shift/save') ?>",
                data: param,
                dataType:'JSON',
                contentType: false,
                processData: false,
                cache: false,
                success: function(result) {
                    if(result.success == true){
                        if(result.type == 'save'){
                            $("#form_input :input").prop("disabled", true);
                            $('#btn_save').hide();
                            $('#btn_new_input').show();
                        }
                        list_data();
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error:function(){
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
    });

    function dropdown_cabang(){
        $('#id_cabang').select2({
            placeholder: 'Pilih Cabang',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function onchange_dropdown_cabang(item){
        var id_cabang = item.value;
        $("#id_karyawan").val('').trigger('change');
        dropdown_karyawan(id_cabang);

        $("#id_shift").val('').trigger('change');
        dropdown_shift(id_cabang);
    }

    function dropdown_karyawan(id_cabang = 0){
        $('#id_karyawan').select2({
            placeholder: 'Pilih Karyawan',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.karyawan.aktif") ?>'+'/'+id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function dropdown_shift(id_cabang = 0){
        $('#id_shift').select2({
            placeholder: 'Pilih Shift',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.shift.nama") ?>'+'/'+id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function tanggal() {
        var d = new Date();
        d.setDate(d.getDate()); // - 1
        $('.input-daterange input').each(function() {
            $(this).datepicker({
                orientation: "bottom",
                format: "dd-mm-yyyy",
                startDate: d,
                autoclose: true,
            });
        });
    }

    function list_data() {
        var level_user          = '<?= $level_user ?>';
        var multi_departemen    = '<?= $multi_departemen ?>';
        var multi_cabang        = '<?= $multi_cabang ?>';

        var tanggal_mulai   = $("#tanggal_mulai").val();
        var tanggal_selesai = $("#tanggal_selesai").val();
        var id_karyawan     = ($("#id_karyawan").val() == "")?"0":$("#id_karyawan").val();
        id_karyawan = id_karyawan.toString();
        id_karyawan = id_karyawan.replace(/,/g, '_._');
        var id_cabang = 0;
        var id_departemen   = 0;

        $('#view_data').load("<?= route('pengaturan.shift.data.view') ?>"+"/"+tanggal_mulai+'/'+tanggal_selesai+'/'+id_karyawan+"/"+id_cabang+"/"+id_departemen, function(){
            $(".data_shift").show();
        });
    }
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">Pengaturan</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>

        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <a href="<?= route('pengaturan.shift.home') ?>" class="btn btn-secondary btn-min-width">
                    <i class="fa fa-arrow-left"></i> KEMBALI
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div id="form_input" class="row">
                <div class="col-md-12">
                    <div class="row">
                        <?php
                            if (in_array($this->level_user, array("1","4"))) {
                        ?>
                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="align-self-center">CABANG</label>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <select id="id_cabang" class="select2 form-control" style="width: 100%;" onchange="onchange_dropdown_cabang(this)">
                            </select>
                        </div>
                        <?php }?>
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="align-self-center">SHIFT</label>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <select id="id_shift" class="select2 form-control" style="border-radius: 5px; width: 100%;"></select>
                        </div>
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="align-self-center">PERIODE</label>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <div class="input-group input-daterange">
                                    <input type="text" id="tanggal_mulai" class="form-control masktanggal" value="<?= date('d-m-Y') ?>" placeholder="dd-mm-yyyy">
                                    <div class="align-self-center">&nbsp;S/D&nbsp;</div>
                                    <input type="text" id="tanggal_selesai" class="form-control masktanggal" value="<?= date('d-m-Y') ?>" placeholder="dd-mm-yyyy">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="align-self-center">KARYAWAN</label>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <select id="id_karyawan" multiple="multiple" class="select2 form-control" style="width: 100%;"></select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-1 mb-1">
                <div class="col-md-1 text-left">&nbsp;</div>
                <div class="col-md-11">
                    <button type="button" id="btn_new_input" class="btn btn-dafault" style="display: none;">TAMBAH BARU</button>
                    <button type="button" id="btn_save" class="btn btn-success ladda-button" data-style="expand-left">
                        <i class="fa fa-save"></i> SIMPAN
                    </button>
                    <label id="message"></label>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded data_shift" style="display: none;">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div id="view_data" class="col-md-12"></div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<!-- <div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div> -->
<!-- END TAMPIL MODAL -->






