<!-- BAGIN DATATABLE -->
<script type="text/javascript">
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = 'throw';
        list_data = $('#list_data').DataTable({
                    'searching'   : false,
                    'searchDelay' : 1000,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    'stateSave'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'NIK/Nama Karyawan'
                                },
                    "processing"  : true,
                    "serverSide"  : true,
                    "order"       : [],

                    "ajax"        : {
                                        "url": "<?= route('payroll.potongan.tetap.datatable') ?>"+"/all",
                                        "type": "POST",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },

                    "aoColumnDefs": [
                                        { "aTargets": [0,1,2,3,4,5], "bSortable": false },
                                        <?php
                                            if (in_array($this->level_user, array("1"))) {
                                        ?>
                                            { "aTargets": [5], "bSortable": false }

                                        <?php }?>
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(1)', nRow).css({'text-align':'left','width':'100px'});
                            $('td:eq(2)', nRow).css({'text-align':'left','width':'100px'});
                            $('td:eq(3)', nRow).css({'text-align':'left','width':'100px'});
                            $('td:eq(4)', nRow).css({'text-align':'right','width':'100px'});
                            $('td:eq(5)', nRow).css({'text-align':'center','width':'50px'});
                    }
        });
    });
</script>
<!-- END DATATABLE -->


<!-- BEGIN FORM INPUT -->
<script type="text/javascript">
    $(function() {
        $(document).on("click",".btn_tambah",function(){
            $('#tampil_form').load("<?= route('payroll.potongan.tetap.form.tambah') ?>",function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Tambah Data");
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-plus"></i> ');
                $(".btn_save").append('TAMBAH DATA');
                $("#btn_new_input").hide();
            });
        });

        $(document).on("click",".btn_save",function(e){
            if(!$("#form_input #id_karyawan").val()){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Karyawan belum dipilih</font>");
                $("#form_input #id_karyawan").select2('open');
                return false;
            }

            var id = $("#form_input #id_karyawan").val();
            location.href = "<?= route('payroll.potongan.tetap.detail') ?>"+"/"+id;
        });

    });
</script>
<!-- END FORM INPUT -->

<!-- BEGIN FILTER -->
<script type="text/javascript">
    $(function() {
        $('#filter #id_karyawan').select2({
            placeholder: 'Pilih Karyawan',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.karyawan.encrypt") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        });

        $('#filter #btn_cari').click(function(){
            var loading = Ladda.create(this);
            loading.start();

            var id_karyawan = ($("#filter #id_karyawan").val() == null)?"all":$("#filter #id_karyawan").val();

            list_data.ajax.url("<?= route('payroll.potongan.tetap.datatable') ?>"+"/"+id_karyawan)
            list_data.ajax.reload(function(){
                loading.stop();
            });
        });
    });

</script>
<!-- END FILTER -->

<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Payroll</a></li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <?php
                if (in_array($this->level_user, array("1"))) {
            ?>
            <div class="float-md-right">
                <button type="button" class="btn_tambah btn btn-biru">
                    <i class="fa fa-plus"></i> Tambah Data
                </button>
            </div>
            <?php
                }
            ?>
        </div>
    </div>
    <hr>
    <div id="filter" class="row">
        <div class="col-md-8">
            <div class="row mt-1">
                <div class="col-md-2">
                    <label>KARYAWAN</label>
                </div>
                <div class="col-md-6">
                    <select id="id_karyawan" class="form-control"></select>
                </div>
                <div class="col-md-2">
                    <button type="button" id="btn_cari" class="ladda-button btn btn-primary col-md-12" data-style="expand-left">CARI</button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12 table-responsive">
                    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th class="align-middle text-center">NO</th>
                                <th class="align-middle text-center">NAMA KARYAWAN</th>
                                <th class="align-middle text-center">CABANG</th>
                                <th class="align-middle text-center">JABATAN</th>
                                <th class="align-middle text-center">TOTAL POTONGAN</th>
                                <th class="align-middle text-center">AKSI</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
