<!-- BEGIN SCRIPT -->
<script type="text/javascript">
    function collapse_detail(id) {
        let arrow = id.firstElementChild.className;
        if (arrow == "fa fa-angle-up") {
            id.firstElementChild.className = "fa fa-angle-down";
        }else{
            id.firstElementChild.className = "fa fa-angle-up";
        }
    }

</script>
<!-- END SCRIPT -->
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title">Detail <?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Payroll</a></li>
                        <li class="breadcrumb-item"><a href="#">Detail</a></li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <?php
                if($data->publish_flag == '1') {
                    if(date('Y-m-d H:i:s') >= $data->publish_sch) {
                ?>
                    <a href="<?= route('payroll.gaji.download.slip', ['token' => md5($data->id_karyawan.$data->periode)]) ?>" class="btn btn-danger" target="_blank"><i class="fa fa-file-pdf-o"></i> DOWNLOAD SLIP GAJI</a>
                <?php
                    }
                }
                ?>
                <a href="<?= route('payroll.gaji.home') ?>">
                    <button type="button" class="btn btn-secondary">
                        <i class="fa fa-arrow-left"></i> Kembali
                    </button>
                </a>
            </div>
        </div>
    </div>
    <hr>
    <div id="form_input" class="row">
        <div class="col-md-6">
            <div class="row mt-1">
                <div class="col-md-3">
                    <label>Nama Karyawan</label>
                </div>
                <div class="col-md-9">
                    <label class="font-weight-bold">: <?= $data->nik." - ".$data->nm_karyawan ?></label>
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-3">
                    <label>Jabatan</label>
                </div>
                <div class="col-md-9">
                    <label class="font-weight-bold">: <?= $data->nm_jabatan ?></label>
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-3">
                    <label>Cabang</label>
                </div>
                <div class="col-md-9">
                    <label class="font-weight-bold">: <?= $data->nm_cabang." - ".$data->kd_cabang ?></label>
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-3">
                    <label>Departemen</label>
                </div>
                <div class="col-md-9">
                    <label class="font-weight-bold">: <?= $data->nm_departemen." - ".$data->kd_departemen ?></label>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="row mt-1">
                <div class="col-md-3">
                    <label>Bulan</label>
                </div>
                <div class="col-md-9">
                    <label class="font-weight-bold">: <?= date("m-Y", strtotime($data->periode)) ?></label>
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-3">
                    <label>Periode</label>
                </div>
                <div class="col-md-9">
                    <label class="font-weight-bold">: <?= date("d-m-Y", strtotime($data->tgl_mulai)) ?> s/d <?= date("d-m-Y", strtotime($data->tgl_selesai)) ?></label>
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-3">
                    <label>Status</label>
                </div>
                <div class="col-md-9">
                    <?php
                        if ($data->publish_flag == "1") {
                            $publish_flag = '<span class="badge badge-primary">Publish</span>';
                        }else{
                            $publish_flag = '<span class="badge badge-danger">Belum publish</span>';
                        }
                    ?>
                    <label class="font-weight-bold">: <?= $publish_flag ?></label>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card card-rounded overflow-hidden">
            <div class="card-content">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h3 class="my-auto content-header-title">PENGHASILAN</h3>
                    </div>
                </div>
                <div id="content-pendapatan" class="collapse show">
                    <div class="card-body">
                        <!-- GAJI POKOK -->
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="font-weight-bold">Gaji Pokok</h6>
                            </div>
                            <div class="col-md-6">
                                <label class="font-weight-bold">: Rp. <?= number_format($data->gapok,0,",",".") ?></label>
                            </div>
                        </div>

                        <!-- LEMBUR -->
                        <div class="row clearfix mt-1">
                            <div class="col-md-6">
                                <h6 class="font-weight-bold">Lembur</h6>
                            </div>
                            <div class="col-md-6">
                                <label class="font-weight-bold">: Rp. <?= number_format($data->lembur_rp,0,",",".") ?></label>
                            </div>
                        </div>

                        <!-- TUNJANGAN TETAP -->
                        <div class="row clearfix mt-1">
                            <div class="col-md-6">
                                <h6 class="font-weight-bold">Tunjangan Tetap</h6>
                            </div>
                            <div class="col-md-6">
                            </div>
                        </div>
                        <?php
                            $no = 1;
                            foreach ($tunj_tetap as $u) {
                                ?>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <label><?= $no.'. '.$u->nm_tunjangan ?></label>
                                    </div>
                                    <div class="col-sm-6">
                                        <label class="font-weight-bold">: Rp. <?= number_format($u->nominal,0,",",".") ?></label>
                                    </div>
                                </div>
                                <?php $no++;
                            }
                        ?>

                        <!-- TUNJANGAN TIDAK TETAP -->
                        <div class="row clearfix mt-1">
                            <div class="col-md-6">
                                <h6 class="font-weight-bold">Tunjangan Tidak Tetap</h6>
                            </div>
                            <div class="col-md-6">
                            </div>
                        </div>
                        <?php
                            $no = 1;
                            foreach ($tunj_tdk_tetap as $u) {
                                ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label><?= $no.'. '.$u->nm_tunjangan ?></label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="font-weight-bold">: Rp. <?= number_format($u->nominal,0,",",".") ?></label>
                                    </div>
                                </div>
                                <?php $no++;
                            }
                        ?>
                        <hr>
                        <!-- TOTAL PENERIMAAN -->
                        <div class="row clearfix mt-1">
                            <div class="col-md-6">
                                <h6 class="font-weight-bold">Total Penerimaan</h6>
                            </div>
                            <div class="col-md-6">
                                <label class="font-weight-bold">: Rp. <?= number_format($data->gapok+$data->ttl_tunjangan,0,",",".") ?></label>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card card-rounded overflow-hidden">
            <div class="card-content">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h3 class="my-auto content-header-title">POTONGAN</h3>
                    </div>
                </div>
                <div id="content-potongan" class="collapse show">
                    <div class="card-body">
                        <!-- POTONGAN TETAP -->
                        <div class="row clearfix">
                            <div class="col-md-6">
                                <h6 class="font-weight-bold">Potongan Tetap</h6>
                            </div>
                            <div class="col-md-6"></div>
                        </div>
                        <?php
                            $no = 1;
                            foreach ($pot_tetap as $u) {
                                ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label><?= $no.'. '.$u->nm_potongan ?></label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="font-weight-bold">: Rp. <?= number_format($u->nominal,0,",",".") ?></label>
                                    </div>
                                </div>
                                <?php $no++;
                            }
                        ?>

                        <!-- POTONGAN TIDAK TETAP -->
                        <div class="row clearfix mt-1">
                            <div class="col-md-6">
                                <h6 class="font-weight-bold">Potongan Tidak Tetap</h6>
                            </div>
                            <div class="col-md-6"></div>
                        </div>
                        <?php $no = 1;
                            foreach ($pot_tdk_tetap as $u) {
                                ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label><?= $u->nm_potongan ?></label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="font-weight-bold">: Rp. <?= number_format($u->nominal,0,",",".") ?></label>
                                    </div>
                                </div>
                                <?php $no++;
                            }
                        ?>

                        <!-- POTONGAN ABSENSI ACC -->
                        <div class="row clearfix mt-1">
                            <div class="col-md-6">
                                <h6 class="font-weight-bold">Potongan Absensi</h6>
                            </div>
                            <div class="col-md-6">
                                <label class="font-weight-bold">: Rp. <?= number_format($data->pot_absensi_acc,0,",",".") ?></label>
                            </div>
                        </div>

                        <!-- POTONGAN PPH 21 -->
                        <div class="row clearfix mt-1">
                            <div class="col-md-6">
                                <h6 class="font-weight-bold">Potongan PPH 21</h6>
                            </div>
                            <div class="col-md-6">
                                <label class="font-weight-bold">: Rp. <?= number_format($data->pot_pph21,0,",",".") ?></label>
                            </div>
                        </div>

                        <!-- POTONGAN BPJS -->
                        <div class="row clearfix mt-1">
                            <div class="col-md-6">
                                <h6 class="font-weight-bold">Potongan BPJS</h6>
                            </div>
                            <div class="col-md-6"></div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label>1. BPJS Kesehatan</label>
                            </div>
                            <div class="col-md-6">
                                <label class="font-weight-bold">: Rp. <?= number_format($data->pot_bpjs_kes,0,",",".") ?></label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label>2. BPJS Ketenagakerjaan</label>
                            </div>
                            <div class="col-md-6">
                                <label class="font-weight-bold">: Rp. <?= number_format($data->pot_bpjs_tk,0,",",".") ?></label>
                            </div>
                        </div>

                        <!-- TOTAL POTONGAN -->
                        <hr>
                        <div class="row clearfix mt-1">
                            <div class="col-md-6">
                                <h6 class="font-weight-bold">Total Potongan</h6>
                            </div>
                            <div class="col-md-6">
                                <label class="font-weight-bold">: Rp. <?= number_format($data->ttl_potongan,0,",",".") ?></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded overflow-hidden">
    <div class="card-content">
        <div class="card-header">
            <div class="d-flex justify-content-between">
                <h3 class="my-auto content-header-title">Gaji Diterima : Rp. <?= number_format($data->thp,0,",",".") ?></h3>
            </div>
        </div>
    </div>
</div>

<!-- Tunjangan dibiayai perusahaan -->
<div class="card card-rounded overflow-hidden">
    <div class="card-content">
        <div class="card-header">
            <div class="d-flex justify-content-between">
                <h6 class="font-weight-bold">Tunjangan Dibiayai Perusahaan</h6>
            </div>
        </div>
        <div class="card-body">
            <div class="row clearfix">
                <div class="col-md-3">
                    <label>1. BPJS Kesehatan</label>
                </div>
                <div class="col-md-9">
                    <label class="font-weight-bold">: Rp. <?= number_format($data->tunj_bpjs_kes,0,",",".") ?></label>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <label>2. BPJS Ketenagakerjaan</label>
                </div>
                <div class="col-md-9">
                    <label class="font-weight-bold">: Rp. <?= number_format($data->tunj_bpjs_tk,0,",",".") ?></label>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL HAPUS-->
<div id="modal_hapus" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title">Apakah Anda ingin menghapus data ini?</h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_hapus btn btn-danger ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> HAPUS</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL HAPUS-->

<!-- START TAMPIL MODAL PUBLISH ALL-->
<div id="modal_publish_all" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label>Jadwal Publish</label>
                    <input type="text" id="jadwal_publish" class="form-control" autocomplete="off" placeholder="dd-mm-yyyy" spellcheck="false">
                </div>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_confrim_publish_all btn btn-biru ladda-button" data-style="expand-left"><i class="fa icon-check"></i> PUBLISH SEMUA</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL PUBLISH ALL-->

<!-- START TAMPIL MODAL UNPUBLISH ALL-->
<div id="modal_unpublish_all" class="modal fade in">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_confrim_unpublish_all btn btn-danger ladda-button" data-style="expand-left"><i class="fa icon-remove"></i> UNPUBLISH SEMUA</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL UNPUBLISH ALL-->
