<!-- BAGIN DATATABLE -->
<script type="text/javascript">
    $(document).ready(function() {
        var bulan = ($("#filter #bulan").val()) ? $("#filter #bulan").val() : '';
        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').DataTable({
            'searching': false,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            'fixedColumns': {
                leftColumns: 2
            },
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                'searchPlaceholder': ''
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('payroll.data.komponen.tdk.tetap.datatable', ['bulan' => '"+bulan+"', 'id_karyawan' => $id_karyawan, 'id_cabang' => $id_cabang, 'id_departemen' => $id_departemen]) ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                    "aTargets": "_all",
                    "bSortable": false
                },
                {
                    "className": "text-center",
                    "targets": [0]
                },
                {
                    "className": "text-left",
                    "targets": [1, 2, 3, 4]
                },
                {
                    "className": "text-right",
                    "targets": "_all"
                },
            ]
        });
    });
</script>
<!-- END DATATABLE -->

<table id="list_data" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr class="bg-tr">
            <?php
            $numrow = 1;
            if (count($list_pendapatan) > 0 || count($list_potongan) > 0) {
                $numrow = 2;
            }
            ?>
            <th rowspan="<?= $numrow ?>" class="align-middle text-center" width="30">NO</th>
            <th rowspan="<?= $numrow ?>" class="align-middle text-center">NAMA KARYAWAN</th>
            <th rowspan="<?= $numrow ?>" class="align-middle text-center">CABANG</th>
            <th rowspan="<?= $numrow ?>" class="align-middle text-center">DEPARTEMEN</th>
            <th rowspan="<?= $numrow ?>" class="align-middle text-center">JABATAN</th>
            <?php
            if (count($list_pendapatan) > 0) {
                echo '<th colspan="' . (count($list_pendapatan) + 1) . '" class="align-middle text-center">PENDAPATAN</th>';
            }
            if (count($list_potongan) > 0) {
                echo '<th colspan="' . (count($list_potongan) + 1) . '" class="align-middle text-center">POTONGAN</th>';
            }
            ?>
        </tr>
        <?php
        if (count($list_pendapatan) > 0 || count($list_potongan) > 0) {
            echo '<tr>';
            if (count($list_pendapatan) > 0) {
                foreach ($list_pendapatan as $komponen) {
                    echo '<th class="align-middle text-center">' . strtoupper($komponen['nm_tunjangan']) . '</th>';
                }
                echo '<th class="align-middle text-center">TOTAL PENDAPATAN</th>';
            }
            if (count($list_potongan) > 0) {
                foreach ($list_potongan as $komponen) {
                    echo '<th class="align-middle text-center">' . strtoupper($komponen['nm_potongan']) . '</th>';
                }
                echo '<th class="align-middle text-center">TOTAL POTONGAN</th>';
            }
            echo '</tr>';
        }
        ?>
    </thead>
    <tbody>
    </tbody>
</table>
