<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pot_absensi_m extends CI_Model {
    private $table = 'payroll_pot_absensi_p';

    public function __construct(){
		parent::__construct();
	}

    function get_datatables(){
        $this->_get_datatables_query();
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->db->select("jenis")->from($this->table);
        $this->db->where("id_company",$this->id_company);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query(){
        $this->db->select("
                            jenis,
                            flag_aktif,
                            flag_persentase_gapok,
                            persentase,
                            nominal_potongan,
                            menit,
                            kelipatan")
                 ->from($this->table)
                 ->where("id_company", $this->id_company);

        $column_search = array('');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('');

        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else{
            $order_by = array("jenis"=>"ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getNominalGapok($id=null){
        $this->db->select("jenis");
        $this->db->from($this->table);
        $this->db->where("md5(jenis)", $id);
        $this->db->where("id_company",$this->id_company);
        return $this->db->get()->num_rows();
    }

    public function getCountJenis($id=null){
        $this->db->select("jenis");
        $this->db->from($this->table);
        $this->db->where("md5(jenis)", $id);
        $this->db->where("id_company",$this->id_company);
        return $this->db->get()->num_rows();
    }

    public function update($data, $jenis){
        $is_data = $this->getCountJenis($jenis);

        if ($is_data > 0) {
            $this->db->trans_start();

            $data["user_update"]    = $this->nik_karyawan. ' - ' .$this->nm_karyawan;
            $data["tgl_update"]     = date("Y-m-d H:i:s");

            $this->db->update($this->table, $data, ["md5(jenis)" => $jenis]);

            $this->db->trans_complete();

            if($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return __response_update(false);
            }else{
                $this->db->trans_commit();
                return __response_update(true);
            }
        }else{
            return  __response_update(false);
        }
    }

    public function get_pot_pph(){
        $this->db->select("jenis");
        $this->db->from('payroll_pph21_p');
        $this->db->where("id_company",$this->id_company);

        $get_pot_pph = $this->db->get()->row()->jenis;
        return $get_pot_pph;
    }

    public function update_pot_pph($jenis){
        $this->db->trans_start();

        $this->db->set('jenis', $jenis);
        $this->db->where("id_company",$this->id_company);
        $this->db->update('payroll_pph21_p');

        $this->db->trans_complete();

        if($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $message = ["message"=>'<font color="#FFFFFF"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal diperbarui</font>'];
            return __response_update(false,["message"=>$message]);
        }else{
            $this->db->trans_commit();
            $message = ["message"=>'<font color="#FFFFFF"><i class="fa fa-check-square">&nbsp;</i>Data berhasil diperbarui</font>'];
            return __response_update(true,["message"=>$message]);
        }
    }

}
