<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Import_m extends CI_Model {

    public function __construct(){
        parent::__construct();
        $this->id_company  = $this->session->userdata('id_company');
        $this->id_karyawan = $this->session->userdata('id_karyawan');
        $this->nama_user   = $this->session->userdata('nama_user');
    }

    public function getDataKaryawan($id_cabang="-", $id_departemen="-"){

        if($id_cabang != "-") {
            $this->db->where("data_karyawan.id_cabang",$id_cabang);
        }

        if($id_departemen != "-") {
            $this->db->where("data_karyawan.id_departemen",$id_departemen);
        }


        $this->db->select("data_karyawan.id_karyawan,
                            data_karyawan.nik,
                            data_karyawan.nama_lengkap,
                            master_cabang.id_cabang,
                            master_cabang.kode as kode_cabang,
                            master_cabang.nama as nama_cabang,
                            master_departemen.kode as kode_departemen,
                            master_departemen.nama as nama_departemen,
                            master_jabatan.kode_jabatan,
                            master_jabatan.nama as nama_jabatan,
                            gapok.nominal,
                            gapok.lembur_per_jam");
        $this->db->from("data_karyawan");
        $this->db->join("master_cabang","master_cabang.id_cabang = data_karyawan.id_cabang");
        $this->db->join("master_departemen","master_departemen.id_departemen = data_karyawan.id_departemen","LEFT");
        $this->db->join("master_jabatan","master_jabatan.id_jabatan = data_karyawan.id_jabatan");
        $this->db->join('payroll_gapok_m gapok', 'gapok.id_karyawan = data_karyawan.id_karyawan', 'left');        
        $this->db->where("data_karyawan.id_company",$this->id_company);
        $this->db->where_in("data_karyawan.status",["1","2","3"]);
        $this->db->where_not_in("master_jabatan.level_user",["1","6"]);
        $this->db->order_by("master_departemen.kode ASC, master_jabatan.kode_jabatan ASC, data_karyawan.nik ASC");

        $query = $this->db->get()->result();
        return $query;
    }

    public function masterGapok(){
        $this->db->select("id_karyawan");
        $this->db->from("payroll_gapok_m");
        $this->db->where("id_company",$this->id_company);
        $query = $this->db->get()->result();
        $data = [];
        foreach($query as $row){
            array_push($data, $row->id_karyawan);
        }

        return $data;
    }

    public function masterGapokReady(){
        $this->db->select("id_karyawan, nominal, lembur_per_jam");
        $this->db->from("payroll_gapok_m");
        $this->db->where("id_company",$this->id_company);
        $query = $this->db->get()->result();
        $data = [];
        foreach($query as $row){
            $data[$row->id_karyawan]['nominal'] = $row->nominal;
            $data[$row->id_karyawan]['lembur_per_jam'] = $row->lembur_per_jam;
        }

        return $data;
    }

    public function getDataGapokTemp() {
        $this->db->from('payroll_gapok_m_temp');
        $this->db->where("id_company", $this->id_company);
        $this->db->where_in('flag', ['1', '3']);
        $this->db->where("user_input", $this->id_karyawan);
        return $this->db->get()->result();
    }

    function get_datatables(){
        $this->_get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->_get_datatables_query();
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("data_karyawan.id_karyawan,
                            data_karyawan.nik,
                            data_karyawan.nama_lengkap,
                            master_cabang.kode as kode_cabang,
                            master_cabang.nama as nama_cabang,
                            payroll_gapok_m_temp.nominal,
                            payroll_gapok_m_temp.lembur_per_jam,
                            payroll_gapok_m_temp.flag");
        $this->db->from("payroll_gapok_m_temp");
        $this->db->join("data_karyawan","data_karyawan.id_karyawan = payroll_gapok_m_temp.id_karyawan");
        $this->db->join("master_cabang","master_cabang.id_cabang = data_karyawan.id_cabang");
        $this->db->where("payroll_gapok_m_temp.id_company",$this->id_company);
        $this->db->where("payroll_gapok_m_temp.user_input",$this->id_karyawan);

        $column_search = array('data_karyawan.nik',
                                'data_karyawan.nama_lengkap',
                                'payroll_gapok_m_temp.nominal');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('','data_karyawan.nik','master_cabang.kode','payroll_gapok_m_temp.nominal');

        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }
        else{
            // $order_by = array("master_cabang.kode"=>"ASC", "master_departemen.kode"=>"ASC", "master_jabatan.kode_jabatan"=>"ASC", "data_karyawan.nik"=>"ASC");
            // $this->db->order_by(key($order_by), $order_by[key($order_by)]);
            $this->db->order_by("data_karyawan.nik ASC");
        }
    }

    public function getDataById($id) {
        $this->db->select('id_karyawan, nominal, flag, lembur_per_jam,id_company');
        $this->db->from('payroll_gapok_m_temp');
        $this->db->where("md5(CONCAT(id_karyawan, id_company)) = '$id'", NULL, TRUE);
        return $this->db->get()->row();
    }

    public function cekDataExist($id) {
        $this->db->from('payroll_gapok_m');
        $this->db->where("md5(CONCAT(id_karyawan, id_company)) = '$id'", NULL, TRUE);
        return $this->db->count_all_results();
    }

}
