<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Data_komponen_import_m extends CI_Model {
    protected $master          = "payroll_komponen_m";
    protected $pendapatan_temp = "payroll_tunj_tdk_tetap_temp";
    protected $potongan_temp   = "payroll_pot_tdk_tetap_temp";
    protected $data_karyawan   = "data_karyawan";

    function get_datatables($temp){
        $this->_get_datatables_query($temp);
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($temp){
        $this->_get_datatables_query($temp);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($temp){
        $this->_get_datatables_query($temp);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($temp = 'pend'){
        $this->db->select('
            dk.id_karyawan,
            temp.nik,
            temp.bulan,
            temp.nm_karyawan,
            temp.cabang,
            temp.departemen,
            temp.jabatan
        ')->from($this->data_karyawan.' as dk');
        if ($temp == 'pend') {
            $this->db->join($this->pendapatan_temp.' as temp', 'dk.nik = temp.nik');
        }else{
            $this->db->join($this->potongan_temp.' as temp', 'dk.nik = temp.nik');
        }
        $this->db->where('dk.id_company', $this->id_company);
        $this->db->group_by('dk.id_karyawan');

        $column_search = array('temp.nik', 'temp.nm_karyawan');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('');

        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }else{
            $this->db->order_by('temp.cabang ASC, temp.departemen ASC, temp.jabatan ASC, temp.nik ASC');
        }
    }

    public function master_komponen()
    {
        $select = $this->db->select('
            jenis_master,
            nm_komponen,
            flag_persentase_gapok,
            gapok_persen
        ')
        ->from($this->master)
        ->where('jenis_komponen', 'tidak tetap')
        ->where('id_company', $this->id_company)
        ->order_by('no_urut', 'ASC')
        ->get()
        ->result();

        $data = [];
        foreach ($select as $key) {
            $data[$key->jenis_master][] = [
                'nm_komponen'           => $key->nm_komponen,
                'flag_persentase_gapok' => $key->flag_persentase_gapok,
                'gapok_persen'          => $key->gapok_persen
            ];
        }
        return json_encode($data);
    }


    public function tambah_pendapatan()
    {
        $select = $this->db->select('
            dk.id_karyawan,
            temp.nik,
            temp.bulan,
            temp.cabang,
            temp.departemen,
            temp.jabatan,
            temp.nm_tunjangan,
            temp.nominal_tunjangan,
            master.id_item,
            master.flag_persentase_gapok,
            master.gapok_persen,
            master.jenis_komponen,
            master.jenis_master
        ')
        ->from($this->pendapatan_temp.' as temp')
        ->join($this->master.' as master', 'master.nm_komponen = temp.nm_tunjangan')
        ->join($this->data_karyawan.' as dk', 'dk.nik = temp.nik', 'left')
        ->where('dk.id_company', $this->id_company)
        ->order_by('master.no_urut', 'ASC')
        ->get()
        ->result();

        $data = [];
        foreach ($select as $key) {
            $data[$key->id_karyawan][] = [
                'id_karyawan'           => $key->id_karyawan,
                'nik'                   => $key->nik,
                'id_item'               => $key->id_item,
                'bulan'                 => $key->bulan,
                'cabang'                => $key->cabang,
                'departemen'            => $key->departemen,
                'jabatan'               => $key->jabatan,
                'nm_tunjangan'          => $key->nm_tunjangan,
                'nominal_tunjangan'     => $key->nominal_tunjangan,
                'flag_persentase_gapok' => $key->flag_persentase_gapok,
                'gapok_persen'          => $key->gapok_persen,
                'jenis_komponen'        => $key->jenis_komponen,
                'jenis_master'          => $key->jenis_master
            ];
        }
        return json_encode($data);
    }

    public function tambah_potongan()
    {

        $select = $this->db->select('
            dk.id_karyawan,
            temp.nik,
            temp.bulan,
            temp.cabang,
            temp.departemen,
            temp.jabatan,
            temp.nm_potongan,
            temp.nominal_potongan,
            master.id_item,
            master.flag_persentase_gapok,
            master.gapok_persen,
            master.jenis_komponen,
            master.jenis_master
        ')
        ->from($this->potongan_temp.' as temp')
        ->join($this->master.' as master', 'master.nm_komponen = temp.nm_potongan')
        ->join($this->data_karyawan.' as dk', 'dk.nik = temp.nik', 'left')
        ->where('dk.id_company', $this->id_company)
        ->order_by('master.no_urut', 'ASC')
        ->get()
        ->result();

        $data = [];
        foreach ($select as $key) {
            $data[$key->id_karyawan][] = [
                'id_karyawan'           => $key->id_karyawan,
                'nik'                   => $key->nik,
                'id_item'               => $key->id_item,
                'bulan'                 => $key->bulan,
                'cabang'                => $key->cabang,
                'departemen'            => $key->departemen,
                'jabatan'               => $key->jabatan,
                'nm_potongan'           => $key->nm_potongan,
                'nominal_potongan'      => $key->nominal_potongan,
                'flag_persentase_gapok' => $key->flag_persentase_gapok,
                'gapok_persen'          => $key->gapok_persen,
                'jenis_komponen'        => $key->jenis_komponen,
                'jenis_master'          => $key->jenis_master
            ];
        }
        return json_encode($data);
    }

    public function getDataKaryawan($id_cabang="-", $id_departemen="-"){

        if($id_cabang != "-") {
            $this->db->where("data_karyawan.id_cabang",$id_cabang);
        }

        if($id_departemen != "-") {
            $this->db->where("data_karyawan.id_departemen",$id_departemen);
        }

        $this->db->select("
            data_karyawan.id_karyawan,
            data_karyawan.nama_lengkap,
            data_karyawan.nik,
            master_cabang.id_cabang,
            master_cabang.kode as kode_cabang,
            master_cabang.nama as nama_cabang,
            master_departemen.kode as kode_departemen,
            master_departemen.nama as nama_departemen,
            master_jabatan.kode_jabatan,
            master_jabatan.nama as nama_jabatan,
            IF(payroll_gapok_m.nominal, payroll_gapok_m.nominal, 0) as nominal
        ");
        $this->db->from("data_karyawan");
        $this->db->join("master_cabang","master_cabang.id_cabang = data_karyawan.id_cabang");
        $this->db->join("master_departemen","master_departemen.id_departemen = data_karyawan.id_departemen","LEFT");
        $this->db->join("master_jabatan","master_jabatan.id_jabatan = data_karyawan.id_jabatan");
        $this->db->join("payroll_gapok_m","payroll_gapok_m.id_karyawan = data_karyawan.id_karyawan", "LEFT");
        $this->db->where("data_karyawan.id_company", $this->id_company);
        $this->db->where_in("data_karyawan.status",["1","2","3"]);
        $this->db->where_not_in("master_jabatan.level_user",["1","6"]);
        $this->db->order_by("master_cabang.kode ASC, master_departemen.kode ASC, master_jabatan.kode_jabatan ASC, data_karyawan.nik ASC");

        $query = $this->db->get()->result();
        return $query;
    }

}
