<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pph21_m extends CI_Model {
    public function get_pph21($row, $periode, $nominal, $jenis_pph) {
        $data = [
            'id_karyawan'                      => $row->id_karyawan,
            'nik'                              => $row->nik,
            'nm_karyawan'                      => $row->nm_karyawan,
            'no_ktp'                           => $row->no_ktp,
            'npwp'                             => $row->npwp,
            'tanggungan'                       => $row->tanggungan,
            'local_expat'                      => 'L',
            'mulai_kerja_bulan'                => mulai_kerja_bulan($row->join_date),
            'akhir_kerja_bulan'                => akhir_kerja_bulan($row->tgl_berhenti_bekerja),
            'id_jabatan'                       => $row->id_jabatan,
            'kd_jabatan'                       => $row->kd_jabatan,
            'nm_jabatan'                       => $row->nm_jabatan,
            'id_cabang'                        => $row->id_cabang,
            'kd_cabang'                        => $row->kd_cabang,
            'nm_cabang'                        => $row->nm_cabang,
            'id_departemen'                    => empty($row->id_departemen) ? '' : $row->id_departemen,
            'kd_departemen'                    => empty($row->kd_departemen) ? '' : $row->kd_departemen,
            'nm_departemen'                    => empty($row->nm_departemen) ? '' : $row->nm_departemen,
            'periode'                          => $periode,
            'gapok'                            => $nominal['gapok'],
            'tunj_lain'                        => $nominal['tunj_lain'],
            'premi_asuransi'                   => $nominal['premi_asuransi'],
            'peng_bruto_ttl'                   => $nominal['gapok']+$nominal['tunj_lain']+$nominal['premi_asuransi'],
            'pot_iuran_pensiun_tht'            => $nominal['iuran_pensiun'],
            'ptkp'                             => empty($row->ptkp) ? $this->get_ptkp_nominal_default() : $row->ptkp,
            'jenis_pph'                        => $jenis_pph,
            'id_company'                       => $this->id_company,
            'user_input'                       => $this->nik_karyawan.'-'.$this->nm_karyawan
        ];
        $data['ttl_bruto_bonus']                  = $data['peng_bruto_ttl'];
        $data['pot_jabatan_atas_peng_bruto']      = pot_jabatan_atas_peng_bruto($data['peng_bruto_ttl']);
        $data['ttl_potongan']                     = $data['pot_jabatan_atas_peng_bruto']+$data['pot_iuran_pensiun_tht'];
        $data['jml_ph_neto_disetahunkan']         = jml_ph_neto_disetahunkan($data['peng_bruto_ttl'], $data['ttl_potongan'], $data['mulai_kerja_bulan'], $data['akhir_kerja_bulan']);
        $pkp                                      = pkp($data['jml_ph_neto_disetahunkan'], $data['ptkp']);
        $pkp_5                                    = pkp_persen(5, $pkp);
        $data['pkp_5']                            = $pkp_5['result'];
        $pkp_15                                   = pkp_persen(15, $pkp_5['balance']);
        $data['pkp_15']                           = $pkp_15['result'];
        $pkp_25                                   = pkp_persen(25, $pkp_15['balance']);
        $data['pkp_25']                           = $pkp_25['result'];
        $pkp_30                                   = pkp_persen(30, $pkp_25['balance']);
        $data['pkp_30']                           = $pkp_30['result'];
        $pkp_35                                   = pkp_persen(35, $pkp_30['balance']);
        $data['pkp_35']                           = $pkp_35['result'];
        $data['ttl_pkp_disetahunkan']             = pkp($data['jml_ph_neto_disetahunkan'], $data['ptkp']);
        $data['pph21_non_dtp']                    = ($data['pkp_5']+$data['pkp_15']+$data['pkp_25']+$data['pkp_35'])/12;
        return $data;
    }

    private function get_ptkp_nominal_default() {
        $this->db->select('nominal');
        $this->db->from('ptkp');
        $this->db->where('kode', 'TK/0');
        return $this->db->get()->row()->nominal;
    }

    public function get_jenis() {
        $this->db->where('id_company', $this->id_company);
        return $this->db->get('payroll_pph21_p')->row()->jenis;
    }

    public function update_gaji($data) {
        $this->db->where('id_company', $this->id_company);
        $this->db->update_batch('payroll_gaji_trx', $data, 'id_karyawan');
    }

    public function delete_pph($periode, $id_cabang, $id_departemen, $id_karyawan) {
        if($id_cabang != "all"){
            $this->db->where("id_cabang", $id_cabang);
        }
        if($id_departemen != "all"){
            $this->db->where("id_departemen", $id_departemen);
        }
        if($id_karyawan != "all"){
            $this->db->where("md5(id_karyawan)", $id_karyawan);
        }
        $this->db->where('id_company', $this->id_company);
        $this->db->where('periode', $periode);
        $this->db->delete('payroll_pph21_trx');
    }
}
