<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pengaturan_shift_m extends CI_Model {
    var $table = 'data_shift_karyawan';
	public function __construct(){
        parent::__construct();
    }

	function get_datatables($tanggal_mulai, $tanggal_selesai, $id_karyawan=0, $id_cabang = 0, $id_departemen = 0){
		$this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_karyawan, $id_cabang, $id_departemen);
		if($_GET['length'] != -1){
			$this->db->limit($_GET['length'], $_GET['start']);
		}
		$query = $this->db->get();
		// echo $this->db->last_query();
		return $query->result();
	}

	function count_filtered($tanggal_mulai, $tanggal_selesai, $id_karyawan=0, $id_cabang = 0, $id_departemen = 0){
		$this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_karyawan, $id_cabang, $id_departemen);
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all($tanggal_mulai, $tanggal_selesai, $id_karyawan=0, $id_cabang = 0, $id_departemen = 0){
		$this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_karyawan, $id_cabang, $id_departemen);
		return $this->db->count_all_results();
	}

	private function _get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_karyawan=0, $id_cabang = 0, $id_departemen = 0){

		$id_karyawan_arr = explode("_._",$id_karyawan);

		if($id_karyawan != "0"){
			$this->db->where_in("dk.id_karyawan",$id_karyawan_arr);
        }else{
            if($this->level_user == "7"){
				$this->db->where("dk.supervisi",$this->id_karyawan);
            }
        }

		if($id_cabang != "0") {
			$this->db->where("dk.id_cabang",$id_cabang);
        }else{
            if($this->level_user == "5"){
                if($this->multi_cabang== true){
					$this->db->where_in("dk.id_cabang",$this->id_cabang_arr);
                }else{
					$this->db->where_in("dk.id_cabang",$this->id_cabang);
                }
            }else if($this->level_user == "2"){
				$this->db->where_in("dk.id_cabang",$this->id_cabang);
            }
        }

        if($id_departemen != "0") {
			$this->db->where("dk.id_departemen",$id_departemen);
        }else{
            if($this->level_user == "2"){
                if($this->multi_departemen == true){
					$this->db->where_in("dk.id_departemen",$this->id_departemen_arr);
                }else{
                    $this->db->where('dk.id_departemen', $this->id_departemen);

                }
            }
        }

		$this->db->select("dk.id_karyawan,
							dk.nama_lengkap as nama_karyawan,
							dk.nik,
							CONCAT(mc.kode,' - ',mc.nama) AS cabang,
							CONCAT(md.kode,' - ',md.nama) AS departemen,
							CONCAT(mj.kode_jabatan,' - ',mj.nama) AS jabatan");
		$this->db->join("master_cabang AS mc","mc.id_cabang = dk.id_cabang","LEFT");
		$this->db->join("master_departemen AS md","md.id_departemen = dk.id_departemen","LEFT");
		$this->db->join("master_jabatan AS mj","mj.id_jabatan = dk.id_jabatan","LEFT");
		$this->db->where_in("dk.status",["1","2","3","4"]);
		$this->db->where("dk.id_company",$this->id_company);
		$this->db->from("data_karyawan AS dk");

		$column_search = array('dk.nik','dk.nama_lengkap');
		$i = 0;

		foreach ($column_search as $item){  // looping awal
			if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

				if($i===0){ // looping awal
					$this->db->like($item, $_GET['search']['value']);
				}else{
					$this->db->or_like($item, $_GET['search']['value']);
				}

				if(count($column_search) - 1 == $i) ;
				}
			$i++;
		}

		$column_order = array('','dk.nik');

		if(isset($_GET['order'])){
			$this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
		}
		else{
			// $order_by = array("dk.nik"=>"ASC");
			// $this->db->order_by(key($order_by), $order_by[key($order_by)]);
			$this->db->order_by("mc.kode, md.kode, mj.kode_jabatan, dk.nama_lengkap ASC");
		}
	}

	public function dataShift($tanggal_mulai, $tanggal_selesai, $id_karyawan=0, $id_cabang = 0, $id_departemen = 0){
		$id_karyawan_arr = explode("_._",$id_karyawan);

		if($id_karyawan != "0"){
			$this->db->where_in("dk.id_karyawan",$id_karyawan_arr);
        }else{
            if($this->level_user == "7"){
				$this->db->where("dk.supervisi",$this->id_karyawan);
            }
        }

		if($id_cabang != "0") {
			$this->db->where("dk.id_cabang",$id_cabang);
        }else{
            if($this->level_user == "5"){
                if($this->multi_cabang== true){
					$this->db->where_in("dk.id_cabang",$this->id_cabang_arr);
                }else{
					$this->db->where_in("dk.id_cabang",$this->id_cabang);
                }
            }else if($this->level_user == "2"){
				$this->db->where_in("dk.id_cabang",$this->id_cabang);
            }
        }

        if($id_departemen != "0") {
			$this->db->where("dk.id_departemen",$id_departemen);
        }else{
            if($this->level_user == "2"){
                if($this->multi_departemen == true){
					$this->db->where_in("dk.id_departemen",$this->id_departemen_arr);
                }else{
                    $this->db->where('dk.id_departemen', $this->id_departemen);

                }
            }
        }

		$this->db->select("dsk.id_shift_karyawan,
							dsk.tanggal,
							dsk.id_karyawan,
							ms.id_master_shift,
							ms.kode_shift,
							ms.nama_shift,
							ms.jam_masuk,
							ms.jam_pulang");
		$this->db->join("master_shift AS ms","ms.id_master_shift = dsk.id_master_shift", "LEFT");
		$this->db->join("data_karyawan AS dk","dsk.id_karyawan = dk.id_karyawan", "LEFT");
		$this->db->from("data_shift_karyawan AS dsk");
		$this->db->where("dsk.id_company",$this->id_company);

		$query = $this->db->get();
		$data = $query->result();

		$shift = [];
		foreach($data as $row){
			$shift[$row->tanggal."_".$row->id_karyawan] = array("id_shift_karyawan"=>$row->id_shift_karyawan,
																"kode_shift" => $row->kode_shift,
																"nama_shift" => $row->nama_shift,
																"jam_masuk"	=> date_format(date_create($row->jam_masuk),"H:i"),
																"jam_pulang" => date_format(date_create($row->jam_pulang),"H:i"));
		}

		return $shift;
	}

	public function detailShift($id_shift_karyawan = "0"){
		$this->db->select("dsk.id_shift_karyawan,
							dsk.id_karyawan,
							dk.nik,
							dk.nama_lengkap as nama_karyawan,
							dk.id_cabang,
							dsk.tanggal,
							ms.id_master_shift,
							ms.kode_shift,
							ms.nama_shift,
							ms.jam_masuk,
							ms.jam_pulang");
		$this->db->join("master_shift AS ms","ms.id_master_shift = dsk.id_master_shift", "LEFT");
		$this->db->join("data_karyawan AS dk","dsk.id_karyawan = dk.id_karyawan", "LEFT");
		$this->db->where("MD5(dsk.id_shift_karyawan)",$id_shift_karyawan);
		$this->db->from("data_shift_karyawan AS dsk");
		$query = $this->db->get()->row();
		return $query;
	}

	public function dataDepartemen($id_cabang = "0"){
		$this->db->select("id_karyawan,id_departemen");
		$this->db->where("id_cabang",$id_cabang);
		$this->db->where("id_company",$this->id_company);
		$this->db->from("data_karyawan");
		$query = $this->db->get();
		$data = $query->result();

		$departemen_arr = [];
		foreach($data as $row){
			$departemen_arr[$row->id_karyawan] = $row->id_departemen;
		}

		return $departemen_arr;

	}

	function dataShiftKaryawan($id_cabang, $tgl_mulai, $tgl_selesai) {
		$this->db->select('id_shift_karyawan, id_karyawan, tanggal')
				->from('data_shift_karyawan')
				->where("id_company",$this->id_company)
				->where("id_cabang",$id_cabang)
				->where("tanggal >=",$tgl_mulai)
				->where("tanggal <=",$tgl_selesai);

		$query = $this->db->get();
		$data = $query->result();

		$data_shift_karyawan_arr = [];
		foreach($data as $row){
			$data_shift_karyawan_arr[$row->id_karyawan."_".$row->tanggal] = $row->id_shift_karyawan;
		}

		return $data_shift_karyawan_arr;
	}


	public function save($data,$id_shift_karyawan = null){
        if($id_shift_karyawan != null){
            $this->db->where(array('md5(id_shift_karyawan)'=>$id_shift_karyawan));
            $update = $this->db->update('data_shift_karyawan', $data);
			return __response_update($update);
        }else{
            $nextId = $this->fungsi->getNextId('data_shift_karyawan','id_shift_karyawan',$id_company,4);
            $id_shift_karyawan = array('id_shift_karyawan' => $nextId);

            $save = $this->db->insert('data_shift_karyawan', array_merge($data, $id_shift_karyawan));
            return __response_save($save);
        }

    }

    public function delete($id=null){
        $this->db->where(array('md5(id_shift_karyawan)'=>$id));
        $delete =$this->db->delete($this->table);
        $this->logger->create_log('data_shift_karyawan', 'hapus', $this->db->last_query());
        return  __response_delete($delete);
    }

}