<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Lokasi_m extends CI_Model{

    var $table = 'data_lokasi_kantor';
    var $column_order = array(null, 'nama_kantor', 'nama', 'lat_asli', 'long_asli', 'jarak', null); //set column field database for datatable orderable
    var $column_search = array('nama_kantor'); //set column field database for datatable searchable just firstname , lastname , address are searchable
    var $order = array('data_lokasi_kantor.id_lokasi_kantor' => 'asc'); // default order

    public function __construct(){
        parent::__construct();
        $this->load->database();
    }

    private function _get_datatables_query($id_cabang = null){
        $this->db->where('data_lokasi_kantor.id_company = "'.$this->session->userdata("id_company").'"');
        $this->db->select('data_lokasi_kantor.id_lokasi_kantor as id_kantor, nama_kantor, nama, kode, lat_asli, long_asli, jarak');
        $this->db->from($this->table);
        $this->db->join('master_cabang', 'data_lokasi_kantor.id_cabang = master_cabang.id_cabang', 'left');

        if ($this->session->userdata('level_user') == "5" && $this->session->userdata('level_khusus') != "1") {
            $this->db->where("data_lokasi_kantor.id_cabang",$this->session->userdata("id_cabang"));
        }

        if($id_cabang != null){
            $this->db->where('data_lokasi_kantor.id_cabang',$id_cabang);
        }

        $i = 0;

        foreach ($this->column_search as $item) { // loop column
            if ($_GET['search']['value']) { // if datatable send POST for search
                if ($i === 0) { // first loop
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if (isset($_GET['order'])) { // here order processing
            $this->db->order_by($this->column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables($id_cabang = null){
        $this->_get_datatables_query($id_cabang);
        if ($_GET['length'] != -1)
            $this->db->limit($_GET['length'], $_GET['start']);
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($id_cabang = null){
        $this->_get_datatables_query($id_cabang);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($id_cabang = null){
        $this->db->where('data_lokasi_kantor.id_company = "'.$this->session->userdata("id_company").'"');
        $this->db->select('data_lokasi_kantor.id_lokasi_kantor as id_kantor, nama_kantor, nama, kode, lat_asli, long_asli, jarak');
        $this->db->from($this->table);
        $this->db->join('master_cabang', 'data_lokasi_kantor.id_cabang = master_cabang.id_cabang', 'left');

        if($id_cabang != null){
            $this->db->where('data_lokasi_kantor.id_cabang',$id_cabang);
        }
        if($this->session->userdata('level_user') == "5" && $this->session->userdata('level_user') != "1") {
            $this->db->where("data_lokasi_kantor.id_cabang",$this->session->userdata("id_cabang"));
        }

        return $this->db->count_all_results();
    }

    function get_kode_paket() {
        $id_company = $this->session->userdata('id_company');
        $this->db->select('id_tb_paket')
                ->where('id_company', $id_company);
        return $this->db->get('master_company')->row()->id_tb_paket;
    }

    public function dd_nama_karyawan()
    {
        $result = $this->db->where('id_company', $this->session->userdata('id_company'))
            ->order_by('nama_lengkap ASC')->get('data_karyawan');
        $status[''] = 'Please Select';
        if ($result->num_rows() > 0) {
            foreach ($result->result() as $row) {
                $status[$row->id] = $row->id . ' - ' . strtoupper($row->nama);
            }
        }
        return $status;
    }

    function get_all_coordinates()
    {
        $return = array();
        $this->db->select("lat_asli,long_asli,nama_kantor");
        $this->db->from("data_lokasi_kantor");
        $this->db->where("id_company",$this->session->userdata("id_company"));
        if ($this->session->userdata('level_user') == "5") {
            $this->db->where("id_cabang",$this->session->userdata("id_cabang"));
        }
        $query = $this->db->get();
        if ($query->num_rows()>0) {
            foreach ($query->result() as $row) {
            array_push($return, $row);
            }
        }
        return $return;
    }

    public function data_lokasi($id_cabang = 0){
        if($id_cabang == 0){
            if($this->level_user == "5"){
                if($this->multi_cabang == true){
                    $this->db->where_in("dl.id_cabang",$this->id_cabang_arr);
                }else{
                    $this->db->where("dl.id_cabang",$this->id_cabang);
                }
            }
        }else{
            $this->db->where("dl.id_cabang",$id_cabang);
        }


        $this->db->select("dl.lat_asli AS latitude,
                            dl.long_asli AS longitude,
                            dl.nama_kantor AS nama_lokasi,
                            mc.nama AS nama_cabang");
        $this->db->join("master_cabang AS mc","mc.id_cabang = dl.id_cabang");
        $this->db->where("dl.id_company",$this->id_company);
        $this->db->from("data_lokasi_kantor AS dl");
        $query = $this->db->get();
        return $query->result();
    }

    public function delete($id=null){
        $this->db->select("id_lokasi_kantor");
        $this->db->from("data_lokasi_kantor");
        $this->db->where("md5(id_lokasi_kantor)",$id);
        $this->db->where("id_company",$this->id_company);
        $id_lokasi_kantor = $this->db->get()->row()->id_lokasi_kantor;

        $cek_data  = $this->db->query("SELECT id_karyawan
                                        FROM data_karyawan
                                        WHERE lock_lokasi = '1'
                                        AND FIND_IN_SET('$id_lokasi_kantor',id_lokasi)
                                        AND id_company = '".$this->id_company."'")->num_rows();

        if($cek_data > 0){
            $message = '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Gagal, terdapat karyawan menggunakan lokasi ini</font>';
            return __response_delete(false,["message"=>$message]);
        }else{
            $this->db->where(array('md5(id_lokasi_kantor)'=>$id));
            $delete =$this->db->delete($this->table);
            return  __response_delete($delete);
        }

    }
}
