<?php
class Bpjs_master extends MY_Controller {

        public function __construct(){
                parent::__construct();

                $this->load->helper('numeric');

                $this->load->model('payroll/bpjs/Bpjs_kes_m');
                $this->load->model('payroll/bpjs/Bpjs_tk_m');
                $this->load->model('payroll/bpjs/Bpjs_master_m');
                $this->load->model('payroll/Master_gapok_m');
                $this->load->model('Data_diri_m');
        }

        public function index()
        {
                $data['judul'] = 'BPJS';
                $data['aktif'] = 'bpjs';
                $data['data_bpjs_kes'] = $this->Bpjs_kes_m->get_config();
                $data['data_bpjs_tk']  = $this->Bpjs_tk_m->get_config();
                $data['menu'] = $this->load->view('main_menu', $data, true);
                $data['content'] = $this->load->view('payroll/bpjs/master/home', $data, true);
                $this->load->view('main_template', $data, false);
        }

        public function list_data() {
                $list = $this->Bpjs_master_m->get_datatables();
                $data = array();
                $no = $_GET['start'];
                foreach ($list as $field) {
                        $no++;
                        $row = array();
                        $row[] = $no;
                        $row[] = $field->nama_lengkap.'<br>'.$field->nik;
                        $row[] = dec_to_num($field->ttl_gaji_terdaftar);
                        $row[] = $field->no_bpjs_kes;
                        $row[] = $field->jml_anak;
                        $row[] = dec_to_num($field->bpjs_kes_tunj_perus_rp, 2);
                        $row[] = dec_to_num($field->bpjs_kes_pot_kry_rp, 2);
                        $row[] = $field->no_bpjs_tk;
                        $row[] = dec_to_num($field->bpjs_tk_tunj_jht_perus_rp, 2);
                        $row[] = dec_to_num($field->bpjs_tk_pot_jht_kry_rp, 2);
                        $row[] = dec_to_num($field->bpjs_tk_tunj_jkk_rp, 2);
                        $row[] = dec_to_num($field->bpjs_tk_tunj_jkm_rp, 2);
                        $row[] = dec_to_num($field->bpjs_tk_tunj_jp_perus_rp, 2);
                        $row[] = dec_to_num($field->bpjs_tk_pot_jp_kry_rp, 2);
                        $row[] = dec_to_num($field->ttl_pot_karyawan, 2);
                        $row[] = dec_to_num($field->ttl_tunj_dibiayai_perus, 2);
                        $row[] = '<a class="text-warning" onclick="edit(\''.md5($field->id_karyawan).'\');"><i class="fa fa-edit"></i></a>&nbsp;&nbsp;<a class="text-danger" onclick="hapus(\''.md5($field->id_karyawan).'\');"><i class="fa fa-trash"></i></a>';

                        $data[] = $row;
                }

                $output = array(                "draw"            => $_GET['draw'],
                                                "recordsTotal"    => $this->Bpjs_master_m->count_all(),
                                                "recordsFiltered" => $this->Bpjs_master_m->count_filtered(),
                                                "data"            => $data);

                $output = __response($this->MY_response, $output);

                echo json_encode($output);
        }

        public function form($jenis, $id = null) {
                $data['data_bpjs_kes'] = $this->Bpjs_kes_m->get_config();
                $data['data_bpjs_tk']  = $this->Bpjs_tk_m->get_config();
                $data['data_bpjs_kes_m'] = $this->Bpjs_kes_m->get_data($id);
                $data['data_bpjs_tk_m']  = $this->Bpjs_tk_m->get_data($id);
                $data['data_diri']  = $this->Data_diri_m->getDataById($id);

                $data_gapok      = $this->Master_gapok_m->getDataById($id)->nominal;
                $data_tunj_tetap = $this->Bpjs_master_m->get_ttl_tunj_tetap($data['data_diri']->id_karyawan);
                $data['data_gapok'] = $data_gapok == null ? 0 : $data_gapok;
                $data['data_tunj_tetap'] = $data_tunj_tetap == null ? 0 : $data_tunj_tetap;

                if($jenis == 'tambah') {
                        $data['form_nama_karyawan'] = $this->load->view('payroll/bpjs/master/form_nama_karyawan_select', $data, TRUE);
                } elseif($jenis == 'edit' or $jenis == 'hapus') {
                        $data['id'] = $id;
                        $data['form_nama_karyawan'] = $this->load->view('payroll/bpjs/master/form_nama_karyawan_text', $data, TRUE);
                }
                $this->load->view('payroll/bpjs/master/form', $data);
        }

        public function get_data() {
                $id_karyawan     = $this->input->get('id_karyawan');
                $data_gapok      = $this->Master_gapok_m->getDataById(md5($id_karyawan))->nominal;
                $data_tunj_tetap = $this->Bpjs_master_m->get_ttl_tunj_tetap($id_karyawan);
                $data_diri       = $this->Data_diri_m->getDataById(md5($id_karyawan));

                $data = array(
                        'gapok'       => $data_gapok == null ? 0 : $data_gapok,
                        'tunj_tetap'  => $data_tunj_tetap == null ? 0 : $data_tunj_tetap,
                        'no_bpjs_kes' => $data_diri->no_bpjs_kes,
                        'no_bpjs_tk'  => $data_diri->no_bpjs_tk,
                        'jml_anak'    => $data_diri->jml_anak == null ? 0 : $data_diri->jml_anak
                );

                echo json_encode($data);
        }

        public function save() {
                $id = $this->input->post('id');
                if($id == false) {
                        $id_karyawan = $this->input->post('karyawan');
                        $cek_bpjs_kes = $this->Bpjs_kes_m->cek_data($id_karyawan);
                        $cek_bpjs_tk = $this->Bpjs_tk_m->cek_data($id_karyawan);
                        if($cek_bpjs_kes > 0 or $cek_bpjs_tk > 0) {
                                __response_save(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal disimpan, data sudah ada</font>'));
                        } else {
                                $save = $this->Bpjs_master_m->save($id_karyawan);
                                __response_save($save);
                        }
                } else {
                        $update = $this->Bpjs_master_m->update($id);
                        __response_update($update);
                }
        }

        public function delete() {
                $id = $this->input->post('id');
                $delete = $this->Bpjs_master_m->delete($id);
                __response_delete($delete);
        }
}
