<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payroll extends MY_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->model('karyawan_detail/Payroll_m', 'model');
        $this->load->helper(['numeric', 'payroll']);
    }

    public function index($id_karyawan = null){
        $data['data_diri']        = $this->model->get_data_diri_by_id($id_karyawan);
        $data['gapok']            = $this->model->get_gapok_by_id($id_karyawan);
        $data['tunj_tetap']       = $this->model->get_tunj_tetap_by_id($id_karyawan);
        $data['ttl_tunj_tetap']   = $this->model->get_ttl_tunj_tetap_by_id($id_karyawan);
        $data['pot_bpjs_kes']     = $this->model->get_pot_bpjs_kes_by_id($id_karyawan);
        $data['tunj_bpjs_kes']    = $this->model->get_tunj_bpjs_kes_by_id($id_karyawan);
        $data['pot_bpjs_tk']      = $this->model->get_pot_bpjs_tk_by_id($id_karyawan);
        $data['pot_tetap']        = $this->model->get_pot_tetap_by_id($id_karyawan);
        $ttl_pot_bpjs_tk          = $this->model->get_ttl_pot_bpjs_tk_by_id($id_karyawan);
        $data['ttl_tunj_bpjs_tk'] = $this->model->get_ttl_tunj_bpjs_tk_by_id($id_karyawan);
        $ttl_pot_tetap            = $this->model->get_ttl_pot_tetap_by_id($id_karyawan);
        $data['ttl_pot']          = $data['pot_bpjs_kes']+$ttl_pot_bpjs_tk+$ttl_pot_tetap;
        $data['id_karyawan']      = $id_karyawan;
		$this->load->view('karyawan/payroll/home', $data);
	}

    public function form($id, $id_karyawan) {
        $this->load->helper('option');

        $data['name']        = $id;
        $data['id_karyawan'] = $id_karyawan;
        if(in_array($id, ['tanggungan', 'jml_anak', 'npwp', 'bank_atas_nama', 'bank_rek', 'bank_nama'])) {
            $data['title'] = id_map_title($id);
            $data['data']  = $this->model->get_data_by_data_karyawan($id, $id_karyawan);
        } elseif($id == 'gapok') {
            $data['title'] = id_map_title($id);
            $data['data']  = $this->model->get_data_by_gapok($id, $id_karyawan);
        } else {
            $temp    = explode("_", $id);
            $table   = $temp[0];
            $id_item = $temp[1];

            $row = $this->model->get_data_by_tunj_pot($table, $id_karyawan, $id_item);
            if($table == 'tunjtetap') {
                $data['title'] = $row->nm_tunjangan;
                $data['data']  = $row->nominal_tunjangan;
            } else {
                $data['title'] = $row->nm_potongan;
                $data['data']  = $row->nominal_potongan;
            }
        }

        if($id == 'tanggungan') {
            echo $this->load->view('karyawan/payroll/form_dropdown', $data, TRUE);
        } elseif(in_array($id, ['jml_anak', 'npwp', 'bank_rek', 'bank_nama'])) {
            echo $this->load->view('karyawan/payroll/form', $data, TRUE);
        } else {
            echo $this->load->view('karyawan/payroll/form_nominal', $data, TRUE);
        }
    }

    public function save() {
        $params      = [];
        $name        = $this->input->post('name');
        $temp        = $this->input->post('temp');
        if (in_array($name, ['bank_atas_nama', 'bank_rek', 'bank_nama'])) {
            $value       = $this->input->post('value');
        } else if($name == 'npwp') {
            $value       = str_replace("_", "", $this->input->post('value'));
        } else {
            $value       = str_replace(".", "", $this->input->post('value'));
        }
        $id_karyawan = $this->input->post('id_karyawan');
        $save        = $this->model->save($name, $temp, $value, $id_karyawan);
        if($save) {
            // data
            if(in_array($name, ['tanggungan', 'jml_anak', 'npwp', 'bank_atas_nama', 'bank_rek', 'bank_nama'])) {
                $data['title'] = id_map_title($name);
                $data['data']  = $this->model->get_data_by_data_karyawan($name, $id_karyawan);
            } elseif($name == 'gapok') {
                $data['title'] = id_map_title($name);
                $data['data']  = $this->model->get_data_by_gapok($name, $id_karyawan);
            } else {
                $temp    = explode("_", $name);
                $table   = $temp[0];
                $id_item = $temp[1];

                $row = $this->model->get_data_by_tunj_pot($table, $id_karyawan, $id_item);
                if($table == 'tunjtetap') {
                    $data['title'] = $row->nm_tunjangan;
                    $data['data']  = $row->nominal_tunjangan;
                } else {
                    $data['title'] = $row->nm_potongan;
                    $data['data']  = $row->nominal_potongan;
                }
            }

            // view
            if(in_array($name, ['tanggungan', 'jml_anak', 'npwp', 'bank_atas_nama', 'bank_rek', 'bank_nama'])) {
                $params['new_params'] = ['html' => $this->load->view('karyawan/payroll/value', $data, TRUE)];
            } else {
                $params['new_params'] = ['html' => $this->load->view('karyawan/payroll/value_nominal', $data, TRUE)];
                if($name == 'gapok') {
                    $data['tunj_tetap']                      = $this->model->get_tunj_tetap_by_id($id_karyawan);
                    $data['pot_tetap']                       = $this->model->get_pot_tetap_by_id($id_karyawan);
                    $params['new_params']['html_tunj_tetap'] = $this->load->view('karyawan/payroll/value_tunj_tetap', $data, TRUE);
                    $params['new_params']['html_pot_tetap']  = $this->load->view('karyawan/payroll/value_pot_tetap', $data, TRUE);
                }
            }

            // tambahan parameter
            if(!in_array($name, ['tanggungan', 'npwp'])) {
                $gapok = $this->model->get_gapok_by_id($id_karyawan);
                $ttl_tunj_tetap = $this->model->get_ttl_tunj_tetap_by_id($id_karyawan);
                $params['new_params']['ttl_pendapatan'] = dec_to_num($gapok+$ttl_tunj_tetap);
                $pot_bpjs_kes = $this->model->get_pot_bpjs_kes_by_id($id_karyawan);
                $params['new_params']['pot_bpjs_kes'] = dec_to_num($pot_bpjs_kes, 2);
                $ttl_pot_bpjs_tk   = $this->model->get_ttl_pot_bpjs_tk_by_id($id_karyawan);
                $ttl_pot_tetap     = $this->model->get_ttl_pot_tetap_by_id($id_karyawan);
                $ttl_pot = $pot_bpjs_kes+$ttl_pot_bpjs_tk+$ttl_pot_tetap;
                $params['new_params']['ttl_pot'] = dec_to_num($ttl_pot, 2);
                $params['new_params']['gaji']    = dec_to_num(($gapok+$ttl_tunj_tetap)-$ttl_pot, 2);
            }
        }
        __response_save($save, $params);
    }
}
