<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Laporan_reimburse extends MY_Controller
{

	public function __construct()
	{
		parent::__construct();

		$this->load->model('Laporan_reimburse_m');
	}

	public function index(){
		$data['judul'] = 'Laporan Reimbursement';
		$data['aktif'] = 'laporan_reimburse';
		$data['menu'] = $this->load->view('main_menu', $data, true);
		$data['periode_awal'] = date('d-m-Y',  strtotime(date('Y-m-').'01'));
		$data['periode_akhir'] = date('d-m-Y',  strtotime(date('Y-m-d')));
		$data['level_user'] = $this->session->userdata('level_user');
		$data['content'] = $this->load->view('laporan_reimburse/main', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function view_data($mulai, $selesai, $karyawan, $cabang, $departemen)
	{
		$data['judul']      	= 'Laporan Absensi';
		$data['aktif']      	= 'data_absensi';
		$data['cabang']     	= $cabang;
		$data['departemen']		= $departemen;
		$data['mulai']  		= date('Y-m-d', strtotime($mulai));
		$data['selesai']  		= date('Y-m-d', strtotime($selesai));
		$data['karyawan']       = $karyawan;
		$data['usergroup'] = $this->session->userdata('level_user');
		$this->load->view('laporan_reimburse/list_data', $data, false);
	}

	function list_data($mulai, $selesai, $karyawan = 0, $cabang = 0, $departemen = 0)
	{

		$this->load->helper('tanggal');
		$tanggal_mulai 		= Y_m_d($mulai);
		$tanggal_selesai 	= Y_m_d($selesai);

		$list = $this->Laporan_reimburse_m->get_datatables($tanggal_mulai, $tanggal_selesai, $karyawan, $cabang, $departemen);
		$data 	= array();
		$no 	= $_GET['start'];
		$style = "font-family:Poppins Light";
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = date_format(date_create($field->tgl_pengajuan),"d-m-Y");
			$row[] = $field->no_pengajuan;
			$row[] = "<b>".$field->kode_cabang."</b> - ".$field->nama_cabang."<br><b>".$field->kode_departemen."</b> - ".$field->nama_departemen;
			$row[] = $field->nama_karyawan."<br><b>".$field->nik."</b>";
			$row[] = $field->jenis_plafon;
			$row[] = $field->kode_akun;
			$row[] = $field->keterangan;
			$row[] = "Rp. ".number_format($field->max_nominal_plafon,0,",",".");
			$row[] = "Rp. ".number_format($field->nominal_diajukan,0,",",".");
			$row[] = "Rp. ".number_format($field->nominal_disetujui,0,",",".");

			$data[] = $row;
		}

		$recordsTotal = $this->Laporan_reimburse_m->count_all($tanggal_mulai, $tanggal_selesai, $karyawan, $cabang, $departemen);
		$recordsFiltered = $this->Laporan_reimburse_m->count_filtered($tanggal_mulai, $tanggal_selesai, $karyawan, $cabang, $departemen);

		$output = array(
			"draw"            => $_GET['draw'],
			"recordsTotal"    => $recordsTotal,
			"recordsFiltered" => $recordsFiltered,
			"data"            => $data
		);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function list_cabang($id = null)
	{
		$search = $this->input->get("q");
		$this->Laporan_reimburse_m->list_cabang($id, $search);
	}


	function list_cabang_selected()
	{
		$usergroup  = $this->session->userdata('level_user');
		if ($usergroup == 1) {
			$json = 'Pilih';
		} else {
			$id_cabang = $this->session->userdata('id_cabang');
			$data_cabang = $this->Laporan_reimburse_m->data_cabang($id_cabang);
			$json = array('id' => $data_cabang->id_cabang, 'text' => $data_cabang->kode . ' - ' . $data_cabang->nama);
		}
		echo json_encode($json);
	}

	public function list_departemen($id = null)
	{
		$search = $this->input->get("q");
		$this->Laporan_reimburse_m->list_departemen($id, $search);
	}

	function list_karyawan(){
		$key = $this->input->get("q");
		return $this->Laporan_reimburse_m->list_karyawan($key);
	}

	function download($mulai="0", $selesai="0", $karyawan="0", $cabang="0", $departemen="0")
	{

		if($karyawan != "0") {
			$nama = $this->Laporan_reimburse_m->nama_karyawan($karyawan);
			$filename = "Laporan Reimbursement " . $nama;
		} else {
			if($cabang == "0"){
				$filename = "Laporan Reimbursement Semua Cabang";
			}else{
				if($departemen != "0") {
					$nama_cab 	  = $this->Laporan_reimburse_m->nama_cabang($cabang);
					$nama_dep 	  = $this->Laporan_reimburse_m->nama_departemen($departemen);
					$nama 		  = " Cabang " . $nama_cab . ", Departemen " . str_replace("/","-",$nama_dep);
					$filename 	  = "Laporan Reimbursement " . $nama;
				}else {
					$nama 	  = $this->Laporan_reimburse_m->nama_cabang($cabang);
					$filename = "Laporan Reimbursement Cabang " . $nama . " Semua Departemen";
				}
			}

		}


		$data['nama'] = $nama;
		$data['tanggal_mulai'] 		= date('d-m-Y', strtotime($mulai));
		$data['tanggal_selesai'] 	= date('d-m-Y', strtotime($selesai));
		$data['jenis']	= $jenis;
		$data['title']	= $filename;

		$file_nama =  str_replace(" ","_",$filename)."_".$data["tanggal_mulai"]."_SD_".$data["tanggal_selesai"];

		$data['data'] = $this->Laporan_reimburse_m->download($mulai, $selesai, $karyawan, $cabang, $departemen);

		$this->logger->create_log('report_data', 'export', $this->db->last_query());

        $html = $this->load->view('laporan_reimburse/download', $data, true);
        $html = preg_replace('/>\s+</', '><', $html); //bug dompdf
        $this->load->add_package_path(APPPATH . 'third_party/dompdf/');
        require_once(APPPATH . "third_party/dompdf/dompdf_config.inc.php");
        $name   = $file_nama.".pdf";
        $dompdf = new DOMPDF();
        $dompdf->set_paper('A4', 'landscape');
        $dompdf->load_html($html);
        $dompdf->render();
        $dompdf->stream($name, array("Attachment" => false));
        echo $html;
	}

	function nama_file($jenis, $id)
	{
		if ($jenis == "excel_per_opd" or $jenis == "pdf_per_opd") {
			$result = $this->data_absen->nama_opd($id);
		} else {
		}

		return $result;
	}

	public function dropdown_cabang(){
        $search = $this->input->get("q");

        $this->db->where('id_company', $this->id_company);

		if($this->id_cabang_reimbursement_arr != "all"){
			$this->db->where_in('id_cabang',$this->id_cabang_reimbursement_arr);
		}
		// else{
		// 	$this->db->where_in('id_cabang',[]);
		// }

        $this->db->select('nama, id_cabang, kode');
        $this->db->group_start();
        $this->db->like('nama', $search);
        $this->db->or_like('kode', $search);
        $this->db->group_end();
        $this->db->order_by('id_cabang', 'ASC');

        $result = $this->db->get('master_cabang')->result();
        $json = [];

        foreach ($result as $rows) {
            $json[] = ['id'         =>$rows->id_cabang,
                        'kodecabang'=>$rows->kode,
                        'namacabang'=>$rows->nama,
                        'text'      =>$rows->kode." - ".$rows->nama];
        }
        echo json_encode($json);
    }

	public function dropdown_departemen($id_cabang = null){
        $search = $this->input->get("q");

		$this->db->where('dk.id_cabang', $id_cabang);

        $this->db->select('md.id_departemen, md.kode, md.nama');
        $this->db->join('data_karyawan AS dk','dk.id_departemen = md.id_departemen');
        $this->db->where('md.id_company', $this->id_company);

        $this->db->group_start();
        $this->db->like('md.nama', $search);
        $this->db->or_like('md.kode', $search);
        $this->db->group_end();
        $this->db->order_by('md.kode', 'ASC');
        $this->db->group_by('md.id_departemen');
        $this->db->from('master_departemen AS md');

        $result = $this->db->get()->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id'             =>$rows->id_departemen,
                        'text'          =>$rows->kode." - ".$rows->nama];
        }
        echo json_encode($json);
    }

    public function dropdown_karyawan(){
        $search = $this->input->get("q");

		if($this->id_cabang_reimbursement_arr != "all"){
			$this->db->where_in('dk.id_cabang', $this->id_cabang_reimbursement_arr);
		}


        $this->db->select('dk.id_karyawan, dk.nik, dk.nama_lengkap');
        $this->db->where('dk.id_company', $this->id_company);

        $this->db->group_start();
        $this->db->like('dk.nama_lengkap', $search);
        $this->db->or_like('dk.nik', $search);
        $this->db->group_end();
        $this->db->order_by('dk.nama_lengkap', 'ASC');

        $result = $this->db->get('data_karyawan AS dk')->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id'=>$rows->id_karyawan, 'text'=>$rows->nik." - ".$rows->nama_lengkap];
        }
        echo json_encode($json);
    }

}
