<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Data_sertifikat extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Data_sertifikat_m');
        $this->load->library('Uploadfile');
    }

    public function index($id_karyawan = null){
		$data['id_karyawan'] = $id_karyawan; 
		$this->load->view('karyawan/data_sertifikat/home', $data);
	}

    public function list_data($id_karyawan = null){
		$data['data'] = $this->Data_sertifikat_m->listData($id_karyawan);
		$this->load->view('karyawan/data_sertifikat/list_data', $data);
	}

	public function form($id_karyawan = null, $id_sertifikat=null){
		$data['id_karyawan']= $id_karyawan;

		if($id_sertifikat != null){
			$data['data'] = $this->Data_sertifikat_m->getDataById($id_sertifikat);
		}
		
		$this->load->view('karyawan/data_sertifikat/form', $data);
		
	}

	public function save(){
		$id = $this->input->post('id_sertifikat');
        $id_company = $this->session->userdata('id_company');
        $id_karyawan = $this->fungsi->decrypt_idkaryawan($this->input->post('id_karyawan'));

		$file_lama = $this->input->post('file_lama');

		$file1 = $_FILES['file'];
        if($file1['name'] == ""){
            $file = $file_lama;
        }else{

            $fileUpload['fname']    = 'file';
            $fileUpload['location'] = 'karyawan/'.$id_karyawan.'/sertifikat';
            $fileUpload['allowed']  = 'jpg|png|jpeg';
            $fileUpload['compress_image']  = true;

            $upload = $this->uploadfile->doUpload($fileUpload);
			if($upload["success"] == true){
				$file = $upload['url'];
				if(!empty($file_lama)){
					if($file != $file_lama){
						$this->fungsi->delete_fileupload($file_lama);
					}
				}
			}else{
				$message = ["message"=>$upload["message"]];
				return __response_save(false,["params"=>$message]);
			}
        }

		$data = array('nama_sertifikat'	 =>$this->input->post('nama_sertifikat'),
					'penyelenggara'		 =>$this->input->post('penyelenggara'),
					'tgl_berlaku'        =>date_format(date_create($this->input->post('tgl_berlaku')),"Y-m-d"),
					'tgl_berakhir'		 =>date_format(date_create($this->input->post('tgl_berakhir')),"Y-m-d"),
					'deskripsi'   		 =>$this->input->post('deskripsi'),
					'file'				 =>$file,
					'id_company'		 =>$id_company,
					'id_karyawan'		 =>$id_karyawan);
	
		$this->Data_sertifikat_m->save($data,$id); 
	}

	public function delete(){
		$id = $this->input->post("id_sertifikat");
		$this->Data_sertifikat_m->delete($id);
	}
}
