<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Data_absensi extends MY_Controller
{

	public function __construct(){
		parent::__construct();

		$this->load->model('Data_absensi_m', 'data_absen');
		$this->load->model('Master_plan_m');
	}

	public function index(){
		// var_dump($this->session->userdata());
		$data['judul'] = 'Laporan Absensi';
		$data['aktif'] = 'data_absensi';
		$data['menu'] = $this->load->view('main_menu', $data, true);
		$data['periode_awal'] = date('d-m-Y',  strtotime(date('Y-m-').'01'));
		$data['periode_akhir'] = date('d-m-Y',  strtotime(date('Y-m-d')));
		$data['level_user'] = $this->level_user;
		$data['multi_cabang'] = $this->session->userdata('multi_cabang');
		$data['multi_departemen'] = $this->session->userdata('multi_departemen');
		$data['button_sso'] = $this->Master_plan_m->button_sso();
		$data['paket']	= $this->Master_plan_m->id_paket();
		$data['content'] = $this->load->view('data_absensi/main', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function view_data(){
		$data['judul']      	= 'Laporan Absensi';
		$data['aktif']      	= 'data_absensi';

		$data['periode_awal']	= date_format(date_create($this->input->get('tgl_mulai')),"Y-m-d");
		$data['periode_akhir']	= date_format(date_create($this->input->get('tgl_selesai')),"Y-m-d");


		$data['hadir']          = $this->input->get('hadir');
		$data['terlambat']      = $this->input->get('terlambat');
		$data['pc']             = $this->input->get('pc');
		$data['tap']            = $this->input->get('tap');
		$data['alpa']           = $this->input->get('alpa');
		$data['sakit']          = $this->input->get('sakit');
		$data['izin']           = $this->input->get('izin');
		$data['cuti']           = $this->input->get('cuti');
		$data['libur']           = $this->input->get('libur');

		$data['id_cabang']     	= $this->input->get('id_cabang');
		$data['id_departemen']	= $this->input->get('id_departemen');
		$data['id_karyawan']	= $this->input->get('id_karyawan');

		$this->load->view('data_absensi/list_data', $data, false);
	}

	function list_data(){

		$filter['periode_awal']		= date_format(date_create($this->input->get('periode_awal')),"Y-m-d");
		$filter['periode_akhir']	= date_format(date_create($this->input->get('periode_akhir')),"Y-m-d");

		$filter['hadir']          = $this->input->get('hadir');
		$filter['terlambat']      = $this->input->get('terlambat');
		$filter['pc']             = $this->input->get('pc');
		$filter['tap']            = $this->input->get('tap');
		$filter['alpa']           = $this->input->get('alpa');
		$filter['sakit']          = $this->input->get('sakit');
		$filter['izin']           = $this->input->get('izin');
		$filter['cuti']           = $this->input->get('cuti');
		$filter['libur']          = $this->input->get('libur');

		$filter['id_cabang']     	= $this->input->get('id_cabang');
		$filter['id_departemen']	= $this->input->get('id_departemen');
		$filter['id_karyawan']	= $this->input->get('id_karyawan');

		$list = $this->data_absen->get_datatables($filter);
		$data 	= array();
		$no 	= $_GET['start'];
		$style = "font-family:Poppins Light";
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = date_format(date_create($field->tgl_absen),"d-m-Y");
			$row[] = $field->nama_karyawan."<br><b>".$field->nik."</b>";
			$row[] = $field->nama_cabang."<br><b>".$field->nama_departemen."</b>";
			$row[] = $field->kode_absensi;
			$row[] = $this->button_peta($field->tgl_absen, $field->absen_masuk, $field->id_karyawan, $field->gmt_masuk, "masuk");
			$row[] = $this->button_peta($field->tgl_absen, $field->absen_pulang, $field->id_karyawan, $field->gmt_pulang, "pulang");
			$row[] = $this->button_peta($field->tgl_absen, $field->absen_ist_mulai, $field->id_karyawan, $field->gmt_ist_mulai, "istirahat_mulai");
			$row[] = $this->button_peta($field->tgl_absen, $field->absen_ist_selesai, $field->id_karyawan, $field->gmt_ist_selesai, "istirahat_selesai");

			$button = "";
			$array_boleh = array("reguler", "shift");
			if (in_array($field->jenis_absen, $array_boleh)) {
				$button = $button . "<a id='" . $field->id_karyawan . '/' . $field->tgl_absen . "' class='text-warning btn_edit'><i class='fa fa-pencil-square-o' aria-hidden='true'></i></a>";
			}

			$button = $button . " <a id='" . $field->id_karyawan . '/' . $field->tgl_absen . "' class='text-danger btn_delete'><i class='fa fa-trash' aria-hidden='true'></i></a>";

			if ($this->level_user == 1) {
				$row[] = $button;
			}

			$data[] = $row;
		}

		$recordsTotal = $this->data_absen->count_all($filter);
		$recordsFiltered = $this->data_absen->count_filtered($filter);

		$output = array(
			"draw"            => $_GET['draw'],
			"recordsTotal"    => $recordsTotal,
			"recordsFiltered" => $recordsFiltered,
			"data"            => $data
		);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	function button_peta($tgl_absen = null, $jam_absensi = null, $id_karyawan = null, $gmt = null, $jenis_absen = null)
	{
		if ($jam_absensi == '0000-00-00 00:00:00' || $jam_absensi == '0000-00-00') {
			$result = "-";
		} else if (in_array($jenis_absen, array('alpha', 'libur'))) {
			$result = "-";
		} else {
			$absen = '-';
			if ($jam_absensi != null) {
				$peta = ' <a style="display:block;" data-toggle="modal" data-target="#modalViewDetail" href="javascript:;" data-uri="' . site_url('absensi/lokasi/' . $jenis_absen . '/' . $tgl_absen . '/' . $id_karyawan) . '"><i class="fa fa-map-marker" aria-hidden="true"></i> Lokasi</a>';

				$tgl_absensi = date_format(date_create($jam_absensi),"d-m-Y");
				$jam_absensi = date_format(date_create($jam_absensi),"H:i:s");
				$gmt		= $this->fungsi->_gmt($gmt);
				$absen		= $tgl_absensi."</br><b>".$jam_absensi." ".$gmt."</b></br>".$peta;
				// $absen = $this->fungsi->konversi_datetime($jam_absensi).' '.$this->fungsi->_gmt($gmt).$peta;
			}
			$result = $absen;
		}
		return $result;
	}

	public function lokasi($jenis, $tanggal, $karyawan)
	{
		$judul_jenis = ucfirst($jenis);
		$data['judul'] = 'Lokasi Absensi ' . $judul_jenis;
		$data['aktif'] = 'absensi';
		$data_lokasi = $this->data_absen->lokasi($jenis, $tanggal, $karyawan);
		// echo $this->db->last_query();
		// exit();
		$data['data'] = $data_lokasi;
		if(empty($data_lokasi->longitude)){
			$foto = $this->config->item('base_image').'image?_t=lokasi&_d=';
			$html = '<img src="'.$foto.'" class="portrait" style="max-height:400px">';
			$maps = ["js"=>"","html"=>$html];
			$lokasi = $maps;
			$data['map'] = $lokasi;

		}else{
			$data['lat']	= $data_lokasi->latitude;
			$data['long']	= $data_lokasi->longitude;
			$data['title']= "kkk";
		}
		// var_dump($lokasi);

		$data['foto'] =  $this->config->item('base_image').$data_lokasi->foto;
		$this->load->view('data_absensi/lokasi', $data);
	}

	public function list_cabang($id = null)
	{
		$search = $this->input->get("q");
		$this->data_absen->list_cabang($id, $search);
	}


	function list_cabang_selected()
	{
		$usergroup  = $this->level_user;
		if ($usergroup == 1) {
			$json = 'Pilih';
		} else {
			$id_cabang = $this->id_cabang;
			$data_cabang = $this->data_absen->data_cabang($id_cabang);
			$json = array('id' => $data_cabang->id_cabang, 'text' => $data_cabang->kode . ' - ' . $data_cabang->nama);
		}
		echo json_encode($json);
	}

	public function list_departemen($id = null)
	{
		$search = $this->input->get("q");
		$this->data_absen->list_departemen($id, $search);
	}

	function list_karyawan(){
		$key = $this->input->get("q");
		return $this->data_absen->list_karyawan($key);
	}

	public function form($id_karyawan = null, $tanggal = null)
	{
		if ($id_karyawan == null) {
			$data['ref'] = 0;
			$this->load->view('data_absensi/form', $data);
		} else {
			$data['ref'] = $id_karyawan;
			$data['data'] = $this->data_absen->getDataById($id_karyawan, $tanggal);
			$this->load->view('data_absensi/form', $data);
		}
	}

	public function getJamkerjaDanLibur($tgl_absen, $karyawan)
	{
		$is_libur = false;
		$keterangan = '';
		$day 		= date('N', strtotime($tgl_absen));
		$holiday = $this->db->select('id, keterangan')
			->from('holidays')
			->where('tanggal', $tgl_absen)
			->where('id_company', $karyawan->id_company)
			->get()
			->row();

		$jam_kerja = $this->db->select('masuk, pulang, libur')
			->from('jam_kerja')
			->where('id_company', $karyawan->id_company)
			->where('id_cabang', $karyawan->id_cabang)
			->where('hari', $day)
			->get()
			->row();

		if ($holiday != null) {
			$is_libur = true;
			$keterangan = $holiday->keterangan;
		} else {
			if ($jam_kerja != null) {
				if ($jam_kerja->libur == '1') {
					$is_libur = true;
					$keterangan = 'Hari Libur Mingguan';
				}
			}
		}

		$data['is_libur'] 	= $is_libur;
		$data['data']		= $jam_kerja;
		$data['keterangan'] = $keterangan;
		return $data;
	}

	private function diffminute($from, $to)
	{
		$from_time = strtotime($from);
		$to_time = strtotime($to);
		return round(abs($to_time - $from_time) / 60, 2);
	}

	public function save()
	{

		$karyawan 			= $this->input->post('id_karyawan');
		$tanggal 			= date('Y-m-d', strtotime($this->input->post('tgl_absen')));
		$kode_absensi 		= $this->input->post('kode_absensi');
		$jam_kerja 			= $this->input->post('jam_kerja');
		$id_shift 			= $this->input->post('id_shift');
		$absen_masuk 		= $this->input->post('absen_masuk');
		$absen_pulang 		= $this->input->post('absen_pulang');
		$istirahat_mulai 	= $this->input->post('istirahat_mulai');
		$istirahat_selesai 	= $this->input->post('istirahat_selesai');

		$t_absen_masuk 		= $tanggal . ' ' . $absen_masuk;
		$t_absen_pulang 	= $tanggal . ' ' . $absen_pulang;
		$t_istirahat_mulai 	= $tanggal . " " . $istirahat_mulai;
		$t_istirahat_selesai = $tanggal . " " . $istirahat_selesai;

		// $get_karyawan 	= $this->db_model->get('data_karyawan', 'id_karyawan, nama_lengkap, id_cabang, id_departemen, id_jabatan', ['id_karyawan' => $karyawan])->row();

		$cek_absensi_rekap 		= $this->data_absen->cek_absensi_rekap($karyawan, $tanggal);
		$cek_absensi_masuk 		= $this->data_absen->cek_absensi_masuk($karyawan, $tanggal);
		$cek_absensi_pulang 	= $this->data_absen->cek_absensi_pulang($karyawan, $tanggal);
		$cek_istirahat_mulai 	= $this->data_absen->cek_istirahat_mulai($karyawan, $tanggal);
		$cek_istirahat_selesai 	= $this->data_absen->cek_istirahat_selesai($karyawan, $tanggal);

		if ($cek_absensi_rekap > 0 or $cek_absensi_masuk > 0 or $cek_absensi_pulang > 0 or $cek_istirahat_mulai > 0
		 or $cek_istirahat_selesai > 0) {
			$respons = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data sudah ada, harap data dihapus terlebih dahulu</font>');

			return __response_save(false, $respons);
		} else {
			$get_karyawan = $this->db->select('k.nik, k.nama_lengkap, k.id_company, k.id_cabang,
			c.kode as kode_cabang, c.nama as nama_cabang, k.id_departemen, d.kode as kode_departemen,
			d.nama as nama_departemen, k.id_jabatan, j.kode_jabatan, j.nama as nama_jabatan,
			spv.id_karyawan as id_spv, spv.nama_lengkap as nama_spv')
				->join('master_cabang c', 'c.id_cabang=k.id_cabang')
				->join('master_departemen d', 'd.id_departemen=k.id_departemen','left')
				->join('master_jabatan j', 'j.id_jabatan=k.id_jabatan')
				->join('data_karyawan spv','spv.id_karyawan = k.supervisi','left')
				->from('data_karyawan k')
				->where('k.id_karyawan', $karyawan)
				->get()
				->row();

			if ($get_karyawan == null) {
				$respons = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data Karyawan Tidak Ditemukan.</font>');
				return __response_save(false, $respons);
			} else {

				# CEK JIKA LIBUR HANYA BISA INSERT JIKA KODENYA L
				$data_kerja = $this->getJamkerjaDanLibur($tanggal, $get_karyawan);

				if ($kode_absensi == "A" || $kode_absensi == 'L') {
					$tgl_absen 		= $tanggal;
					$hadir 			= $kode_absensi; //"A";
					$ket 			= ($kode_absensi == 'A') ? "Alpha" : "Libur";
					$terlambat 		= 0;
					$pulang_cepat 	= 0;
					$jenis_absen	= ($kode_absensi == 'A') ? "alpha" : "libur";
					$m_jam_kerja = new StdClass();
					$m_jam_kerja->masuk = '00:00:00';
					$m_jam_kerja->pulang = '00:00:00';

					if ($kode_absensi == 'A') {
						$is_libur = $data_kerja['is_libur'];
						$ket_libur = $data_kerja['keterangan'];
					} elseif ($kode_absensi == 'L') {
						$is_libur = false;
					} else {
						$is_libur = true;
						$ket_libur = 'Undefined';
					}
				} else {
					$jenis_absen = $jam_kerja;
					$tgl_absen = $tanggal;

					if ($jenis_absen == 'shift') {

						$is_libur = false;
						$ket_libur = '';

						$get_shift = $this->db->select('jam_masuk as masuk, jam_pulang as pulang, kode_shift, nama_shift, start_absen_masuk, flag_jam_pulang, batas_absen_pulang, libur')
							->from('master_shift')
							->where('id_master_shift', $id_shift)
							->get()
							->row();

						if ($get_shift != null) {
							$m_jam_kerja = $get_shift;

							$hadir = '';
							$ket = $get_shift->nama_shift;

							$t_start_absen = $tanggal . ' ' . $get_shift->start_absen_masuk;
							$t_jam_masuk   = $tanggal . ' ' . $get_shift->masuk;

							if($get_shift->libur == "1"){
								$jenis_absen = 'libur';
								$hadir = $get_shift->kode_shift;
								$terlambat = 0;
								$pulang_cepat = 0;
							}else{
								if (strtotime($t_absen_masuk) < strtotime($t_start_absen)) {
									// lewat hari, sudah pasti telat
									$tanggal_modified = date('Y-m-d', strtotime('+1 days' . $tanggal));

									$t_absen_masuk 		= $tanggal_modified . ' ' . $absen_masuk;
								} else {
									if ($get_shift->flag_jam_pulang == '1') {
										$t_batas_pulang = $tanggal . ' ' . $get_shift->batas_absen_pulang;

										if (strtotime($t_absen_pulang) > strtotime($t_batas_pulang) && $absen_pulang != "") {
											$tanggal_modified = $tanggal;
										} else {
											$tanggal_modified = date('Y-m-d', strtotime('+1 days' . $tanggal));
										}
									} else {
										$tanggal_modified = $tanggal;
									}
								}

								$t_jam_pulang = $tanggal . ' ' . $get_shift->pulang;
								if ($get_shift->flag_jam_pulang == '1') {
									$t_pulang 			= date('Y-m-d', strtotime('+1 days' . $tanggal));
									$t_jam_pulang		= $t_pulang . ' ' . $get_shift->pulang;
								}

								$t_absen_pulang 	= $tanggal_modified . ' ' . $absen_pulang;

								$t_istirahat_mulai 	= $tanggal_modified . " " . $istirahat_mulai;
								$t_istirahat_selesai = $tanggal_modified . " " . $istirahat_selesai;



								if (strtotime($t_absen_masuk) > strtotime($t_jam_masuk)) {
									$hadir_masuk 	= $get_shift->kode_shift . ',(T)';
									$hadir 			= $hadir_masuk;
									$terlambat 		= $this->diffminute($t_jam_masuk, $t_absen_masuk);
								} else {
									$hadir_masuk	= $get_shift->kode_shift;
									$hadir			= $hadir_masuk;
									$terlambat 		= 0;
								}

								if ((strtotime($t_absen_pulang) < strtotime($t_jam_pulang)) && $absen_pulang != "") {
									$hadir .= ",(PC)";
									$pulang_cepat = $this->diffminute($t_absen_pulang, $t_jam_pulang);
								} elseif ($absen_pulang == "") {
									$hadir .= ",(TAP)";
									$pulang_cepat = 0;
								} else {
									$pulang_cepat = 0;
								}
							}


						} else {
							#tidak valid
							$respons = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data shift tidak valid.</font>');
							return __response_save(false, $respons);
						}
					} else {
						$is_libur = $data_kerja['is_libur'];
						$ket_libur = $data_kerja['keterangan'];

						$jam_kerja = $data_kerja['data'];
						$m_jam_kerja = $jam_kerja;
						// $jam_kerja = $this->db_model->get('jam_kerja', 'masuk, pulang, libur', ['id_cabang' => $get_karyawan->id_cabang, 'hari' => $day])->row();

						$hadir = "";
						$ket = "Reguler";
						if (strtotime($absen_masuk) > strtotime($jam_kerja->masuk)) {
							$hadir_masuk	= "H,(T)";
							$hadir		   .= $hadir_masuk;
							$terlambat 		= $this->diffminute($jam_kerja->masuk, $absen_masuk);
						} else {
							$hadir_masuk	= "H";
							$hadir		   .= $hadir_masuk;
							$terlambat = 0;
						}

						if ((strtotime($absen_pulang) < strtotime($jam_kerja->pulang)) && $absen_pulang != "") {
							$hadir .= ",(PC)";
							// $ket   = "Hadir Pulang Cepat";
							$pulang_cepat = $this->diffminute($jam_kerja->pulang, $absen_pulang);
						} elseif ($absen_pulang == "") {
							$hadir .= ",(TAP)";
							// $ket   = "Tidak Absen Pulang";
							$pulang_cepat = 0;
						} else {
							$pulang_cepat = 0;
						}
					}
				}
				if ($is_libur === true) {
					$respons = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Tidak Dapat Menambahkan Absen Pada ' . $ket_libur . '.</font>');
					return __response_save(false, $respons);
				} else {
					$id_company 		= $get_karyawan->id_company;
					$id_absensi_masuk 	= "";
					$save_absensi = $insert_rekap = $insert_absensi_masuk = $insert_absensi_pulang =
					$insert_istirahat_mulai = $insert_istirahat_selesai = false;
					$tanggal_sekarang	= date('Y-m-d');

					if($tgl_absen != $tanggal_sekarang) {
						$data_absensi = array(
							'id_karyawan' 	=> $karyawan,
							'nik'   			=> $get_karyawan->nik,
							'nama_karyawan'   	=> $get_karyawan->nama_lengkap,
							'id_cabang'			=> $get_karyawan->id_cabang,
							'kode_cabang' 		=> $get_karyawan->kode_cabang,
							'nama_cabang' 		=> $get_karyawan->nama_cabang,
							'id_departemen' 	=> $this->set_empty_from_null($get_karyawan->id_departemen),
							'kode_departemen' 	=> $this->set_empty_from_null($get_karyawan->kode_departemen),
							'nama_departemen' 	=> $this->set_empty_from_null($get_karyawan->nama_departemen),
							'id_jabatan' 		=> $get_karyawan->id_jabatan,
							'kode_jabatan'		=> $get_karyawan->kode_jabatan,
							'nama_jabatan'		=> $get_karyawan->nama_jabatan,
							'supervisi'			=> $this->set_empty_from_null($get_karyawan->id_spv),
							'nama_supervisi'	=> $this->set_empty_from_null($get_karyawan->nama_spv),
							'tgl_absen' 		=> $tgl_absen,
							'jenis_absen' 		=> $jenis_absen,
							'kode_absensi' 		=> $hadir,
							'ket_kode'			=> $ket,
							'jam_masuk_kerja' 	=> $m_jam_kerja->masuk,
							'jam_pulang_kerja'	=> $m_jam_kerja->pulang,
							'absen_masuk' 		=> ($absen_masuk != '') ? $t_absen_masuk : '', // $t_absen_masuk
							'absen_pulang'		=> ($absen_pulang != '') ? $t_absen_pulang : '',
							'absen_ist_mulai'	=> ($istirahat_mulai != '') ? $t_istirahat_mulai : '',
							'absen_ist_selesai' => ($istirahat_selesai != '') ? $t_istirahat_selesai : '',
							'terlambat'			=> $terlambat,
							'pulang_cepat'		=> $pulang_cepat,
							'id_company' 		=> $id_company
						);
						$insert_rekap = $this->db->insert('r_absensi', $data_absensi);
					}

					if($absen_masuk != "" and $hadir != 'A' and $jenis_absen != 'libur') {
						//jam masuk di set -> insert absensi masuk
						$id_absensi_masuk	= $this->getId($id_company, 'absensi_masuk');
						$data_absensi_masuk = array(
							'id_absensi_masuk'	=> $id_absensi_masuk,
							'id_karyawan'		=> $karyawan,
							'tgl_absen'			=> $tgl_absen,
							'jenis_absen'		=> $jenis_absen,
							'terlambat'			=> $terlambat,
							'kode_absen'		=> $hadir_masuk,
							'ket_kode'			=> $ket,
							'jam_kerja' 		=> $m_jam_kerja->masuk,
							'jam_absen' 		=> ($absen_masuk != '') ? $t_absen_masuk : null,
							'id_company'		=> $id_company
						);
						$insert_absensi_masuk = $this->data_absen->insert_absensi_masuk($data_absensi_masuk);
					}

					if($absen_pulang != "" and $hadir != 'A' and $jenis_absen != 'libur') {
						//jam pulang di set -> insert absensi pulang
						$id_absensi_pulang	= $this->getId($id_company, 'absensi_pulang');
						$data_absensi_pulang = array(
							'id_absensi_pulang'	=> $id_absensi_pulang,
							'id_karyawan'		=> $karyawan,
							'id_masuk'			=> $id_absensi_masuk,
							'tgl_absen'			=> $tgl_absen,
							'pulang_cepat'		=> $pulang_cepat,
							'jam_kerja' 		=> $m_jam_kerja->pulang,
							'jam_absen' 		=> ($absen_pulang != '') ? $t_absen_pulang : null,
							'id_company'		=> $id_company
						);
						$insert_absensi_pulang = $this->data_absen->insert_absensi_pulang($data_absensi_pulang);
					}

					if($istirahat_mulai != "" and $hadir != 'A' and $jenis_absen != 'libur') {
						//jam istirahat mulai diset -> insert istirahat mulai
						$data = array(
							'id_istmulai'		=> $this->getId($id_company, 'istirahat_mulai'),
							'id_absensi_masuk'	=> $id_absensi_masuk,
							'id_karyawan'		=> $karyawan,
							'tgl_absen'			=> $tgl_absen,
							'jam_absen'			=> $t_istirahat_mulai,
							'id_company'		=> $id_company
						);
						$insert_istirahat_mulai = $this->data_absen->insert_istirahat_mulai($data);
					}

					if($istirahat_selesai != "" and $hadir != 'A' and $jenis_absen != 'libur') {
						//jam istirahat selesai di set -> insert istirahat selesai
						$data = array(
							'id_istselesai'		=> $this->getId($id_company, 'istirahat_selesai'),
							'id_absensi_masuk'	=> $id_absensi_masuk,
							'id_karyawan'		=> $karyawan,
							'tgl_absen'			=> $tgl_absen,
							'jam_absen'			=> $t_istirahat_selesai,
							'id_company'		=> $id_company
						);
						$insert_istirahat_selesai = $this->data_absen->insert_istirahat_selesai($data);
					}

					if($insert_rekap == true or $insert_absensi_masuk == true or $insert_absensi_pulang == true or
					$insert_istirahat_mulai == true or $insert_istirahat_selesai == true) {
						//jika salah satu insert berhasil maka set save absensi true
						$save_absensi = true;
					}

					return __response_save($save_absensi);
				}
			}
		}
	}

	function set_empty_from_null($id) {
		if($id == null) {
			return '';
		} else {
			return $id;
		}
	}

	public function update()
	{
		$hadir_masuk = "";

		$karyawan 			= $this->input->post('id_karyawan');
		$tanggal 			= ($this->input->post('tgl_absen') !== null) ? date('Y-m-d', strtotime($this->input->post('tgl_absen'))) : null;

		#jika post tgl_absen tidak ada maka akan di overwrite dengan post tanggal
		$tanggal 			= ($this->input->post('tanggal') !== null) ? date('Y-m-d', strtotime($this->input->post('tanggal'))) : null;
		$kode_absensi 		= $this->input->post('kode_absensi');
		$jam_kerja 			= $this->input->post('jam_kerja');
		$id_shift 			= $this->input->post('id_shift');
		$absen_masuk 		= $this->input->post('absen_masuk');
		$absen_pulang 		= $this->input->post('absen_pulang');
		$istirahat_mulai 	= $this->input->post('istirahat_mulai');
		$istirahat_selesai 	= $this->input->post('istirahat_selesai');

		$t_absen_masuk 		= $tanggal . ' ' . $absen_masuk;
		$t_absen_pulang 	= $tanggal . ' ' . $absen_pulang;
		$t_istirahat_mulai 	= $tanggal . " " . $istirahat_mulai;
		$t_istirahat_selesai = $tanggal . " " . $istirahat_selesai;

		$cek_absensi_rekap 		= $this->data_absen->cek_absensi_rekap($karyawan, $tanggal);
		$cek_absensi_masuk 		= $this->data_absen->cek_absensi_masuk($karyawan, $tanggal);
		$cek_absensi_pulang 	= $this->data_absen->cek_absensi_pulang($karyawan, $tanggal);
		$cek_istirahat_mulai 	= $this->data_absen->cek_istirahat_mulai($karyawan, $tanggal);
		$cek_istirahat_selesai 	= $this->data_absen->cek_istirahat_selesai($karyawan, $tanggal);

		if ($cek_absensi_rekap == 0 and $cek_absensi_masuk == 0) {
			$respons = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Error, Data absensi tidak ditemukan.</font>');

			return __response_save(false, $respons);
		} else {

			$get_karyawan = $this->db->select('k.nik, k.nama_lengkap, k.id_company, k.id_cabang, c.kode as kode_cabang, c.nama as nama_cabang, k.id_departemen, d.kode as kode_departemen, d.nama as nama_departemen, k.id_jabatan, j.kode_jabatan, j.nama as nama_jabatan')
				->join('master_cabang c', 'c.id_cabang=k.id_cabang')
				->join('master_departemen d', 'd.id_departemen=k.id_departemen','left')
				->join('master_jabatan j', 'j.id_jabatan=k.id_jabatan')
				->from('data_karyawan k')
				->where('k.id_karyawan', $karyawan)
				->get()
				->row();

			if ($get_karyawan == null) {
				$respons = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data Karyawan Tidak Ditemukan.</font>');
				return __response_save(false, $respons);
			} else {

				# CEK JIKA LIBUR HANYA BISA INSERT JIKA KODENYA L
				$data_kerja = $this->getJamkerjaDanLibur($tanggal, $get_karyawan);

				if ($kode_absensi == "A" || $kode_absensi == 'L') {
					$tgl_absen 		= $tanggal;
					$hadir 			= $kode_absensi; //"A";
					$ket 			= ($kode_absensi == 'A') ? "Alpha" : "Libur";
					$terlambat 		= 0;
					$pulang_cepat 	= 0;
					$jenis_absen	= ($kode_absensi == 'A') ? "alpha" : "libur";
					$m_jam_kerja = new StdClass();
					$m_jam_kerja->masuk = '00:00:00';
					$m_jam_kerja->pulang = '00:00:00';

					if ($kode_absensi == 'A') {
						$is_libur = $data_kerja['is_libur'];
						$ket_libur = $data_kerja['keterangan'];
					} elseif ($kode_absensi == 'L') {
						$is_libur = false;
					} else {
						$is_libur = true;
						$ket_libur = 'Undefined';
					}
				} else {
					$jenis_absen = $jam_kerja;
					$tgl_absen = $tanggal;

					if ($jenis_absen == 'shift') {

						$is_libur = false;
						$ket_libur = '';

						$get_shift = $this->db->select('jam_masuk as masuk, jam_pulang as pulang, kode_shift, nama_shift, start_absen_masuk, flag_jam_pulang, batas_absen_pulang, libur')
							->from('master_shift')
							// ->where('id_master_shift', $cek_shift->id_master_shift)
							->where('id_master_shift', $id_shift)
							->get()
							->row();

						if ($get_shift != null) {
							$m_jam_kerja = $get_shift;

							$hadir = '';
							$ket = $get_shift->nama_shift;

							$t_start_absen = $tanggal . ' ' . $get_shift->start_absen_masuk;
							$t_jam_masuk   = $tanggal . ' ' . $get_shift->masuk;

							if($get_shift->libur == "1"){
								$jenis_absen = 'libur';
								$hadir_masuk = $get_shift->kode_shift;
								$hadir = $hadir_masuk;
								$terlambat = 0;
								$pulang_cepat = 0;
							}else{
								if (strtotime($t_absen_masuk) < strtotime($t_start_absen)) {
									// lewat hari, sudah pasti telat
									$tanggal_modified = date('Y-m-d', strtotime('+1 days' . $tanggal));

									$t_absen_masuk 		= $tanggal_modified . ' ' . $absen_masuk;
								} else {
									if ($get_shift->flag_jam_pulang == '1') {
										$t_batas_pulang = $tanggal . ' ' . $get_shift->batas_absen_pulang;

										if (strtotime($t_absen_pulang) > strtotime($t_batas_pulang) && $absen_pulang != "") {
											$tanggal_modified = $tanggal;
										} else {
											$tanggal_modified = date('Y-m-d', strtotime('+1 days' . $tanggal));
										}
									} else {
										$tanggal_modified = $tanggal;
									}
								}

								$t_jam_pulang = $tanggal . ' ' . $get_shift->pulang;
								if ($get_shift->flag_jam_pulang == '1') {
									$t_pulang 			= date('Y-m-d', strtotime('+1 days' . $tanggal));
									$t_jam_pulang		= $t_pulang . ' ' . $get_shift->pulang;
								}

								$t_absen_pulang 	= $tanggal_modified . ' ' . $absen_pulang;

								$t_istirahat_mulai 	= $tanggal_modified . " " . $istirahat_mulai;
								$t_istirahat_selesai = $tanggal_modified . " " . $istirahat_selesai;



								if (strtotime($t_absen_masuk) > strtotime($t_jam_masuk)) {
									$hadir_masuk 	= $get_shift->kode_shift . ',(T)';
									$hadir 			= $hadir_masuk;
									$terlambat = $this->diffminute($t_jam_masuk, $t_absen_masuk);
								} else {
									$hadir_masuk 	= $get_shift->kode_shift;
									$hadir			= $hadir_masuk;
									$terlambat = 0;
								}

								if ((strtotime($t_absen_pulang) < strtotime($t_jam_pulang)) && $absen_pulang != "") {
									$hadir .= ",(PC)";
									$pulang_cepat = $this->diffminute($t_absen_pulang, $t_jam_pulang);
								} elseif ($absen_pulang == "") {
									$hadir .= ",(TAP)";
									$pulang_cepat = 0;
								} else {
									$pulang_cepat = 0;
								}
							}



						} else {
							#tidak valid
							$respons = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data shift tidak valid.</font>');
							return __response_save(false, $respons);
						}
					} else {
						$is_libur = $data_kerja['is_libur'];
						$ket_libur = $data_kerja['keterangan'];

						$jam_kerja = $data_kerja['data'];
						$m_jam_kerja = $jam_kerja;

						$hadir = "";
						$ket = "Reguler";
						if (strtotime($absen_masuk) > strtotime($jam_kerja->masuk)) {
							$hadir_masuk = "H,(T)";
							$hadir .= $hadir_masuk;
							$terlambat = $this->diffminute($jam_kerja->masuk, $absen_masuk);
						} else {
							$hadir_masuk = "H";
							$hadir .= $hadir_masuk;
							$terlambat = 0;
						}

						if ((strtotime($absen_pulang) < strtotime($jam_kerja->pulang)) && $absen_pulang != "") {
							$hadir .= ",(PC)";
							$pulang_cepat = $this->diffminute($jam_kerja->pulang, $absen_pulang);
						} elseif ($absen_pulang == "") {
							$hadir .= ",(TAP)";
							$pulang_cepat = 0;
						} else {
							$pulang_cepat = 0;
						}
					}
				}

				if ($is_libur === true) {
					$respons = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Tidak Dapat Menambahkan Absen Pada ' . $ket_libur . '.</font>');
					return __response_save(false, $respons);
				} else {
					$update_absensi = $update_rekap = $update_absensi_masuk = $update_absensi_pulang =
					$update_istirahat_mulai = $update_istirahat_selesai = false;
					if($cek_absensi_rekap > 0) {
						//terdapat absensi rekap dan jam masuk di set -> update rekap
						$data_absensi = array(
							'jenis_absen' 		=> $jenis_absen,
							'terlambat'   		=> $terlambat,
							'kode_absensi'  	=> $hadir,
							'ket_kode'			=> $ket,
							'pulang_cepat' 		=> $pulang_cepat,
							'jam_masuk_kerja' 	=> $m_jam_kerja->masuk,
							'jam_pulang_kerja'	=> $m_jam_kerja->pulang,
							'absen_masuk' 		=> ($absen_masuk != '') ? $t_absen_masuk : null,
							'absen_pulang'		=> ($absen_pulang != '') ? $t_absen_pulang : null,
							'absen_ist_mulai'	=> ($istirahat_mulai != '') ? $t_istirahat_mulai : null,
							'absen_ist_selesai' => ($istirahat_selesai != '') ? $t_istirahat_selesai : null,
						);
						$update_rekap = $this->db->where('id_karyawan', $karyawan)
							->where('tgl_absen', $tgl_absen)
							->update('r_absensi', $data_absensi);
					}

					if($cek_absensi_masuk > 0 and $absen_masuk != "") {
						//terdapat absensi masuk dan jam masuk di set -> update absensi masuk
						$data_absensi_masuk = array(
							'jenis_absen'	=> $jenis_absen,
							'terlambat'		=> $terlambat,
							'kode_absen'	=> $hadir_masuk,
							'ket_kode'		=> $ket,
							'jam_kerja' 	=> $m_jam_kerja->masuk,
							'jam_absen' 	=> ($absen_masuk != '') ? $t_absen_masuk : null
						);
						$update_absensi_masuk = $this->data_absen->update_absensi_masuk($data_absensi_masuk, $karyawan, $tgl_absen);
					}

					if($cek_absensi_pulang > 0 and $absen_pulang != "") {
						//terdapat absensi pulang dan jam pulang di set -> update absensi pulang
						$data_absensi_pulang = array(
							'pulang_cepat'	=> $pulang_cepat,
							'jam_kerja' 	=> $m_jam_kerja->pulang,
							'jam_absen' 	=> ($absen_pulang != '') ? $t_absen_pulang : null,
						);
						$update_absensi_pulang = $this->data_absen->update_absensi_pulang($data_absensi_pulang, $karyawan, $tgl_absen);
					}

					if($cek_istirahat_mulai > 0 and $istirahat_mulai != "") {
						//terdapat istirahat mulai dan jam istirahat mulai diset -> update istirahat mulai
						$data = array(
							'jam_absen'	=> $t_istirahat_mulai
						);
						$update_istirahat_mulai = $this->data_absen->update_istirahat_mulai($data, $karyawan, $tgl_absen);
					}

					if($cek_istirahat_selesai > 0 and $istirahat_selesai != "") {
						//tedapat istirahat selesai dan jam istirahat selesai di set -> update istirahat selesai
						$data = array(
							'jam_absen'	=> $t_istirahat_selesai
						);
						$update_istirahat_selesai = $this->data_absen->update_istirahat_selesai($data, $karyawan, $tgl_absen);
					}

					if($update_rekap == true or $update_absensi_masuk == true or $update_absensi_pulang == true or
					$update_istirahat_mulai == true or $update_istirahat_selesai == true) {
						//jika salah satu update berhasil maka set update absensi true
						$update_absensi = true;
					}

					return __response_save($update_absensi);
				}
			}
		}
	}

	public function delete($id_karyawan = null, $tanggal = null){
		$this->db->where(array('id_karyawan' => $id_karyawan, 'tgl_absen' => $tanggal));
		$this->db->delete('absensi_masuk');

		$this->db->where(array('id_karyawan' => $id_karyawan, 'tgl_absen' => $tanggal));
		$this->db->delete('absensi_pulang');

		$this->db->where(array('id_karyawan' => $id_karyawan, 'tgl_absen' => $tanggal));
		$this->db->delete('istirahat_mulai');

		$this->db->where(array('id_karyawan' => $id_karyawan, 'tgl_absen' => $tanggal));
		$this->db->delete('istirahat_selesai');

		$this->db->where(array('id_karyawan' => $id_karyawan, 'tgl_absen' => $tanggal));
		$delete = $this->db->delete('r_absensi');

		return  __response_delete($delete);
	}

	function download(){

		$filter['periode_awal']		= date_format(date_create($this->input->get('periode_awal')),"Y-m-d");
		$filter['periode_akhir']	= date_format(date_create($this->input->get('periode_akhir')),"Y-m-d");


		$filter['hadir']          = $this->input->get('hadir');
		$filter['terlambat']      = $this->input->get('terlambat');
		$filter['pc']             = $this->input->get('pc');
		$filter['tap']            = $this->input->get('tap');
		$filter['alpa']           = $this->input->get('alpa');
		$filter['sakit']          = $this->input->get('sakit');
		$filter['izin']           = $this->input->get('izin');
		$filter['cuti']           = $this->input->get('cuti');
		$filter['libur']          = $this->input->get('libur');

		$filter['id_cabang']     	= $this->input->get('id_cabang');
		$filter['id_departemen']	= $this->input->get('id_departemen');
		$filter['id_karyawan']		= $this->input->get('id_karyawan');

		$jenis	= $this->input->get('jenis');

		if($filter['id_karyawan'] != "0") {
			$nama = $this->data_absen->nama_karyawan($filter['id_karyawan']);
			$filename = "Laporan Absensi " . $nama;
		} else {
			if($data['id_cabang'] == "0"){
				$filename = "Laporan Absensi Semua Cabang";
			}else{
				if($filter['id_departemen'] != "0") {
					$nama_cab 	  = $this->data_absen->nama_cabang($filter['id_cabang']);
					$nama_dep 	  = $this->data_absen->nama_departemen($filter['id_departemen']);
					$nama 		  = " Cabang " . $nama_cab . ", Departemen " . str_replace("/","-",$nama_dep);
					$filename 	  = "Laporan Absensi " . $nama;
				}else {
					$nama 	  = $this->data_absen->nama_cabang($filter['id_cabang']);
					$filename = "Laporan Absensi Cabang " . $nama . " Semua Departemen";
				}
			}

		}

		$data['nama'] = $nama;
		$data['tanggal_mulai'] 		= date('d-m-Y', strtotime($filter['periode_awal']));
		$data['tanggal_selesai'] 	= date('d-m-Y', strtotime($filter['periode_akhir']));
		$data['jenis']	= $jenis;
		$data['title']	= $filename;

		$periode_mulai 		= date_create($filter['periode_awal']);
		$periode_selesai	= date_create(date('Y-m-d', strtotime('+1 days '.$filter['periode_akhir'])));
		$interval = DateInterval::createFromDateString('1 day');
		$periode = new DatePeriod($periode_mulai, $interval, $periode_selesai);
		$data['periode'] = $periode;

		$data['data'] = $this->data_absen->download($filter);

		$output = true;
		if ($jenis == "excel") {

			$data['is_excel'] = true;
			$sb_view = $this->load->view('data_absensi/download', $data, $output);
			$c_length = 15;

			$param = [
				'download' => true,
				'cLength'    => $c_length,
				'file_name'    => strtoupper($filename),
				'paper_size'	=> 'LEGAL',
				'font-size'		=> 9,
				'pagebreak'		=> true,
				'page_margin'	=> ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
				'orientation'	=> 'landscape',
				'header'    => [
					'1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
					'2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
					'3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],

					'4' => ['weight' => 'bold'],
					'5' => ['weight' => 'bold'],
					'6' => ['weight' => 'bold'],
				],
				'thead'        => ['8', '9'],
				'tbody'        => [
					'start' => '8',
					'height'	=> 13,
					'jarak_footer'	=> 2,
					'runFunction'	=> ['highlightlibur' => 'P'],
					'wrap' => ['C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P'],
					'column' => [
						'A'    => ['width' => 3, 'align' => 'center', 'valign' => 'middle'],
						'B'    => ['width' => 10, 'align' => 'center', 'valign' => 'middle'],
						'C'    => ['width' => 13, 'align' => 'center', 'valign' => 'middle'],

						'D'    => ['width' => 7, 'align' => 'center', 'valign' => 'top'],
						'E'    => ['width' => 14, 'align' => 'center', 'valign' => 'top'],
						'F'    => ['width' => 17, 'align' => 'center', 'valign' => 'top'],
						'G'    => ['width' => 7, 'align' => 'center', 'valign' => 'top'],
						'H'    => ['width' => 10, 'align' => 'center', 'valign' => 'top'],
						'I'    => ['width' => 12, 'align' => 'center', 'valign' => 'top'],
						'J'    => ['width' => 7, 'align' => 'center', 'valign' => 'top'],
						'K'    => ['width' => 10, 'align' => 'center', 'valign' => 'top'],
						'L'    => ['width' => 12, 'align' => 'center', 'valign' => 'top'],
						'M'    => ['width' => 7, 'align' => 'center', 'valign' => 'top'],
						'N'    => ['width' => 14, 'align' => 'center', 'valign' => 'top'],
						'O'    => ['width' => 17, 'align' => 'center', 'valign' => 'top'],
						'P'    => ['width' => 0, 'align' => 'center', 'valign' => 'top'],
					],
				],
			];

			if ($output) {
				$this->load->library('PHPExcel/Excel');
				$this->excel->generateExcel($sb_view, $param);
			}
		} else {
			$data['is_excel'] = false;
			$html = $this->load->view('data_absensi/download', $data, $output);

			if ($output) {
				$nama_company = $this->db->select("nama")->from("master_company")->where("id_company",$this->id_company)->get()->row("nama");

				$this->load->library('mpdf');
				$param['page_number'] = true;
				$param['show_watermark'] = false;
				$param['custom_font'] = false;
				$param['download']	= true;
				$param['nama_company']	= $nama_company;
				$this->mpdf->generate($html,  $filename, 'LEGAL', 'L', $param);
			}
		}
	}

	function nama_file($jenis, $id)
	{
		if ($jenis == "excel_per_opd" or $jenis == "pdf_per_opd") {
			$result = $this->data_absen->nama_opd($id);
		} else {
		}

		return $result;
	}

	function getId($id_company = null, $table = null){
		$curent_month = date('Ym');
		$field = $this->getFieldId($table);

		$select = $this->db->query("SELECT MAX($field) AS id
									FROM $table
									WHERE id_company = '$id_company'
									AND SUBSTR($field,-11,6) = DATE_FORMAT(CURRENT_DATE(),'%Y%m')")->row();

		if(!empty($select->id)){
			$maxid = substr($select->id,-5);
			$nextid = $id_company.$curent_month.sprintf("%05d", ($maxid+1));
		}else{
			$nextid = $id_company.$curent_month.'00001';
		}

		return $nextid;

	}

	function getFieldId($table = null){
		switch ($table) {
			case "absensi_masuk":
				return "id_absensi_masuk";
				break;
			case "absensi_pulang":
				return "id_absensi_pulang";
				break;
			case "istirahat_mulai":
				return "id_istmulai";
				break;
			case "istirahat_selesai":
				return "id_istselesai";
				break;
			case "lembur_mulai":
				return "id_lemmulai";
				break;
			case "lembur_selesai":
				return "id_lemselesai";
				break;
			case "r_lembur":
				return "id_lembur";
				break;
			default:
				return "-";
		}
	}
}
