<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Db_model', 'db_model');
        $this->load->model(['Dashboard_m','Dashboard_absensi_m']);
	}

	public function index(){

		$data['judul'] = 'Dashboard';
		$data['aktif'] = 'dashboard';

        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('dashboard', $data, true);
		$this->load->view('main_template', $data, false);
	}

    public function dataLayanan(){
        $paketLayanan = $this->Dashboard_m->paketLayanan();
        $ttlKaryawanAktif = $this->Dashboard_m->ttlKaryawanAktif();
        $masaLayanan = $this->Dashboard_m->masaLayanan();

        $response = ["success" => true,
                        "data" =>[
                            "nm_paket"              => $paketLayanan->nm_paket,
                            "max_karyawan"          => $paketLayanan->max_karyawan,
                            "ttl_karyawan_aktif"    => $ttlKaryawanAktif,
                            "masa_layanan"          => $this->fungsi->tgl_indo($masaLayanan->tgl_aktif)." - ".$this->fungsi->tgl_indo($masaLayanan->tgl_berakhir)
                        ]
                    ];

        echo json_encode($response);
    }

    public function dashboard_list($tp = '')
    {
        if($tp == 'izin')
        {
            $data['dashboard_izin'] = $this->Dashboard_m->dashboard_izin($this->level_user, $this->id_cabang, $this->id_departemen);
            $this->load->view('dashboard_list_izin', $data);
        }

        if($tp == 'lembur')
        {
            $data['dashboard_lembur'] = $this->Dashboard_m->dashboard_lembur($this->level_user, $this->id_cabang, $this->id_departemen);
            $this->load->view('dashboard_list_lembur', $data);
        }

    }

    public function ganti_password(){
        $this->load->view('ganti_password');
    }

    public function save_password(){
        $id_karyawan = $this->input->post('id_karyawan');
        $password_lama = sha1(sha1(md5($this->input->post('password_lama'))));
        $password_baru = $this->input->post('password_baru');
        $konfirmasi_password_baru = $this->input->post('konfirmasi_password_baru');

        $cek_password_lama = $this->db->select('password')
                                        ->from("users")->where("md5(id_karyawan)",$id_karyawan)
                                        ->where("id_company",$this->id_company)
                                        ->get()
                                        ->row()
                                        ->password;
        if ($cek_password_lama != $password_lama) {
            $response = array('success'=>false,
                    'message'=>'Password lama salah');
        }else{
        if ($password_baru != $konfirmasi_password_baru) {
            $response = array('success'=>false,
                    'message'=>'Konfirmasi password baru tidak sesuai');
        }else{
            $data = array('password'    =>sha1(sha1(md5($this->input->post('password_baru')))));
            $this->db->where(array('md5(id_karyawan)'=>$id_karyawan, 'id_company'=>$this->id_company));
            $update = $this->db->update("users",$data);

            if ($update) {
                $response = array('success'=>true,
                        'message'=>'Anda berhasil mengganti password');
            }
        }
        }

        $response = __response($this->MY_response, $response);

        echo json_encode($response);
    }

	function list_cabang_selected(){
		if($this->level_user == 1) {
			$get_pusat = $this->db_model->get("master_cabang","id_cabang, kode, nama",['flag' => '1', 'id_company'=>$this->id_company])->row();
			$json = array('id'=>$get_pusat->id_cabang, 'text'=>$get_pusat->kode." - ".$get_pusat->nama);
		} else {
			$id_cabang = $this->id_cabang;
			$data_cabang = $this->Dashboard_m->data_cabang($id_cabang);
			$json = array('id'=>$data_cabang->id_cabang, 'text'=>$data_cabang->kode." - ".$data_cabang->nama);
		}

		$json = __response($this->MY_response, $json);
		echo json_encode($json);
    }

	function data_pie($id_cabang = "all", $id_shift = "all"){
		$tanggal = date('Y-m-d');

        $hadir 			= $this->Dashboard_absensi_m->count_filtered($id_cabang, "all", $id_shift, 'H');
		$terlambat 		= $this->Dashboard_absensi_m->count_filtered($id_cabang, "all", $id_shift, 'T');
		$belum_absen	= $this->Dashboard_absensi_m->count_filtered($id_cabang, "all", $id_shift, 'A');
        $izin			= $this->Dashboard_absensi_m->count_filtered($id_cabang, "all", $id_shift, 'I');
        $sakit			= $this->Dashboard_absensi_m->count_filtered($id_cabang, "all", $id_shift, 'S');
        $cuti			= $this->Dashboard_absensi_m->count_filtered($id_cabang, "all", $id_shift, 'C');
        // echo $this->db->last_query();

		$json = array("absen" => $hadir,
                        "terlambat"  => $terlambat,
                        "izin"  => $izin,
                        "cuti"  => $cuti,
                        "sakit" => $sakit,
                        "belum_absen" => $belum_absen);

		$json = __response($this->MY_response, $json);

        echo json_encode($json);
	}

    public function data_pie_detail($jenis="", $id_cabang="", $jam_kerja=""){
        $title = "Data Karyawan ".$jenis;

        if($jenis == "hadir"){
            $status = "H";
        }else if($jenis == "terlambat"){
            $status = "T";
        }else if($jenis == "cuti"){
            $status = "C";
        }else if($jenis == "izin"){
            $status = "I";
        }else if($jenis == "sakit"){
            $status = "S";
        }else{
            $status = "A";
        }

        $data["title"]  = $title;
        $data["url"]  = route('dashboard.absensi.detail.list.data')."/".$id_cabang."/all/".$jam_kerja."/".$status;
        $this->load->view('dashboards/form_detail_rekap',$data);
    }

	function notif_izin($view = null){
        $output = '';

        if($this->level_user == '1') {
            $query = $this->db->select("data_izin.id_izin, data_izin.nama_izin, data_izin.tgl_input, data_karyawan.nama_lengkap")
                            ->from("data_izin")
                            ->join("data_karyawan", "data_karyawan.id_karyawan = data_izin.id_karyawan")
                            ->where("data_izin.approval_hrd", '1')
                            ->where("data_izin.status !=", '2')
                            ->where("data_izin.id_company", $this->id_company)
                            ->order_by('data_izin.tgl_input', 'desc')
                            ->get();

        }else if($this->level_user == '2') {
            $query = $this->db->select("data_izin.id_izin, data_izin.nama_izin, data_izin.tgl_input, data_karyawan.nama_lengkap")
                            ->from("data_izin")
                            ->join("data_karyawan", "data_karyawan.id_karyawan = data_izin.id_karyawan")
                            ->where("data_izin.approval_kedep", '1')
                            ->where("data_izin.status !=", '2')
                            ->where("data_izin.id_cabang", $this->id_cabang)
                            ->where("data_izin.id_departemen", $this->id_departemen)
                            ->where("data_izin.id_company", $this->id_company)
                            ->order_by('data_izin.tgl_input', 'desc')
                            ->get();

        }else if($this->level_user == '5') {
            $query = $this->db->select("data_izin.id_izin, data_izin.nama_izin, data_izin.tgl_input, data_karyawan.nama_lengkap")
                        ->from("data_izin")
                        ->join("data_karyawan", "data_karyawan.id_karyawan = data_izin.id_karyawan")
                        ->where("data_izin.approval_kacab", '1')
                        ->where("data_izin.status !=", '2')
                        ->where("data_izin.id_cabang", $this->id_cabang)
                        ->where("data_izin.id_company", $this->id_company)
                        ->order_by('data_izin.tgl_input', 'desc')
                        ->get();

        }else if($this->level_user == '7') {
            $karyawan = $this->db_model->get("data_karyawan", "id_karyawan", ['supervisi' => $this->id_karyawan])->result();
            $target_name_arr = array();
            foreach ($karyawan as $dat) {
                $target_name_arr[] = $dat->id_karyawan;
            }
            $target_id = implode("','", $target_name_arr);

            $query = $this->db->select("data_izin.id_izin, data_izin.nama_izin, data_izin.tgl_input, data_karyawan.nama_lengkap")->from("data_izin")
                        ->join("data_karyawan", "data_karyawan.id_karyawan = data_izin.id_karyawan")
                        ->where("data_izin.approval_spv", '1')
                        ->where("data_izin.status !=", '2')
                        ->where("data_izin.id_cabang", $this->id_cabang)
                        ->where("data_izin.id_departemen", $this->id_departemen)
                        ->where_in('data_izin.id_karyawan',$target_name_arr)
                        ->where("data_izin.id_company", $this->id_company)
                        ->order_by('data_izin.tgl_input', 'desc')
                        ->get();

        }else if($this->level_user == '4') {
            $query = $this->db->select("data_izin.id_izin, data_izin.nama_izin, data_izin.tgl_input, data_karyawan.nama_lengkap")->from("data_izin")
                        ->join("data_karyawan", "data_karyawan.id_karyawan = data_izin.id_karyawan")
                        ->where("data_izin.approval_direksi", '1')
                        ->where("data_izin.status !=", '2')
                        ->where("data_izin.id_company", $this->id_company)
                        ->order_by('data_izin.tgl_input', 'desc')
                        ->get();

        }

        if($query->num_rows() > 0)
        {
            foreach ($query->result() as $row) {
                $output .= '
                <a href="'.site_url().'pengajuan/izin/detail_izin/'.md5($row->id_izin).'">
                <div class="media">
                    <div class="media-left align-self-center"><i class="ft-check-circle icon-bg-circle" style="background-color: red; color: white;"></i></div>
                    <div class="media-body">
                        <h6 class="media-heading mb-0">'.$row->nama_izin.'</h6>
                        <p class="notification-text font-small-3 text-muted mb-0">'.$row->nama_lengkap.'</p>
                        <small>
                        <time class="media-meta text-muted" datetime="2015-06-11T18:29:20+08:00">'.date('d-m-Y', strtotime($row->tgl_input)).'</time>
                        </small>
                    </div>
                </div>
                </a>
                ';
            }
        }

        $count = $query->num_rows();
        if ($count == 0) {
            $output .= ' <div style="text-align:center;" class="boxnotif mt-1 mb-1"><a href="#">Tidak ada notifikasi</a></div>';
        }

        $data = array(
            'notification' => $output,
            'unseen_notification'  => $count
        );

        $data = __response($this->MY_response, $data);
        echo json_encode($data);
    }

    function notif_lembur($view = null){
        $id_karyawan   = $this->id_karyawan;
        $level         = $this->level_user;
        $id_cabang     = $this->id_cabang;
        $id_departemen = $this->id_departemen;
        $id_company    = $this->id_company;

        // if($view != null){
            $output = '';


            if($level == '1'){
                $query = $this->db->select("lembur_mulai.id_lemmulai, lembur_mulai.jam_absen, lembur_mulai.tgl_input, data_karyawan.nama_lengkap")->from("lembur_mulai")
                ->join("data_karyawan", "data_karyawan.id_karyawan = lembur_mulai.id_karyawan", "left")
                ->join("lembur_selesai","lembur_selesai.id_lemmulai = lembur_mulai.id_lemmulai")
                ->where("lembur_mulai.approval_hrd", '1')
                ->where("lembur_mulai.id_company", $id_company)
                ->order_by('lembur_mulai.tgl_input', 'desc')
                ->get();

            }else if($level == '2'){
                $query = $this->db->select("lembur_mulai.id_lemmulai, lembur_mulai.jam_absen, lembur_mulai.tgl_input, data_karyawan.nama_lengkap")->from("lembur_mulai")
                        ->join("data_karyawan", "data_karyawan.id_karyawan = lembur_mulai.id_karyawan", "left")
                        ->join("lembur_selesai","lembur_selesai.id_lemmulai = lembur_mulai.id_lemmulai")
                        ->where("lembur_mulai.approval_kedep", '1')
                        ->where("data_karyawan.id_cabang", $id_cabang)
                        ->where("data_karyawan.id_departemen", $id_departemen)
                        ->where("lembur_mulai.id_company", $id_company)
                        ->order_by('lembur_mulai.tgl_input', 'desc')
                        ->get();

            }else if($level == '5'){
                $query = $this->db->select("lembur_mulai.id_lemmulai, lembur_mulai.jam_absen, lembur_mulai.tgl_input, data_karyawan.nama_lengkap")->from("lembur_mulai")
                        ->join("data_karyawan", "data_karyawan.id_karyawan = lembur_mulai.id_karyawan", "left")
                        ->join("lembur_selesai","lembur_selesai.id_lemmulai = lembur_mulai.id_lemmulai")
                        ->where("lembur_mulai.approval_kacab", '1')
                        ->where("data_karyawan.id_cabang", $id_cabang)
                        ->where("lembur_mulai.id_company", $id_company)
                        ->order_by('lembur_mulai.tgl_input', 'desc')
                        ->get();

            }else if($level == '7'){
                $karyawan = $this->db_model->get("data_karyawan", "id_karyawan", ['supervisi' => $this->id_karyawan])->result();
                $target_name_arr = array();
                foreach ($karyawan as $dat) {
                    $target_name_arr[] = $dat->id_karyawan;
                }
                $target_id = implode("','", $target_name_arr);

                $query = $this->db->select("lembur_mulai.id_lemmulai, lembur_mulai.jam_absen, lembur_mulai.tgl_input, data_karyawan.nama_lengkap")->from("lembur_mulai")
                        ->join("data_karyawan", "data_karyawan.id_karyawan = lembur_mulai.id_karyawan", "left")
                        ->join("lembur_selesai","lembur_selesai.id_lemmulai = lembur_mulai.id_lemmulai")
                        ->where("lembur_mulai.approval_spv", '1')
                        ->where("data_karyawan.id_cabang", $id_cabang)
                        ->where("data_karyawan.id_departemen", $id_departemen)
                        ->where_in("lembur_mulai.id_karyawan", $target_name_arr)
                        ->where("lembur_mulai.id_company", $id_company)
                        ->order_by('lembur_mulai.tgl_input', 'desc')
                        ->get();

            }elseif ($level == '4') {
                $query = $this->db->select("lembur_mulai.id_lemmulai, lembur_mulai.jam_absen, lembur_mulai.tgl_input, data_karyawan.nama_lengkap")->from("lembur_mulai")
                        ->join("data_karyawan", "data_karyawan.id_karyawan = lembur_mulai.id_karyawan", "left")
                        ->join("lembur_selesai","lembur_selesai.id_lemmulai = lembur_mulai.id_lemmulai")
                        ->where("lembur_mulai.approval_direksi", '1')
                        ->where("lembur_mulai.id_company", $id_company)
                        ->order_by('lembur_mulai.tgl_input', 'desc')
                        ->get();

            }

            if($query->num_rows() > 0)
            {
                foreach ($query->result() as $row) {
                    $output .= '
                    <a href="'.site_url().'pengajuan/lembur/detail_lembur/'.md5($row->id_lemmulai).'">
                    <div class="media">
                        <div class="media-left align-self-center"><i class="ft-check-circle icon-bg-circle" style="background-color: orange; color: white;" ></i></div>
                        <div class="media-body">
                            <h6 class="media-heading mb-0">'.$row->nama_lengkap.'</h6>
                            <p class="notification-text font-small-3 text-muted mb-0">Jam Absen : '.$this->fungsi->konversi_datetime($row->jam_absen).'</p>
                            <small>
                                <time class="media-meta text-muted" datetime="2015-06-11T18:29:20+08:00">'.date('d-m-Y', strtotime($row->tgl_input)).'</time>
                            </small>
                        </div>
                    </div>
                    </a>
                    ';
                }
            }

            $count = $query->num_rows();
            if ($count == 0) {
                $output .= ' <div style="text-align:center;" class="boxnotif mt-1 mb-1"><a href="#">Tidak ada notifikasi</a></div>';
            }

            $data = array(
                'notification' => $output,
                'unseen_notification'  => $count
            );

            $data = __response($this->MY_response, $data);
            echo json_encode($data);
        // }
    }

    function notif_reimbursement($view = null){
        $output = '';
        if($this->level_user == '6') {
            $query = $this->db->select("reimbursement_pengajuan.id, reimbursement_pengajuan.no_pengajuan, reimbursement_pengajuan.tgl_pengajuan, data_karyawan.nama_lengkap")
                            ->from("reimbursement_pengajuan")
                            ->join("data_karyawan", "data_karyawan.id_karyawan = reimbursement_pengajuan.id_karyawan", "left")
                            ->where("reimbursement_pengajuan.apv_finance", '1')
                            ->where("reimbursement_pengajuan.id_company", $this->id_company)
                            ->get();

        }else if($this->level_user == '2') {
            $query = $this->db->select("reimbursement_pengajuan.id, reimbursement_pengajuan.no_pengajuan, reimbursement_pengajuan.tgl_pengajuan, data_karyawan.nama_lengkap")
                        ->from("reimbursement_pengajuan")
                        ->join("data_karyawan", "data_karyawan.id_karyawan = reimbursement_pengajuan.id_karyawan", "left")
                        ->where("reimbursement_pengajuan.apv_kedep", '1')
                        ->where("reimbursement_pengajuan.id_cabang", $this->id_cabang)
                        ->where("reimbursement_pengajuan.id_departemen", $this->id_departemen)
                        ->where("reimbursement_pengajuan.id_company", $this->id_company)
                        ->get();

        }else if($this->level_user == '5') {
            $query = $this->db->select("reimbursement_pengajuan.id, reimbursement_pengajuan.no_pengajuan, reimbursement_pengajuan.tgl_pengajuan, data_karyawan.nama_lengkap")
                        ->from("reimbursement_pengajuan")
                        ->join("data_karyawan", "data_karyawan.id_karyawan = reimbursement_pengajuan.id_karyawan", "left")
                        ->where("reimbursement_pengajuan.apv_kacap", '1')
                        ->where("reimbursement_pengajuan.id_cabang", $this->id_cabang)
                        ->where("reimbursement_pengajuan.id_company", $this->id_company)->get();

        }else if($this->level_user == '7') {
            $karyawan = $this->db_model->get("data_karyawan", "id_karyawan", ['supervisi' => $this->id_karyawan])->result();
            $target_name_arr = array();
            foreach ($karyawan as $dat) {
                $target_name_arr[] = $dat->id_karyawan;
            }
            $target_id = implode("','", $target_name_arr);

            $query = $this->db->select("reimbursement_pengajuan.id, reimbursement_pengajuan.no_pengajuan, reimbursement_pengajuan.tgl_pengajuan, data_karyawan.nama_lengkap")
                            ->from("reimbursement_pengajuan")
                            ->join("data_karyawan", "data_karyawan.id_karyawan = reimbursement_pengajuan.id_karyawan", "left")
                            ->where("reimbursement_pengajuan.apv_spv", '1')
                            ->where("reimbursement_pengajuan.id_cabang", $this->id_cabang)
                            ->where("reimbursement_pengajuan.id_departemen", $this->id_departemen)
                            ->where_in("reimbursement_pengajuan.id_karyawan", $target_name_arr)
                            ->where("reimbursement_pengajuan.id_company", $this->id_company)->get();

        }elseif ($level == '4') {
            $query = $this->db->select("reimbursement_pengajuan.id, reimbursement_pengajuan.no_pengajuan, reimbursement_pengajuan.tgl_pengajuan, data_karyawan.nama_lengkap")
                            ->from("reimbursement_pengajuan")
                            ->join("data_karyawan", "data_karyawan.id_karyawan = reimbursement_pengajuan.id_karyawan", "left")
                            ->where("reimbursement_pengajuan.apv_direksi", '1')
                            ->where("reimbursement_pengajuan.id_company", $this->id_company)
                            ->get();
        }

        if($query->num_rows() > 0){
            foreach ($query->result() as $row) {
                $output .= '
                <a href="'.site_url().'reimburse/detail/'.md5($row->id).'">
                <div class="media">
                    <div class="media-left align-self-center"><i class="ft-check-circle icon-bg-circle" style="background-color: green; color: white;" ></i></div>
                    <div class="media-body">
                        <h6 class="media-heading mb-0">'.$row->nama_lengkap.'</h6>
                        <p class="notification-text font-small-3 text-muted">Nomor Pengajuan : '.$row->no_pengajuan.'</p>
                        <small>
                            <time class="media-meta text-muted" datetime="2015-06-11T18:29:20+08:00">'.$this->fungsi->mysql_date_2_date($row->tgl_pengajuan).'</time>
                        </small>
                    </div>
                </div>
                </a>
                ';
            }
        }

            $count = $query->num_rows();
            if ($count == 0) {
                $output .= ' <div style="text-align:center;" class="boxnotif mt-1 mb-1"><a href="#">Tidak ada notifikasi</a></div>';
            }

            $data = array(
                'notification' => $output,
                'unseen_notification'  => $count
            );

            $data = __response($this->MY_response, $data);
            echo json_encode($data);

    }
}
