<script>
    $(function() {
        dropdown_bulan();
        dropdown_group();
        dropdown_karyawan();
        download_excel_all()
    });

    function dropdown_bulan() {
        $("#form_input #periode").inputmask({
            'alias': 'datetime',
            'inputFormat': 'mm-yyyy'
        });

        $("#form_input #periode").datepicker({
            format: "mm-yyyy",
            viewMode: "months",
            orientation: 'bottom',
            minViewMode: "months",
            autoclose: true,
        });
    }

    function dropdown_group(){
        let periode = $("#form_input #periode").val() ? $("#form_input #periode").val() : "00-0000";
        $("#form_input #id_group").select2({
            placeholder: "Semua Group",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.report.download.semua.dropdown.group") ?>'+'?periode='+periode,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function dropdown_karyawan() {
        let periode  = $("#form_input #periode").val() ? $("#form_input #periode").val() : "00-0000";
        let id_group = $("#form_input #id_group").val() ? $("#form_input #id_group").val() : "all";

        $("#form_input #id_karyawan").select2({
            placeholder: "Semua Sales",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.report.download.semua.dropdown.karyawan") ?>' + '?periode=' + periode + '&id_group=' + id_group,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function onchange_periode_input(){
        $("#form_input #id_group").val('').trigger('change');
        $("#form_input #id_karyawan").val('').trigger('change');
        dropdown_group();
        dropdown_karyawan();
    }

    function onchange_group_input() {
        $("#form_input #id_karyawan").val('').trigger('change');
        dropdown_karyawan();
    }

    function download_excel_all(){
        $("#action_download_semua").click(function() {
            var periode     = $("#form_input #periode").val() ? $("#form_input #periode").val() : '00-0000';
            var id_group    = $("#form_input #id_group").val() ? $("#form_input #id_group").val() : 'all';
            var nama_group  = $("#form_input #id_group").val() ? $("#form_input #id_group").select2('data')[0]['nama_group'] : 'all';
            var id_karyawan = $("#form_input #id_karyawan").val() ? $("#form_input #id_karyawan").val() : 'all';

            urlExcel = "<?= route('sales_activity.report.download.semua.action') ?>" + '?periode=' + periode + '&id_group=' + id_group + '&nama_group=' + nama_group + '&id_karyawan=' + id_karyawan;
            downloadFile(urlExcel, this);
        });
    }
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="form_input" class="card-body" disabled>
    <div class="row">
        <div class="col-md-3 align-self-center">
            <label class="font-weight-bold"><?= $this->lang->line('bulan'); ?></label>
        </div>
        <div class="col-md-9">
            <input type="text" id="periode" class="form-control" autocomplete="off" placeholder="yyyy" spellcheck="false" value="<?= date('m-Y') ?>" onchange="onchange_periode_input()">
        </div>
    </div>

    <?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
        <div class="row mt-2">
            <div class="col-md-3 align-self-center">
                <label class="font-weight-bold">Group/Area</label>
            </div>
            <div class="col-md-9">
                <select id="id_group" class="form-control" style="width: 100%" onchange="onchange_group_input()"></select>
            </div>
        </div>
    <?php endif; ?>

    <div class="row mt-2">
        <div class="col-md-3 align-self-center">
            <label class="font-weight-bold">Sales</label>
        </div>
        <div class="col-md-9">
            <select class="form-control" id="id_karyawan" style="width: 100%"></select>
        </div>
    </div>
</div>

<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="action_download_semua" type="button" class="btn btn-primary ladda-button" data-style="expand-left">
                <i class="fa fa-download"></i> Download
            </button>
        </div>
    </div><!-- ./row -->
</div>
