<style type="text/css">
    .lightbox .lb-outerContainer {
        position: relative; /* Sangat penting untuk membuat absolute positioning bekerja */
        /* Pastikan tidak ada overflow: hidden; di sini yang bisa menyembunyikan ikon */
    }

    .lightbox .lb-dataContainer .lb-closeContainer {
        position: absolute;
        top: 10px;
        right: 500px;
        bottom: auto;
        z-index: 9999;
    }
</style>
<div class="row">
    <div class="col-md-3">
        <label><?= $this->lang->line('nama_karyawan') ?></label>
        <select id="karyawan" class="select2 form-control" style="width: 100%;">
        </select>
    </div>
    <div class="col-md-2 align-self-end">
        <button type="button" id="btn_cari_tabs_jabatan" class="btn btn-info ladda-button" data-style="expand-left"><?= $this->lang->line('button_cari') ?></button>
    </div>
</div>

<div class="row mt-2">
    <div class="col-md-3">
        <label><?= $this->lang->line('jabatan') ?></label>
        <select id="jabatan" class="select2 form-control" style="width: 100%;"></select>
    </div>
    <?php
    if (in_array($this->level_user, array("1", "4")) || $this->multi_cabang == true) {
    ?>
        <div class="col-md-3">
            <label><?= $this->lang->line('cabang') ?></label>
            <select id="cabang" class="select2 form-control" style="width: 100%;">
            </select>
        </div>
    <?php
    }

    if (in_array($this->level_user, array("1", "4", "5")) || $this->multi_departemen == true) {
    ?>
        <div class="col-md-2">
            <label><?= $this->lang->line('departemen') ?></label>
            <select id="departemen" class="select2 form-control" style="width: 100%;">
            </select>
        </div>
    <?php } ?>
    <div class="col-md-2">
        <label><?= $this->lang->line('lock_face_recognition') ?></label>
        <select id="lock_facerecognition" class="select2 form-control" style="width: 100%;">
            <option value="-" selected><?= $this->lang->line('semua') ?></option>
            <option value="0"><?= $this->lang->line('tidak') ?></option>
            <option value="1"><?= $this->lang->line('ya') ?></option>
        </select>
    </div>
    <div class="col-md-2">
        <label><?= $this->lang->line('jenis_kelamin') ?></label>
        <select id="jenis_kelamin" class="form-control">
            <option value="ALL" selected><?= $this->lang->line('semua') ?></option>
            <option value="L"><?= $this->lang->line('laki_laki') ?></option>
            <option value="P"><?= $this->lang->line('perempuan') ?></option>
            <option value="uknown"><?= $this->lang->line('belum_diatur') ?></option>
        </select>
    </div>
</div>
<div class="row mt-1">
    <div class="col-md-1 align-self-end">
        <button type="button" id="btn_filter_tabs_jabatan" class="btn btn-info ladda-button" data-style="expand-left">FILTER</button>
    </div>
</div>
<div class="row mt-1">
    <div class="col-md-12 table-responsive">
        <div class="btn-group pull-right">
            <button id="download_tab_facerecognition" class="btn btn-primary" idkaryawan="0" idcabang="-" iddepartemen="-" idjabatan="-" lockfacerecognition="-" jeniskelamin="ALL">
                <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
            </button>
        </div>
        <table id="list_data" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th>NO</th>
                    <th><?= $this->lang->line('foto') ?></th>
                    <th width="15%" class="text-left text-uppercase"><?= $this->lang->line('karyawan') ?></th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('cabang') ?></th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('departemen') ?></th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('jabatan') ?></th>
                    <th class="text-uppercase"><?= $this->lang->line('jenis_kelamin') ?></th>
                    <th class="text-uppercase"><?= $this->lang->line('lock_face_recognition') ?></th>
                    <th class="text-uppercase"><?= $this->lang->line('aksi') ?></th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<script type="text/javascript">
    $(function() {
        if (sessionStorage.getItem("back_button") == "true" && sessionStorage.getItem("search_id") == "btn_cari_tabs_jabatan") {
            var id_cabang            = "-";
            var id_departemen        = "-";
            var id_jabatan           = "-";
            var lock_facerecognition = "-";
            var jenis_kelamin        = $('#jenis_kelamin').val();
            var id_karyawan          = sessionStorage.getItem("karyawan");
        } else if (sessionStorage.getItem("back_button") == "true" && sessionStorage.getItem("search_id") == "btn_filter_tabs_jabatan") {
            var id_cabang            = (sessionStorage.getItem("cabang") == null) ? "-" : sessionStorage.getItem("cabang");
            var id_departemen        = (sessionStorage.getItem("departemen") == null) ? "-" : sessionStorage.getItem("departemen");
            var id_jabatan           = (sessionStorage.getItem("jabatan") == null) ? "-" : sessionStorage.getItem("jabatan");
            var lock_facerecognition = $("#lock_facerecognition").val();
            var jenis_kelamin        = $('#jenis_kelamin').val();
            var id_karyawan          = 0;
        } else {
            var id_cabang            = ($("#cabang").val() == null) ? "-" : $("#cabang").val();
            var id_departemen        = ($("#departemen").val() == null) ? "-" : $("#departemen").val();
            var id_jabatan           = ($("#jabatan").val() == null) ? "-" : $("#jabatan").val();
            var lock_facerecognition = $("#lock_facerecognition").val();
            var jenis_kelamin        = $('#jenis_kelamin').val();
            var id_karyawan          = 0;
        }

        if (sessionStorage.getItem("dt_paging_current") != null) {
            var page = parseInt(sessionStorage.getItem("dt_paging_current"));
        } else {
            var page = 0;
        }

        var option = {
            'searching': false,
            'searchDelay': 250,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            <?php if ($this->code_lang == 'id') {
                echo "
                'language': {
                    'url': '" . base_url("assets/plugins/datatables/dataTables-language-id.json") . "',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan'
                },";
            }; ?> "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('master.karyawan.tabs.content.facerecognition') ?>" + "/filter/" + id_cabang + "/" + id_departemen + "/" + id_jabatan + "/" + lock_facerecognition + "/" + jenis_kelamin + "/" + id_karyawan,
                "type": "GET",
                data: function(d) {
                    delete d.columns;
                    d.start = page * d.length;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                    "aTargets": [0],
                    "bSortable": false
                },
                {
                    "aTargets": [1],
                    "bSortable": false
                },
                {
                    "aTargets": [-1],
                    "bSortable": false
                }
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                $('td:eq(1)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                $('td:eq(6)', nRow).css({
                    'text-align': 'center'
                });
                $('td:eq(7)', nRow).css({
                    'text-align': 'center'
                });
                $('td:eq(-1)', nRow).css({
                    'text-align': 'center',
                    'width': '50'
                });
            },
            initComplete: function() {
                set_default_page();
            }
        };

        if (sessionStorage.getItem("dt_length") != null) {
            option.pageLength = parseInt(sessionStorage.getItem("dt_length"));
        }

        list_data = $('#list_data').DataTable(option);

        list_data.on('page.dt', function() {
            page = list_data.page();
        });

        list_data.on('length.dt', function() {
            page = 0;
            list_data.page(0).draw('page');
        });

        $('#karyawan').select2({
            placeholder: '<?= $this->lang->line('semua_karyawan') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.karyawan.aktif")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        departemen();
        jabatan();

        $('#cabang').select2({
            placeholder: '<?= $this->lang->line('semua_cabang') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $('#cabang').change(function() {
            if (sessionStorage.getItem("cabang") == null) {
                $('#departemen').val('0').trigger("change");
                departemen();
            }
        });


        $('#btn_cari_tabs_jabatan').click(function() {
            page = 0;
            save_filter_session_search('cari', 'btn_cari_tabs_jabatan');

            var loading = Ladda.create(this);
            loading.start();

            var id_cabang            = "-";
            var id_departemen        = "-";
            var id_jabatan           = "-";
            var lock_facerecognition = "-";
            var jenis_kelamin        = $('#jenis_kelamin').val();
            var id_karyawan          = ($("#karyawan").val() == null) ? "0" : $("#karyawan").val();

            list_data.ajax.url("<?= route('master.karyawan.tabs.content.facerecognition') ?>" + "/cari/" + id_cabang + "/" + id_departemen + "/" + id_jabatan + "/" + lock_facerecognition + "/" + jenis_kelamin + "/" + id_karyawan)
            list_data.ajax.reload(function() {
                loading.stop();
            });
        });

        $('#btn_filter_tabs_jabatan').click(function() {
            page = 0;
            save_filter_session_search('filter', 'btn_filter_tabs_jabatan');

            var loading = Ladda.create(this);
            loading.start();

            var level_user       = '<?= $this->level_user ?>';
            var multi_departemen = '<?= $this->multi_departemen ?>';
            var multi_cabang     = '<?= $this->multi_cabang ?>';

            var id_jabatan           = ($("#jabatan").val() == null) ? "-" : $("#jabatan").val();
            var lock_facerecognition = $("#lock_facerecognition").val();
            var jenis_kelamin        = $('#jenis_kelamin').val();
            var id_karyawan          = 0;

            if (level_user == "3") {
                var id_karyawan = "<?= $this->id_karyawan ?>";
            } else {
                var id_karyawan = 0;
            }


            if (level_user == "1" || level_user == "4") { // ADMIN HR DAN DIREKSI
                var id_cabang = ($("#cabang").val() == null) ? "-" : $("#cabang").val();
                var id_departemen = ($("#departemen").val() == null) ? "-" : $("#departemen").val();
            } else if (level_user == "5") { // KEPALA CABANG
                if (multi_cabang == '1') {
                    var id_cabang = ($("#cabang").val() == null) ? "-" : $("#cabang").val();
                } else {
                    var id_cabang = '<?= $this->id_cabang ?>';
                }
                var id_departemen = ($("#departemen").val() == null) ? "-" : $("#departemen").val();
            } else if (level_user == "2") { // KEPALA DEPARTEMEN
                var id_cabang = '<?= $this->id_cabang ?>';
                if (multi_departemen == '1') {
                    var id_departemen = ($("#departemen").val() == null) ? "-" : $("#departemen").val();
                } else {
                    var id_departemen = '<?= $this->id_departemen ?>';
                }
            } else {
                var id_cabang = '<?= $this->id_cabang ?>';
                var id_departemen = '<?= $this->id_departemen ?>';
            }

            list_data.ajax.url("<?= route('master.karyawan.tabs.content.facerecognition') ?>" + "/filter/" + id_cabang + "/" + id_departemen + "/" + id_jabatan + "/" + lock_facerecognition + "/" + jenis_kelamin + "/" + id_karyawan)
            list_data.ajax.reload(function() {
                $("#download_tab_facerecognition").attr("idcabang", id_cabang);
                $("#download_tab_facerecognition").attr("iddepartemen", id_departemen);
                $("#download_tab_facerecognition").attr("idjabatan", id_jabatan);
                $("#download_tab_facerecognition").attr("lockfacerecognition", lock_facerecognition);
                $("#download_tab_facerecognition").attr("jeniskelamin", jenis_kelamin);
                $("#download_tab_facerecognition").attr("idkaryawan", id_karyawan);
                loading.stop();
            });
        });
        $("#download_tab_facerecognition").click(function() {
            var id_cabang            = $(this).attr("idcabang");
            var id_departemen        = $(this).attr("iddepartemen");
            var id_jabatan           = $(this).attr("idjabatan");
            var jenis_kelamin        = $(this).attr("jeniskelamin");
            var lock_facerecognition = $(this).attr("lockfacerecognition");
            var id_karyawan          = $(this).attr("idkaryawan");

            window.location.href = "<?= route('master.karyawan.download.tab.facerecognition') ?>" + "/status/" + id_cabang + "/" + id_departemen + "/" + id_jabatan + "/" + lock_facerecognition + "/" + jenis_kelamin + "/" + id_karyawan;
        });
        sessionStorage.clear();
    });

    function departemen() {
        var level_user = '<?= $this->level_user ?>';
        var multi_cabang = '<?= $this->multi_cabang ?>';

        if (level_user == "1" || level_user == "4") { // ADMIN HR DAN DIREKSI
            var id_cabang = ($("#cabang").val() == null) ? "0" : $("#cabang").val();
        } else { // KEPALA CABANG
            if (multi_cabang == '1') {
                var id_cabang = ($("#cabang").val() == null) ? "0" : $("#cabang").val();
            } else {
                var id_cabang = '<?= $this->id_cabang ?>';
            }
        }
        $('#departemen').select2({
            placeholder: '<?= $this->lang->line('semua_departemen') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.departemen.by.cabang") ?>' + "/" + id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function jabatan() {
        var level_user = '<?= $this->level_user ?>';
        var multi_cabang = '<?= $this->multi_cabang ?>';

        if (level_user == "1" || level_user == "4") { // ADMIN HR DAN DIREKSI
            var id_cabang = ($("#cabang").val() == null) ? "0" : $("#cabang").val();
            var id_departemen = ($("#departemen").val() == null) ? "0" : $("#departemen").val();
        } else { // KEPALA CABANG
            if (multi_cabang == '1') {
                var id_cabang = ($("#cabang").val() == null) ? "0" : $("#cabang").val();
                var id_departemen = ($("#departemen").val() == null) ? "0" : $("#departemen").val();
            } else {
                var id_cabang = '<?= $this->id_cabang ?>';
                var id_departemen = '<?= $this->id_departemen ?>';
            }
        }
        $('#jabatan').select2({
            placeholder: '<?= $this->lang->line('semua_jabatan') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.jabatan") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }
</script>
