<div id="calendarIO" class="p-5"></div>

<div class="modal fade" id="modal_update_kalender" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-body">
                <input type="hidden" id="id_hari_libur" value="">
                <input type="hidden" id="tanggal" name="tanggal" class="form-control datepicker" value="<?= $tanggal; ?>" readonly="true"><span id="user-availability-status"></span>
                <div class="form-group">
                    <label><b><?= $this->lang->line('keterangan'); ?></b> <i class="text-danger">*</i></label>
                    <input type="text" id="keterangan" name="keterangan" class="form-control" value="<?= ((isset($data)) ? $data->keterangan : '') ?>">
                </div>

                <div class="form-group">
                    <label class="font-weight-bold"><?= $this->lang->line('jenis'); ?> <i class="text-danger">*</i></label>
                    <select name="jenis" id="jenis" class="form-control">
                        <option value="" <?= (isset($data)) ? '' : 'selected' ?> disabled><?= $this->lang->line('pilih_jenis_hari_libur') ?></option>
                        <option value="nasional" <?= ((isset($data) && $data->jenis == 'nasional') ? 'selected' : '') ?>><?= $this->lang->line('libur_nasional') ?></option>
                        <option value="khusus" <?= ((isset($data) && $data->jenis == 'khusus') ? 'selected' : '') ?>><?= $this->lang->line('libur_khusus') ?></option>
                    </select>
                </div>

            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-5 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-7 text-right">
                        <button type="button" class="btn btn-danger delete_holiday ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> <?= $this->lang->line('button_form_hapus'); ?></button>
                        <button type="button" id="btn_update" class="btn btn-warning ladda-button" data-style="expand-left"><i class="fa fa-edit (alias)"></i> <?= $this->lang->line('button_form_perbarui'); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('#calendarIO').fullCalendar({
            displayEventTime: false,
            firstDay: 1,
            lang: "<?= $this->code_lang ?>",
            code: "<?= $this->code_lang ?>",
            dayNamesShort: <?= $this->lang->line('array_hari'); ?>,
            dayNames: <?= $this->lang->line('array_hari'); ?>,
            monthNames: <?= $this->lang->line('array_bulan'); ?>,
            monthNamesShort: <?= $this->lang->line('array_bulan_short'); ?>,
            header: {
                left: 'prev,next today',
                center: 'title',
                right: 'month,agendaWeek,agendaDay'
            },
            allDayHtml: "<?= $this->lang->line('sehari_penuh'); ?>",
            eventLimitText: "<?= $this->lang->line('lebih'); ?>",
            weekLabel: "<?= $this->lang->line('mingguan_short'); ?>",
            buttonText: {
                prev: "",
                next: "",
                today: "<?= $this->lang->line('hari_ini'); ?>",
                month: "<?= $this->lang->line('bulan'); ?>",
                week: "<?= $this->lang->line('mingguan'); ?>",
                day: "<?= $this->lang->line('hari'); ?>"
            },
            defaultDate: moment().format('YYYY-MM-DD'),
            navLinks: true,
            editable: true,
            eventLimit: true,
            selectable: true,
            selectHelper: true,
            select: function(start, end) {
                $('#create_modal input[name=jam_mulai]').val(moment(start).format('YYYY-MM-DD HH:mm'));
                $('#create_modal input[name=jam_selesai]').val(moment(end).format('YYYY-MM-DD HH:mm'));
                $('#create_modal .delete_calendar').hide();
                $('#calendarIO').fullCalendar('unselect');
            },
            eventClick: function(info) {
                detail_holiday(info);
                editDataHoliday(info);
                deleteDataHoliday(info);
            },
            dayRender: function(date, cell) {
                if (!cell.hasClass('fc-other-month')) {
                    cell.css('background-color', '#FFFFFF'); // or whatever
                } else {
                    cell.css('background-color', '#C8C6C6'); // or whatever
                }
            },
            events: <?= $data_kelender ?>,
        });
    });
</script>
