<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Import_m extends CI_Model
{
    public function get_datatables()
    {
        $this->_get_datatables_query();
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        return $this->db->get()->result();
    }

    public function count_filtered()
    {
        $this->_get_datatables_query();
        return $this->db->get()->num_rows();
    }

    public function count_all()
    {
        $this->_get_datatables_query();
        return $this->db->count_all_results();
    }

    private function _get_datatables_query()
    {
        $this->db->select('
                data_karyawan.id_karyawan,
                data_karyawan.nik,
                data_karyawan.nama_lengkap,
                master_cabang.kode as kode_cabang,
                master_cabang.nama as nama_cabang,
                payroll_gapok_m_temp.nominal,
                payroll_gapok_m_temp.flag_pot_absensi,
                payroll_gapok_m_temp.flag
            ')
            ->from('payroll_gapok_m_temp')
            ->join('data_karyawan', 'data_karyawan.id_karyawan = payroll_gapok_m_temp.id_karyawan')
            ->join('master_cabang', 'master_cabang.id_cabang = data_karyawan.id_cabang')
            ->where('payroll_gapok_m_temp.id_company', $this->id_company)
            ->where('payroll_gapok_m_temp.user_input', $this->id_karyawan);

        $column_search = array(
            'data_karyawan.nik',
            'data_karyawan.nama_lengkap',
            'payroll_gapok_m_temp.nominal'
        );

        $i = 0;
        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST
                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('', 'data_karyawan.nik', 'master_cabang.kode', 'payroll_gapok_m_temp.nominal');
        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $this->db->order_by("data_karyawan.nik ASC");
        }
    }

    public function getDataKaryawan($id_cabang = '-', $id_departemen = '-')
    {
        if ($id_cabang != '-') {
            $this->db->where('data_karyawan.id_cabang', $id_cabang);
        }

        if ($id_departemen != '-') {
            $this->db->where('data_karyawan.id_departemen', $id_departemen);
        }

        $this->db->select('
                data_karyawan.id_karyawan,
                data_karyawan.nik,
                data_karyawan.nama_lengkap,
                master_cabang.id_cabang,
                master_cabang.kode as kode_cabang,
                master_cabang.nama as nama_cabang,
                master_departemen.kode as kode_departemen,
                master_departemen.nama as nama_departemen,
                master_jabatan.kode_jabatan,
                master_jabatan.nama as nama_jabatan,
                gapok.nominal,
                gapok.flag_pot_absensi
            ')
            ->from('data_karyawan')
            ->join('master_cabang', 'master_cabang.id_cabang = data_karyawan.id_cabang')
            ->join('master_departemen', 'master_departemen.id_departemen = data_karyawan.id_departemen', 'LEFT')
            ->join('master_jabatan', 'master_jabatan.id_jabatan = data_karyawan.id_jabatan')
            ->join('payroll_gapok_m gapok', 'gapok.id_karyawan = data_karyawan.id_karyawan', 'left')
            ->where('data_karyawan.id_company', $this->id_company)
            ->where_in('data_karyawan.status', ['1', '2', '3'])
            ->where_not_in('master_jabatan.level_user', ['1', '6'])
            ->order_by('master_departemen.kode ASC, master_jabatan.kode_jabatan ASC, data_karyawan.nik ASC');

        $query = $this->db->get()->result();
        return $query;
    }

    public function masterGapok()
    {
        $query = $this->db->select("id_karyawan")
            ->from("payroll_gapok_m")
            ->where("id_company", $this->id_company)
            ->get()
            ->result();

        $data = [];
        foreach ($query as $row) {
            array_push($data, $row->id_karyawan);
        }

        return $data;
    }

    public function masterGapokReady()
    {
        $query = $this->db->select("id_karyawan, nominal, flag_pot_absensi")
            ->from("payroll_gapok_m")
            ->where("id_company", $this->id_company)
            ->get()
            ->result();

        $data = [];
        foreach ($query as $row) {
            $data[$row->id_karyawan]['nominal'] = $row->nominal;
        }

        return $data;
    }

    public function getDataGapokTemp()
    {
        return $this->db->from('payroll_gapok_m_temp')
            ->where("id_company", $this->id_company)
            ->where_in('flag', ['1', '3'])
            ->where("user_input", $this->id_karyawan)
            ->get()
            ->result();
    }

    public function getDataById($id)
    {
        return $this->db->select('
                data_karyawan.nik,
                data_karyawan.nama_lengkap as nm_karyawan,
                gapok_temp.id_karyawan, gapok_temp.nominal,
                gapok_temp.flag,
                gapok_temp.flag_pot_absensi,
                gapok_temp.id_company
            ')
            ->from('payroll_gapok_m_temp gapok_temp')
            ->join('data_karyawan', 'data_karyawan.id_karyawan = gapok_temp.id_karyawan')
            ->where("md5(CONCAT(gapok_temp.id_karyawan, gapok_temp.id_company)) = '$id'", NULL, TRUE)
            ->get()
            ->row();
    }

    public function cekDataExist($id)
    {
        return $this->db->from('payroll_gapok_m')
            ->where("md5(CONCAT(id_karyawan, id_company)) = '$id'", NULL, TRUE)
            ->count_all_results();
    }
}
