<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Kinerja extends MY_Controller {
    public function __construct(){
		parent::__construct();
		$this->load->model('kpi/admin/master/Kinerja_m');
	}

    public function index(){
		$this->Kinerja_m->check_data_aspek_kinerja();
        $this->load->view('kpi/admin/master/kinerja/home');
    }

    public function list_data(){
		$list = $this->Kinerja_m->get_datatables();
		$data = array();
		$no   = $_GET['start'];
		foreach ($list as $field) {
			$no++;
			$row   = array();
			$row[] = '<i class="fa fa-sort" style="cursor: -webkit-grab; cursor: grab;" title="Tarik keatas / kebawah" data-key="' . $field->id_object_m . '"></i> '.$no;
			$row[] = $field->nm_object;

			$row[] = '<a href="javascript:void(0)" class="text-warning" title="EDIT">
						<i id   = "' . md5($field->id_object_m) . '" class = "btn_edit fa fa-edit (alias) " onclick="edit(this)"> </i>
                    </a>&nbsp;
                    <a href="javascript:void(0)" class                                = "text-danger" title = "HAPUS">
						<i id   = "' . md5($field->id_object_m) . '" class = "btn_delete fa fa-trash" onclick="hapus_form(this)"></i>
                    </a>';
			
			$data[] = $row;
		}

		$output = array(
			"draw"            => $_GET['draw'],
			"recordsTotal"    => $this->Kinerja_m->count_all(),
			"recordsFiltered" => $this->Kinerja_m->count_filtered(),
			"data"            => $data
		);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function form($id = null){	
		if ($id == null) {
			$this->load->view('kpi/admin/master/kinerja/form');
		} else {
			$data['data'] = $this->Kinerja_m->getDataById($id);
			$this->load->view('kpi/admin/master/kinerja/form', $data);
		}
		
	}

	public function save(){
		$data = array(
				'nm_object'  => $this->input->post('nm_object'),
				'id_company' => $this->id_company,
				'user_input' => $this->nik_karyawan." - ".$this->nm_karyawan,
				'tgl_input'  => date('Y-m-d h:i:s')
			);

		$this->Kinerja_m->save($data);
	}

    public function update(){
		$id_object = $this->input->post('id_object');
		$nm_object = $this->input->post('nm_object');

        $cek_nm_objek = $this->db->where(['nm_object' => $nm_object, 'id_company' => $this->id_company])
            ->where('MD5(id_object_m) !=', $id_object)
            ->get('kpi_object_m')
            ->num_rows();

        if ($cek_nm_objek > 0) {
            if ($cek_nm_objek != $cek_nm_objek) {
                $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Nama aspek kinerja telah digunakan.</font>'];
                return __response_save(false, $message);
            }
        }

        $data = array(
            'nm_object'   => $nm_object,
            'user_update' => $this->nik_karyawan." - ".$this->nm_karyawan,
            'tgl_update'  => date('Y-m-d h:i:s')
        );

        $this->Kinerja_m->update($data, $id_object);
    }

    public function delete(){
        $id = $this->input->post("id_object");
        $this->Kinerja_m->delete($id);
    }

	public function update_order(){
        $order = $this->input->post('order');
        
        $data = array();
        foreach ($order as $key) {
            $data[] = [
				'id_object_m' => $key['id_objek'],
				'no_urut'     => $key['no_urut']
            ];
        }
        
        $this->Kinerja_m->update_order($data);
    }
}