<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Informasi_gaji extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('karyawan_detail/Informasi_gaji_m', 'model');
        $this->load->helper('numeric');
    }

    public function index($id_karyawan = null)
    {
        $data['gapok']            = $this->model->get_gapok_by_id($id_karyawan);
        $data['tunj_tetap']       = $this->model->get_tunj_tetap_by_id($id_karyawan);
        $data['ttl_tunj_tetap']   = $this->model->get_ttl_tunj_tetap_by_id($id_karyawan);
        $data['pot_bpjs_kes']     = $this->model->get_pot_bpjs_kes_by_id($id_karyawan);
        $data['tunj_bpjs_kes']    = $this->model->get_tunj_bpjs_kes_by_id($id_karyawan);
        $data['pot_bpjs_tk']      = $this->model->get_pot_bpjs_tk_by_id($id_karyawan);
        $data['pot_tetap']        = $this->model->get_pot_tetap_by_id($id_karyawan);
        $ttl_pot_bpjs_tk          = $this->model->get_ttl_pot_bpjs_tk_by_id($id_karyawan);
        $data['ttl_tunj_bpjs_tk'] = $this->model->get_ttl_tunj_bpjs_tk_by_id($id_karyawan);
        $ttl_pot_tetap            = $this->model->get_ttl_pot_tetap_by_id($id_karyawan);
        $data['ttl_pot']          = $data['pot_bpjs_kes'] + $ttl_pot_bpjs_tk + $ttl_pot_tetap;
        $data['id_karyawan']      = $id_karyawan;
        $this->load->view('karyawan/payroll/informasi_gaji/index', $data);
    }

    public function form($column, $id_karyawan)
    {
        $data['column']      = $column;
        $data['id_karyawan'] = $id_karyawan;
        $data['default']     = $this->_get_default_value($column, $id_karyawan);
        $this->load->view('karyawan/payroll/informasi_gaji/form', $data);
    }

    public function form_komponen()
    {
        $this->load->view('karyawan/payroll/informasi_gaji/form_komponen');
    }

    public function save()
    {
        // def
        $id_karyawan = $this->input->post('id_karyawan');
        $column      = $this->input->post('column');
        $value       = (int)str_replace('.', '', $this->input->post('value'));
        $value_old   = (int)$this->input->post('value_old');

        // decrypt karyawan
        $id_karyawan = $this->fungsi->decrypt_idkaryawan($id_karyawan);

        // extract data
        $table = 'payroll_gapok_m';
        if (str_contains($column, 'tunj_tetap')) {
            preg_match('/tunj_tetap_(\d+)_([a-f0-9]{32})/', $column, $matches);
            $table = 'payroll_tunj_tetap_m';
        }
        if (str_contains($column, 'pot_tetap')) {
            preg_match('/pot_tetap_(\d+)_([a-f0-9]{32})/', $column, $matches);
            $table = 'payroll_pot_tetap_m';
        }

        // validasi
        $validate = $this->_form_validation($id_karyawan, $column, $value, $value_old);
        if ($validate['response'] !== true) return __response_update($validate['status'], $validate['message']);

        // update data
        if ($column == 'gapok') {
            $this->model->update_gapok($table, $value, $value_old, $id_karyawan);
        } else {
            $this->model->update_komponen($table, $value, $id_karyawan, $gapok = $matches[1], $id_item = $matches[2]);
        }
    }

    public function save_komponen()
    {
        // def
        $id_karyawan = $this->input->post('id_karyawan');
        $column      = $this->input->post('column');
        $action      = $this->input->post('action');
        $list_action = ['update', 'delete', 'add'];

        // decript id_karyawan
        $id_karyawan = $this->fungsi->decrypt_idkaryawan($id_karyawan);

        // extract data
        if (str_contains($column, 'tunj_tetap')) {
            preg_match('/tunj_tetap_(\d+)_([a-f0-9]{32})/', $column, $matches);
            $table = 'payroll_tunj_tetap_m';
        }
        if (str_contains($column, 'pot_tetap')) {
            preg_match('/pot_tetap_(\d+)_([a-f0-9]{32})/', $column, $matches);
            $table = 'payroll_pot_tetap_m';
        }

        // validasi
        $gapok    = $this->model->get_gapok_by_id($id_karyawan, false);
        $validate = $this->_form_validation($id_karyawan, $column, (int)$matches[1], (int)$gapok, true);
        if ($validate['response'] !== true) return __response_update($validate['status'], $validate['message']);
        if (!in_array($action, $list_action)) return __response_update(false, ['message' => '<i class="fa fa-close"></i> Gagal simpan data, silakan muat ulang halaman']);

        // update data
        $this->model->update_komponen($table, $value = $gapok, $id_karyawan, $matches[1], $id_item = $matches[2], $action);
    }

    /**
     * get default value ketika mengedit data
     *
     * @param string $column => 'gapok', 'tunj_tetap_xxx', 'pot_tetap_xxx'
     * @param string $id_karyawan => md5 dari id_karyawan
     * @return void
     */
    private function _get_default_value($column, $id_karyawan)
    {
        $default = 0;
        if ($column == 'gapok') {
            $default = $this->model->get_gapok_by_id($id_karyawan);
        }

        preg_match('/[a-f0-9]{32}$/', $column, $matches);
        if (str_contains($column, 'tunj_tetap')) {
            $default = $this->model->get_tunj_tetap_by_id($id_karyawan, $id_item = $matches[0])
                ->row()
                ->nominal_tunjangan;
        }
        return $default;
    }

    /**
     * Validasi form
     *
     * @param string|int $id_karyawan => tidak di encrypt
     * @param string $column
     * @param int $value
     * @param int $value_old
     * @param bool $komponen => set true jika untuk update komponen dengan persentase gapok
     * @return array
     */
    private function _form_validation($id_karyawan, $column, $value, $value_old, $komponen = false): array
    {
        if (!$id_karyawan)
            return ['response' => false, 'status' => false, 'message' => ['message' => '<i class="fa fa-close"></i> Karyawan tidak ditemukan']];
        if (!$column)
            return ['response' => false, 'status' => false, 'message' => ['message' => '<i class="fa fa-close"></i> Gagal simpan data, silakan muat ulang halaman']];
        if (!$komponen) {
            if ($value === $value_old)
                return ['response' => false, 'status' => true, 'message' => null];
            if (!is_numeric($value))
                return ['response' => false, 'status' => false, 'message' => ['message' => '<i class="fa fa-close"></i> Nominal harus berupa angka']];
        } else {
            if ($value !== $value_old)
                return ['response' => false, 'status' => false, 'message' => ['message' => '<i class="fa fa-close"></i> Gagal simpan data, silakan muat ulang halaman']];
        }

        // is valid
        return ['response' => true];
    }
}
