<script>
    $(function() {
        $('#detail-aktivitas-form #select_activity').select2({
            placeholder: 'Pilih Aktivitas',
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.kanban.list_activity") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $("#detail-aktivitas-form #jam_activity").inputmask({
            'alias': 'datetime',
            'inputFormat': 'HH:MM'
        });

        $("#detail-aktivitas-form #tgl_activity").inputmask({
            'alias': 'datetime',
            'inputFormat': 'dd-mm-yyyy'
        });

        $("#detail-aktivitas-form #tgl_activity").datepicker({
            format: "dd-mm-yyyy",
            orientation: "bottom",
            todayHighlight: true,
            autoclose: true,
            endDate: "today"
        });

        <?php if ($is_new === true): ?>
            $("#btn_submit").on('click', function(e) {
                e.preventDefault();
                $("#message").html("");
                var loading = Ladda.create(this);

                var valid = form_validation_activity();
                if (!valid) {
                    return false;
                }

                var param = {};
                param.id = "<?= $id ?>";
                param.jenis_activity = $("#select_activity").val();
                param.tgl_activity = $("#tgl_activity").val();
                param.jam_activity = $("#jam_activity").val();
                param.keterangan = $("#ket_activity").val();

                $.ajax({
                    type: 'POST',
                    url: "<?= route('sales_activity.kanban.detail.save_aktivitas') ?>",
                    data: param,
                    dataType: 'JSON',
                    beforeSend: function() {
                        loading.start();
                        disable_form("#detail-aktivitas-form", ["input", "select", "textarea"], true);
                    },
                    success: function(result) {
                        if (result.success == true) {
                            disable_form("#detail-aktivitas-form", ["input", "select", "textarea"], true);
                            $('#btn_submit').hide();
                            $('#btn_new_input').show();
                            $("#detail-aktivitas").load("<?= route('sales_activity.kanban.detail.aktivitas', ['id' => $id]) ?>");
                            get_target_poin_harian_bulanan_karyawan();
                            
                        } else {
                            disable_form("#detail-aktivitas-form", ["input", "select", "textarea"], false);
                        }
                        loading.stop();
                        $('#message').show();
                        $('#message').html(result.message);
                    },
                    error: function() {
                        loading.stop();
                        disable_form("#detail-aktivitas-form", ["input", "select", "textarea"], false);
                        $('#message').show();
                        $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                    }
                });
            });
        <?php else: ?>
            $("#btn_update").on('click', function(e) {
                e.preventDefault();
                $("#message").html("");
                var loading = Ladda.create(this);

                var valid = form_validation_activity();
                if (!valid) {
                    return false;
                }

                var param = {};
                param.id = "<?= $id_aktivitas ?>";
                param.tgl_activity = $("#tgl_activity").val();
                param.jam_activity = $("#jam_activity").val();
                param.keterangan = $("#ket_activity").val();

                $.ajax({
                    type: 'POST',
                    url: "<?= route('sales_activity.kanban.detail.update_aktivitas') ?>",
                    data: param,
                    dataType: 'JSON',
                    beforeSend: function() {
                        loading.start();
                        disable_form("#detail-aktivitas-form", ["input", "textarea"], true);
                    },
                    success: function(result) {
                        disable_form("#detail-aktivitas-form", ["input", "textarea"], false);
                        if (result.success == true) {
                            $("#detail-aktivitas").load("<?= route('sales_activity.kanban.detail.aktivitas', ['id' => $id]) ?>");
                        }
                        loading.stop();
                        $('#message').show();
                        $('#message').html(result.message);
                    },
                    error: function() {
                        loading.stop();
                        disable_form("#detail-aktivitas-form", ["input", "textarea"], false);
                        $('#message').show();
                        $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                    }
                });
            });
        <?php endif; ?>

        $('#btn_new_input').on('click', function() {
            $("#add-activity").click();
        });
    });

    function form_validation_activity() {
        <?php if ($is_new === true): ?>
            if (!$("#select_activity").val()) {
                $("#message").show();
                $("#message").html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_aktivitas_kosong') ?></font>");
                $("#select_activity").select2("open");
                return false;
            }
        <?php endif; ?>
        if ($("#tgl_activity").val() == "") {
            $("#message").show();
            $("#message").html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_aktivitas_kosong') ?></font>");
            $("#tgl_activity").focus();
            return false;
        }
        if ($("#jam_activity").val() == "") {
            $("#message").show();
            $("#message").html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jam_aktivitas_kosong') ?></font>");
            $("#jam_activity").focus();
            return false;
        }
        if ($("#ket_activity").val() == "") {
            $("#message").show();
            $("#message").html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_ket_aktivitas_kosong') ?></font>");
            $("#ket_activity").focus();
            return false;
        }

        return true;
    }
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="detail-aktivitas-form" class="card-body">
    <?php if ($is_new === true): ?>
        <div class="form-group">
            <label>Pilih Aktivitas<i class="text-danger">*</i></label>
            <select id="select_activity" class="select2 form-control" style="width: 100%"></select>
        </div>
    <?php else: ?>
        <div class="form-group w-100">
            <div class="alert alert-info" role="alert">
                <i class="fa fa-info-circle"></i> Tidak dapat mengubah aktivitas setelah disetujui.
            </div>
        </div>
        <div class="form-group">
            <label>Aktivitas</label>
            <p class="font-weight-bold"><?= $aktivitas->aktivitas ?: '-' ?></p>
        </div>
    <?php endif; ?>
    <div class="row">
        <div class="col-8">
            <div class="form-group">
                <label>Tanggal<i class="text-danger">*</i></label>
                <input id="tgl_activity" type="text" class="form-control w-100" value="<?= ($is_new === true) ? date('d-m-Y') : date('d-m-Y', strtotime($aktivitas->tgl)) ?>" autocomplete="off" spellcheck="false" placeholder="dd-mm-yyyy">
            </div>
        </div>
        <div class="col-4">
            <div class="form-group">
                <label>Jam<i class="text-danger">*</i></label>
                <input id="jam_activity" type="text" class="form-control w-100" value="<?= ($is_new === false) ? $aktivitas->jam : '' ?>" autocomplete="off" spellcheck="false" placeholder="HH:MM">
            </div>
        </div>
    </div>
    <div class="form-group">
        <label>Keterangan<i class="text-danger">*</i></label>
        <textarea id="ket_activity" class="form-control" rows="3" autocomplete="off" spellcheck="false"><?= ($is_new === false) ? trim($aktivitas->keterangan) : '' ?></textarea>
    </div>
</div>

<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left align-self-end">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <?php if ($is_new === true) : ?>
                <button id="btn_new_input" class="btn" style="display:none"><?= $this->lang->line('button_form_tambah_baru') ?></button>
                <button id="btn_submit" class="btn btn-primary ladda-button" data-style="expand-left">
                    <i class='fa fa-save'></i> <?= $this->lang->line('button_form_simpan') ?>
                </button>
            <?php else: ?>
                <button id="btn_update" class="btn btn-warning ladda-button" data-style="expand-left">
                    <i class='fa fa-edit'></i> <?= $this->lang->line('button_form_perbarui') ?>
                </button>
            <?php endif ?>
        </div>
    </div>
</div>
