<script type="text/javascript">
    $(function() {
        dropdown_cabang();

        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').on('error.dt', function(e, settings, techNote, message) {
            if (confirm('<?= $this->lang->line('error_datatable') ?>')) {
                window.location.reload();
            }
        }).DataTable({
            'searching': true,
            'delay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': false,
            'stateSave': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'NIK/Nama Karyawan'
                <?php else : ?> 'searchPlaceholder': 'ID/Employee Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('master.saldocuti.listdata', ['cabang' => 'all', 'departemen' => 'all']) ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    // reconfigure(data);
                    window.scroll({
                        top: 0,
                        left: 0,
                        behavior: 'smooth'
                    });
                }
            },
            "initComplete": function() {
                $(".btn_download_excel").show();
            },
            "aoColumnDefs": [{
                "aTargets": [0],
                "bSortable": false
            }, {
                "aTargets": [-1],
                "bSortable": false
            }],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                $('td:eq(1)', nRow).css({
                    'text-align': 'left'
                });
                $('td:eq(2), td:eq(3), td:eq(4)', nRow).css({
                    'text-align': 'left',
                    'width': '200px'
                });
                $('td:eq(5)', nRow).css({
                    'text-align': 'center',
                    'width': '20px'
                });
                $('td:eq(-1)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
            }

        });

        $(document).on('click', '.btn_download_excel', function() {
            let cabang = (!$("#filter #cabang").val()) ? "all" : $("#filter #cabang").val();
            let departemen = (!$("#filter #departemen").val()) ? "all" : $("#filter #departemen").val();
            let url = "<?= route('master.saldocuti.download', ['cabang' => '"+cabang+"', 'departemen' => '"+departemen+"']) ?>";

            downloadFile(url, this);
        });

        $(document).on('click', '.btn_tambah', function() {
            let formFor = $(this).data('form');
            $('#tampil_form').load("<?= route('master.saldocuti.form.tambah') ?>", function() {
                $('#modal_form .modal-dialog').removeClass('modal-md');
                $('#modal_form .modal-dialog').addClass('modal-lg');
                $('#modal_form').modal('show');
                if (formFor == 'tambah') {
                    $(".title").text("<?= strtoupper($this->lang->line('title_tambah_saldo_cuti')) ?>");
                    $("label[for=saldo]").html("<?= $this->lang->line('jml_saldo_ditambah') ?> <span class='text-danger'>*</span>");
                } else if (formFor == 'kurang') {
                    $(".title").text("<?= strtoupper($this->lang->line('title_kurang_saldo_cuti')) ?>");
                    $("label[for=saldo]").html("<?= $this->lang->line('jml_saldo_dikurangi') ?> <span class='text-danger'>*</span>");
                } else {
                    $(".title").text("<?= strtoupper($this->lang->line('title_reset_saldo_cuti')) ?>");
                    $("label[for=saldo]").html("<?= $this->lang->line('pengaturan_cuti_reset') ?> <span class='text-danger'>*</span>");
                }
                $("#modal_form #jenis").val(formFor);
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('<?= $this->lang->line("button_form_submit") ?>');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click', '#btn_new_input', function() {
            let nama = $("#jenis").val();
            $(".btn_tambah[data-form='" + nama + "']").click();
        });

        $(document).on("click", ".btn_save", function(e) {
            e.preventDefault();
            $('#message').html("");
            const loading = Ladda.create(this);
            const target = $("input[name=target]:checked").val();

            if ($("#modal_form #saldo").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jumlah_saldo') ?></font>");
                $("#modal_form #saldo").focus();
                return false;
            } else if ($("#modal_form #keterangan").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_keterangan') ?></font>");
                $('#modal_form #keterangan').focus();
                return false;
            }

            if (target == "cabang") {
                if ($("#select-target-cabang-1").val() == "") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $("#select-target-cabang-1").select2("open");
                    return false;
                }
            }
            if (target == "departemen") {
                if (!$("#select-target-cabang-2").val()) {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $("#select-target-cabang-2").select2("open");
                    return false;
                }
                if ($("#select-target-departemen").val() == "") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_departemen') ?></font>");
                    $("#select-target-departemen").select2("open");
                    return false;
                }
            }
            if (target == "karyawan") {
                if ($("#select-target-karyawan").val() == "") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_karyawan') ?></font>");
                    $("#select-target-karyawan").select2("open");
                    return false;
                }
            }

            loading.start();

            var param = {};
            param.saldo = $("#modal_form #saldo").val();
            param.keterangan = $("#modal_form #keterangan").val();
            param.jenis = $("#modal_form #jenis").val();
            param.target = $("input[name=target]:checked").val();
            param.target_select_cabang = $("#modal_form #select-target-cabang-1").val();
            param.target_select_departemen = $("#modal_form #select-target-departemen").val();
            param.target_select_karyawan = $("#modal_form #select-target-karyawan").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('master.saldocuti.save') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        $("#form_tambah :input").prop("disabled", true);
                        $("#form_tambah select").prop("disabled", true);
                        $('.btn_save').hide();
                        $('#btn_new_input').show();
                    }
                    list_data.ajax.reload();
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });

        $('#btn_filter').click(function() {
            let loading = Ladda.create(this);
            loading.start();
            let id_cabang = (!$("#filter #cabang").val()) ? "all" : $("#filter #cabang").val();
            let id_departemen = (!$("#filter #departemen").val()) ? "all" : $("#filter #departemen").val();

            list_data.ajax.url("<?= route('master.saldocuti.listdata', ['cabang' => '"+id_cabang+"', 'departemen' => '"+id_departemen+"']) ?>").load(function() {
                loading.stop();
            });
        });
    });

    function dropdown_cabang() {
        $('#filter #cabang').select2({
            placeholder: '<?= $this->lang->line('semua_cabang') ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).change(function() {
            $("#filter #departemen").val('').trigger('change');
            dropdown_departemen();
        });
    }

    function dropdown_departemen() {
        let id_cabang = ($("#filter #cabang").val() == null) ? "all" : $("#filter #cabang").val();
        $("#filter #departemen").select2({
            placeholder: "<?= $this->lang->line('semua_departemen') ?>",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.departemen.by.cabang") ?>/' + id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_master_data') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right pl-2">
                <button type="button" class="btn_tambah btn btn-danger" data-form="reset">
                    <i class="fa fa-refresh"></i> <?= $this->lang->line('button_reset_saldo_cuti') ?>
                </button>
            </div>
            <div class="float-md-right pl-2">
                <button type="button" class="btn_tambah btn btn-warning" data-form="kurang">
                    <i class="fa fa-minus-circle"></i> <?= $this->lang->line('button_kurang_saldo_cuti') ?>
                </button>
            </div>
            <div class="float-md-right">
                <button type="button" class="btn_tambah btn btn-biru" data-form="tambah">
                    <i class="fa fa-plus-circle"></i> <?= $this->lang->line('button_tambah_saldo_cuti') ?>
                </button>
            </div>

        </div>
    </div>
    <hr>
    <div id="filter">
        <div class="row">
            <div class="col-md-8">
                <div class="row mt-1">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="text-uppercase"><?= $this->lang->line('cabang') ?></label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select id="cabang" class="form-control">
                            <option></option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="text-uppercase"><?= $this->lang->line('departemen') ?></label>
                    </div>
                    <div class="col-md-3">
                        <select class="form-control" id="departemen"></select>
                    </div>
                    <div class="col-md-2">
                        <button type="button" id="btn_filter" class="ladda-button btn btn-primary col-md-12" data-style="expand-left">FILTER</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="btn-group mb-2">
                <button class="btn_download_excel btn btn-primary ladda-button" style="display: none;" data-style="expand-left"><i class="fa fa-file-excel-o"></i> <?= strtoupper($this->lang->line('button_unduh')) ?></button>
            </div>
            <div class="table-responsive">
                <table id="list_data" class="table table-striped table-bordered" style="width:100%">
                    <thead>
                        <tr>
                            <th>NO</th>
                            <th class="text-uppercase"><?= $this->lang->line('nama_karyawan') ?></th>
                            <th class="text-uppercase"><?= $this->lang->line('cabang') ?></th>
                            <th class="text-uppercase"><?= $this->lang->line('departemen') ?></th>
                            <th class="text-uppercase"><?= $this->lang->line('jabatan') ?></th>
                            <th class="text-uppercase">TOTAL <?= $this->lang->line('saldo_cuti') ?></th>
                            <th class="text-uppercase"><?= $this->lang->line('aksi') ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<!-- <div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div> -->
<!-- END TAMPIL MODAL -->
