<script type="text/javascript">
    $(document).ready(function() {
        $('#target').change(function() {
            var target = $('#target').val();
            if (target == 2) { // PER CABANG
                $('#id_cabang').val('');
                dropdown_cabang(multiple = true);
                $('#div_cabang').show();
                $('#div_departemen').hide();
                $('#div_karyawan').hide();
            } else if (target == 3) { // PER DEPARTEMEN
                $('#id_cabang').val('');
                $('#id_departemen').val('');
                dropdown_cabang(multiple = false);
                dropdown_departemen();
                $('#div_cabang').show();
                $('#div_departemen').show();
                $('#div_karyawan').hide();
            } else if (target == 4) { // PER KARYAWAN
                $('#id_karyawan').val('');
                dropdown_karyawan();
                $('#div_cabang').hide();
                $('#div_departemen').hide();
                $('#div_karyawan').show();
            } else { // SEMUA KARYAWAN
                $('#div_cabang').hide();
                $('#div_departemen').hide();
                $('#div_karyawan').hide();
            }
        });

        dropdown_cabang(multiple = false);

        dropdown_departemen();

        dropdown_karyawan();

        $("#id_cabang").change(function() {
            var terget = $("#target").val();
            if (terget == 3) {
                $('#id_departemen').val('');
                dropdown_departemen();
            }
        })
    });

    function dropdown_cabang(multiple = false) {
        <?php
        if (isset($target) && $target == 2) {
        ?>
            multiple = true;
        <?php
        }
        ?>
        $('#id_cabang').select2({
            placeholder: '<?= $this->lang->line('pilih_cabang') ?>',
            multiple: multiple,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        });
    }

    function dropdown_departemen() {
        var id_cabang = $("#id_cabang").val()
        $('#id_departemen').select2({
            placeholder: '<?= $this->lang->line('pilih_departemen') ?>',
            ajax: {
                url: '<?= route("dropdown.departemen.by.cabang") ?>' + '/' + id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        });
    }

    function dropdown_karyawan() {
        $('#id_karyawan').select2({
            placeholder: '<?= $this->lang->line('pilih_karyawan') ?>',
            multiple: true,
            ajax: {
                url: '<?= route("dropdown.karyawan") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        });
    }

    $(document).on("click", "#btn_simpan", function(e) {
        e.preventDefault();
        $('#message').html("");
        var loading = Ladda.create(this);

        var html_content = CKEDITOR.instances.content.getData();
        var content = html_content.replace(/\&nbsp;/g, ' ');
        var content = encodeURIComponent(content);

        var target = $('#target').val();

        if (target == 2 || target == 3) {
            if ($("#id_cabang").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_cabang') ?></font>");
                $("#id_cabang").focus();
                return false;
            }
        }

        if (target == 3) {
            if ($("#id_departemen").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_departemen') ?></font>");
                $("#id_departemen").focus();
                return false;
            }
        }

        if (target == 4) {
            if ($("#id_karyawan").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_karyawan') ?></font>");
                $("#id_karyawan").focus();
                return false;
            }
        }

        if ($("#judul").val() == "") {
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_judul') ?></font>");
            $("#judul").focus();
            return false;
        } else if (content == "") {
            if ($("#content").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_isi_pengumuman') ?></font>");
                $("#content").focus();
                return false;
            }
        }

        loading.start();
        var param = new FormData();
        param.append('judul', $("#judul").val());
        param.append('content', content);
        param.append('target', $("#target").val());
        param.append('id_karyawan', $("#id_karyawan").val());
        param.append('id_cabang', $("#id_cabang").val());
        param.append('id_departemen', $("#id_departemen").val());
        param.append('id_pengumuman', $("#id_pengumuman").val());

        $.ajax({
            type: 'POST',
            url: "<?= route('informasi.pengumuman.save') ?>",
            data: param,
            dataType: 'JSON',
            contentType: false,
            processData: false,
            cache: false,
            success: function(result) {
                if (result.success == true) {
                    window.location.href = '<?= route('informasi.pengumuman.home') ?>';
                }
                loading.stop();
                $('#message').show();
                $('#message').html(result.message);
            },
            error: function() {
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    });
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_informasi') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div id="form_input" class="card-body">
            <input type="hidden" name="id_pengumuman" id="id_pengumuman" value="<?= ((isset($data)) ? md5($data->id_pengumuman) : '') ?>">
            <div class="row">
                <div class="col-md-3">
                    <label><?= $this->lang->line('tipe_target') ?> <span class="text-danger">*</span></label>
                    <select id="target" class="select2 form-control">
                        <option value="1" <?= ((isset($data) and $data->target == '1') ? 'selected' : '') ?>><?= strtoupper($this->lang->line('semua')) ?></option>
                        <option value="2" <?= ((isset($data) and $data->target == '2') ? 'selected' : '') ?>><?= strtoupper($this->lang->line('cabang')) ?></option>
                        <option value="3" <?= ((isset($data) and $data->target == '3') ? 'selected' : '') ?>><?= strtoupper($this->lang->line('departemen')) ?></option>
                        <option value="4" <?= ((isset($data) and $data->target == '4') ? 'selected' : '') ?>><?= strtoupper($this->lang->line('karyawan')) ?></option>
                    </select>
                </div>
            </div>
            <?php
            if (isset($data)) {
                if ($data->target == 2) {
                    $hidden_cabang = '';
                    $hidden_departemen = 'style="display:none"';
                    $hidden_karyawan = 'style="display:none"';
                } else if ($data->target == 3) {
                    $hidden_cabang = '';
                    $hidden_departemen = '';
                    $hidden_karyawan = 'style="display:none"';
                } else if ($data->target == 4) {
                    $hidden_cabang = 'style="display:none"';
                    $hidden_departemen = 'style="display:none"';
                    $hidden_karyawan = '';
                } else {
                    $hidden_cabang = 'style="display:none"';
                    $hidden_departemen = 'style="display:none"';
                    $hidden_karyawan = 'style="display:none"';
                }
            } else {
                $hidden_cabang = 'style="display:none"';
                $hidden_departemen = 'style="display:none"';
                $hidden_karyawan = 'style="display:none"';
            }
            ?>
            <div id="div_cabang" class="row mt-1" <?= $hidden_cabang ?>>
                <div class="col-md-6">
                    <label><?= $this->lang->line('cabang') ?> <span class="text-danger">*</span></label>
                    <select id="id_cabang" class="select2 form-control" style="width:100%">
                        <?php
                        foreach ($cabang as $rows) {
                            echo '<option value="' . $rows->id_cabang . '" selected>' . $rows->kode . ' - ' . $rows->nama . '</option>';
                        }
                        ?>

                    </select>
                </div>
            </div>
            <div id="div_departemen" class="row mt-1" <?= $hidden_departemen ?>>
                <div class="col-md-6">
                    <label><?= $this->lang->line('departemen') ?> <span class="text-danger">*</span></label>
                    <select id="id_departemen" multiple="multiple" class="select2 form-control" style="width:100%">
                        <?php
                        foreach ($departemen as $rows) {
                            echo '<option value="' . $rows->id_departemen . '" selected>' . $rows->kode . ' - ' . $rows->nama . '</option>';
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div id="div_karyawan" class="row mt-1" <?= $hidden_karyawan ?>>
                <div class="col-md-6">
                    <label><?= $this->lang->line('karyawan') ?> <span class="text-danger">*</span></label>
                    <select id="id_karyawan" multiple="multiple" class="select2 form-control" style="width:100%">
                        <?php
                        foreach ($karyawan as $rows) {
                            echo '<option value="' . $rows->id_karyawan . '" selected>' . $rows->nik . ' - ' . $rows->nama_lengkap . '</option>';
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-6">
                    <label><?= $this->lang->line('judul') ?> <span class="text-danger">*</span></label>
                    <input type="text" name="judul" class="form-control" id="judul" value="<?= ((isset($data)) ? $data->judul : '') ?>">
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-12">
                    <label><?= $this->lang->line('isi_pengumuman') ?> <span class="text-danger">*</span></label>
                    <textarea id="content" class="form-control"><?= ((isset($data)) ? $data->content : '') ?></textarea>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-md-12 text-right">
                    <label id="message"></label>
                    <a href="<?= site_url('informasi/pengumuman') ?>" class="btn btn-secondary"><i class="fa fa-arrow-left"></i> <?= $this->lang->line('button_form_kembali') ?></a>
                    <?php
                    if ($form == 'tambah') {
                        echo '<button type="button" id="btn_simpan" class="btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-save"></i> ' . $this->lang->line('button_form_simpan') . '</button>';
                    } else {
                        echo '<button type="button" id="btn_simpan" class="btn btn-warning ladda-button" data-style="expand-left"><i class="fa fa-edit"></i> ' . $this->lang->line('button_form_perbarui') . '</button>';
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    CKEDITOR.replace('content', {
        height: 300,
    });

    CKEDITOR.config.toolbar = [
        ['Bold', 'Italic', 'Underline', 'StrikeThrough', '-', 'Undo', 'Redo', '-', 'Cut', 'Copy', 'Paste', 'Find', 'Replace', '-', 'Outdent', 'Indent', '-', 'Print'],
        '/',
        ['NumberedList', 'BulletedList', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'],
        ['Styles', 'Format', 'Font', 'FontSize']
    ];
</script>
