<script>
    $(document).on('click','#btn_form_template',function(){
        $('#tampil_form').load("<?= route('payroll.master.gapok.import.form.templateimport') ?>",function(){
            $('#modal_form').modal('show');
            $(".title").text("Unduh Template Gapok");
            $(".btn_unduh").addClass("btn_unduh btn btn-success");
            $(".btn_unduh").append('<i class="fa fa-download"></i> ');
            $(".btn_unduh").append('UNDUH');
            dropdown_cabang();
            dropdown_departemen();
        });
    });

    function dropdown_cabang() {
        $("#cabang").select2({
            placeholder: "Semua Cabang",
            dropdownParent: $("#modal_form"),
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function dropdown_departemen(){
        $("#departemen").select2({
            placeholder: "Semua Departemen",
            dropdownParent: $("#modal_form"),
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.departemen.by.cabang") ?>'+'/'+$('#cabang').val(),
                dataType: 'json',
                delay: 250,
                processResults:function(data) {
                    return {
                            results: data
                        };
                },
                cache: false
            }
        });
    }

    $(document).on("click", ".btn_unduh", function(){
        var id_cabang     = cek_null($('#cabang').val());
        var id_departemen = cek_null($('#departemen').val());
        let urlExcel      = "<?= route('payroll.master.gapok.import.unduh.templateimport', ['id_cabang' => '"+id_cabang+"', 'id_departemen' => '"+id_departemen+"']) ?>";

        downloadFile(urlExcel, this);
    });

    function cek_null($value) {
        if($value == null) {
            return "-";
        } else {
            return $value;
        }
    }

    $(document).on('click', '#btn_import_gaji', function(){
        var loading = Ladda.create(this);
        $('.form_import #message').html("");

        if(document.getElementById("file").files.length == "0"){
            $('.form_import #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> File belum diupload</font>");
            $('#file').focus();
            return false;
        }

        loading.start();

        var data = new FormData();
        data.append('file',$('#file').prop('files')[0]);

        $.ajax({
            type: 'POST',
            url: "<?= route('payroll.master.gapok.import.excel') ?>",
            data: data,
            contentType: false,
            processData: false,
            dataType: "json",
            success: function(result){
                if(result.success == true){
                    $('.form_import input').val('');
                }

                loading.stop();
                $('.form_import #message').show();
                $('.form_import #message').html(result.message);
            },
            error: function(){
                loading.stop();
                $('.form_import #message').show();
                $('.form_import #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });

    });

    $(document).on('click','.btn_hapus_semua',function(){
        $('#modal_hapus').modal('show');
                $(".title").text("Apakah anda ingin menghapus semua data ini?");
                $("#modal_hapus .card-body").show();
                $("#modal_hapus .card-footer").show();
                $(".tombol").empty();
                $(".tombol").append('<button class="btn_delete_semua btn btn-danger ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> HAPUS</button>');
    });

    //btn_delete
    $(document).on('click', '.btn_delete_semua',function(){
        var loading = Ladda.create(this);
        loading.start();
        $.ajax({
            type: 'DELETE',
            url: "<?=  route('payroll.master.gapok.import.deleteall') ?>",
            dataType:'JSON',
            success: function(result){
                $("#modal_hapus .card-body").hide();
                $("#modal_hapus .card-footer").hide();
                $("#modal_hapus .title").html(result.message.replace("#009900","FFFFFF"));
                loading.stop();
                setTimeout(() => {
                    $("#modal_hapus").modal("hide");
                }, 1000);
            },
            error:function(){
                loading.stop();
                $("#modal_hapus .card-body").hide();
                $("#modal_hapus .card-footer").hide();
                $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });
    //btn_delete

    $(document).on('click','.btn_edit',function(){
        $('#tampil_form').load("<?= site_url('payroll/master/gapok/import/form') ?>/"+$(this).attr('id'),function(){
            $('#modal_form').modal('show');
            $(".title").text("Form Edit Data");
            $(".btn_save").addClass("btn_save btn btn-warning");
            $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
            $(".btn_save").append('PERBARUI');
            $("#btn_new_input").hide();
        });
    });

    $(document).on('click','.btn_delete',function(){
        $('#tampil_form').load("<?= site_url('payroll/master/gapok/import/form') ?>/"+$(this).attr('id'),function(){
            $('#modal_form').modal('show');
            $('#nominal').removeClass('form-control').addClass('form-control-plaintext');
            $(".title").text("Apakah Anda ingin menghapus data ini?");
            $('#form_input input[type=text]').prop("disabled",true);
            $(".btn_save").append('<i class="fa fa-trash"></i> ');
            $(".btn_save").append('HAPUS');
            $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
        });
    });

    // PROSES DELETE
    $(document).on('click','.btn_hapus',function(){
        var loading = Ladda.create(this);
        loading.start();

        var param = {};
        param.id = $("#id").val();

        $.ajax({
            type: 'POST',
            url: "<?= route('payroll.master.gapok.import.delete') ?>",
            data: param,
            dataType:'JSON',
            success: function(result){
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html(result.message.replace("#009900","FFFFFF"));
                loading.stop();
                setTimeout(() => {
                    $("#modal_form").modal("hide");
                }, 1000);
            },
            error:function(){
                loading.stop();
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });

    $(document).on("click",".btn_save",function(e){
        e.preventDefault();
        $('#message').html("");
        var loading = Ladda.create(this);

        if($("#nominal").val()==""){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nominal belum diisi</font>");
            $("#nominal").focus();
            return false;
        }

        loading.start();

        var param     = {};
        param.id                = $("#id").val();
        param.flag              = $("#flag").val();
        param.nominal           = $("#nominal").autoNumeric('get');
        param.lembur_per_jam    = $("#lembur_per_jam").autoNumeric('get');

        $.ajax({
            type: 'POST',
            url: "<?= route('payroll.master.gapok.import.save') ?>",
            data: param,
            dataType:'JSON',
            success: function(result) {
                if(result.success == true){
                    if(result.type == 'save'){
                        $("#form_input :input").prop("disabled", true);
                        $('.btn_save').hide();
                        $('#btn_new_input').show();
                    }

                }
                loading.stop();
                $('#message').show();
                $('#message').html(result.message);
            },
            error:function(){
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });

    // # SIMPAN SEMUA DATA TEMPORARY
    $(document).on('click','.btn_simpan_semua',function(){
            $('#modal_hapus').modal('show');
            $(".title").text("Apakah anda ingin menyimpan semua data ini?");
            $("#modal_hapus .card-body").show();
            $("#modal_hapus .card-footer").show();
            $(".tombol").empty();
            $(".tombol").append('<button class="btn_save_semua btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-save"></i> SIMPAN</button>');
    });

    //btn_delete
    $(document).on('click', '.btn_save_semua',function(){
        var id = $(this).attr('id');
        var loading = Ladda.create(this);
        loading.start();
        $.ajax({
            type: 'POST',
            url: "<?= route('payroll.master.gapok.import.publishall') ?>",
            data: 'id='+id,
            dataType:'JSON',
            success: function(result){
                $("#modal_hapus .card-body").hide();
                $("#modal_hapus .card-footer").hide();
                $("#modal_hapus .title").html(result.message.replace("#009900","FFFFFF"));
                loading.stop();
                setTimeout(() => {
                    $("#modal_hapus").modal("hide");
                }, 1000);
            },
            error:function(){
                loading.stop();
                $("#modal_hapus .card-body").hide();
                $("#modal_hapus .card-footer").hide();
                $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });

    $(function() {
        list_data = $('#list_data').DataTable({
                'searching'     : true,
                'paging'        : true,
                'lengthChange'  : true,
                'ordering'      : true,
                'info'          : true,
                'scrollX'       :true,
                'scrollCollapse': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'NIK/Nama Karyawan'
                                },
                    "processing"  : true,
                    "serverSide"  : true,
                    "order"       : [],

                    "ajax"        : {
                                    "url": "<?= route('payroll.master.gapok.import.listdata') ?>",
                                    "type": "GET",
                                    "complete" : function(data){
                                                    reconfigure(data);
                                                }
                                    },
                    "aoColumnDefs": [
                                        { "aTargets": [0, -1], "bSortable": false}

                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center'});
                            $('td:eq(3)', nRow).css({'text-align':'right'});
                            $('td:eq(4)', nRow).css({'text-align':'right'});
                            $('td:eq(-1)', nRow).css({'text-align':'center'});

                            if(aData[6] == 3) {
                                $(nRow).find('td:not(:last)').css({'background-color': '#FFF9EI'});
                                $(nRow).find('td:eq(0)').css({'border-left': '5px solid #F2C94C'});
                            } else if(aData[6] == 2) {
                                $(nRow).find('td:not(:last)').css({'background-color': '#FFF1F1'});
                                $(nRow).find('td:eq(0)').css({'border-left': '5px solid #EB5757'});
                            } else if(aData[6] == 4) {
                                $(nRow).find('td:not(:last)').css({'background-color': '#DEFBE6'});
                                $(nRow).find('td:eq(0)').css({'border-left': '5px solid #27AE60'});
                            }
                    }
        });
    });
</script>
