<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Target_tahunan_m extends CI_Model
{
    var $table = 'sales_target_tahunan_p';

    function get_datatables($tahun=""){
        return $this->_get_datatables_query($tahun);
        // $query = $this->db->get();
        // return $query->result_array();
    }

    private function _get_datatables_query($tahun=""){
        $this->db->select("
            tahun,
            bulan,
            nominal,
            id_group_m
        ")
        ->from($this->table)
        ->where("id_company", $this->id_company)
        ->where("tahun", $tahun)
        ->order_by('bulan ASC');

        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('id_group_m', explode(',', $this->sales_admin_group));
            }
        }

        $query = $this->db->get()->result();

        $data = array();
        foreach($query AS $value){
            $data['data'][$value->id_group_m][$value->tahun][$value->bulan]['nominal']  = $value->nominal;
            $data['total_nominal'][$value->id_group_m][$value->tahun]                  += $value->nominal;
            $data['total_target_per_bulan'][$value->tahun][$value->bulan]              += $value->nominal;
            $data['total_seluruh_target'][$value->tahun]                               += $value->nominal;
        }

        return $data;
    }
}