<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Karyawan_import_m extends CI_Model
{
    var $table = 'data_karyawan_temp';
    public function __construct()
    {
        parent::__construct();
    }

    public function masterJabatan()
    {
        $this->db->select("id_jabatan,kode_jabatan");
        $this->db->from("master_jabatan");
        // $this->db->where("kode_jabatan",$kode_jabatan);
        $this->db->where("id_company", $this->id_company);
        $query = $this->db->get()->result();
        $data = [];
        foreach ($query as $row) {
            $key = $row->kode_jabatan;
            $data[$key] = $row->id_jabatan;
        }

        return $data;
    }

    public function masterCabang()
    {
        $this->db->select("id_cabang,kode");
        $this->db->from("master_cabang");
        // $this->db->where("kode",$kode_cabang);
        $this->db->where("id_company", $this->id_company);
        $query = $this->db->get()->result();
        $data = [];
        foreach ($query as $row) {
            $key = $row->kode;
            $data[$key] = $row->id_cabang;
        }

        return $data;
    }

    public function masterDepartemen()
    {
        $this->db->select("id_departemen,kode");
        $this->db->from("master_departemen");
        // $this->db->where("kode",$kode_departemen);
        $this->db->where("id_company", $this->id_company);
        $query = $this->db->get()->result();
        $data = [];
        foreach ($query as $row) {
            $key = $row->kode;
            $data[$key] = $row->id_departemen;
        }

        return $data;
    }

    public function cek_username()
    {
        $this->db->select("id_karyawan,username");
        $this->db->from("users");
        $query = $this->db->get()->result();
        $data = [];
        foreach ($query as $row) {
            $key = $row->username;
            $data[$key] = $row->username;
        }

        return $data;
    }

    public function cek_nik()
    {
        $this->db->select("id_karyawan,nik");
        $this->db->from("data_karyawan");
        $this->db->where("id_company", $this->id_company);
        $query = $this->db->get()->result();
        $data = [];
        foreach ($query as $row) {
            $key = $row->id_karyawan;
            $data[$key] = $row->nik;
        }

        return $data;
    }

    function get_datatables()
    {
        $this->_get_datatables_query();
        if ($_POST['length'] != -1) {
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->_get_datatables_query();
        return $this->db->count_all_results();
    }
    private function _get_datatables_query()
    {
        $this->db->select("data_karyawan_temp.id_temp,
                            data_karyawan_temp.id_karyawan,
                            data_karyawan_temp.nama_lengkap,
                            data_karyawan_temp.nik,
                            data_karyawan_temp.gelar_depan,
                            data_karyawan_temp.no_ktp,
                            data_karyawan_temp.gelar_belakang,
                            master_cabang.nama as nama_cabang,
                            master_cabang.kode as kode_cabang,
                            master_departemen.nama as nama_departemen ,
                            master_departemen.kode as kode_departemen,
                            master_jabatan.nama as nama_jabatan,
                            master_jabatan.kode_jabatan as kode_jabatan,
                            master_jabatan.level_user,
                            master_jabatan.id_jabatan,
                            data_karyawan_temp.jatah_cuti,
                            data_karyawan_temp.tgl_aktif_bekerja,
                            data_karyawan_temp.join_date,
                            data_karyawan_temp.tgl_berhenti_bekerja,
                            data_karyawan_temp.status,
                            data_karyawan_temp.jenis_kelamin,
                            data_karyawan_temp.email,
                            data_karyawan_temp.telepon,
                            data_karyawan_temp.tempat_lahir,
                            data_karyawan_temp.tgl_lahir,
                            data_karyawan_temp.alamat_domisili,
                            data_karyawan_temp.golongan_darah,
                            data_karyawan_temp.agama,
                            data_karyawan_temp.username,
                            data_karyawan_temp.password");
        $this->db->from($this->table);
        $this->db->join('master_cabang', 'master_cabang.id_cabang = data_karyawan_temp.id_cabang', 'LEFT');
        $this->db->join('master_departemen', 'master_departemen.id_departemen = data_karyawan_temp.id_departemen', 'LEFT');
        $this->db->join('master_jabatan', 'master_jabatan.id_jabatan = data_karyawan_temp.id_jabatan', 'LEFT');
        $this->db->where('data_karyawan_temp.id_company', $this->id_company);

        $column_search = array(
            'data_karyawan_temp.nik',
            'data_karyawan_temp.nama_lengkap',
            'master_cabang.kode',
            'master_cabang.nama',
            'master_departemen.kode',
            'master_departemen.nama',
            'master_jabatan.kode_jabatan',
            'master_jabatan.nama'
        );
        $i = 0;

        foreach ($column_search as $item) {  // looping awal
            if ($_POST['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                } else {
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('', 'data_karyawan_temp.nik', 'master_cabang.kode', 'master_departemen.kode', 'master_jabatan.kode_jabatan');

        if (isset($_POST['order'])) {
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else {
            $this->db->order_by("master_departemen.kode ASC, master_jabatan.kode_jabatan ASC, data_karyawan_temp.nik ASC");
        }
    }

    public function getDataById($id = null)
    {
        $select = $this->db->select("data_karyawan_temp.id_temp,
                            data_karyawan_temp.id_karyawan,
                            data_karyawan_temp.nama_lengkap,
                            data_karyawan_temp.nik,
                            data_karyawan_temp.gelar_depan,
                            data_karyawan_temp.gelar_belakang,
                            data_karyawan_temp.no_ktp,
                            data_karyawan_temp.id_cabang,
                            master_cabang.nama as nama_cabang,
                            master_cabang.kode as kode_cabang,
                            data_karyawan_temp.id_departemen,
                            master_departemen.nama as nama_departemen ,
                            master_departemen.kode as kode_departemen,
                            data_karyawan_temp.id_jabatan,
                            master_jabatan.nama as nama_jabatan,
                            master_jabatan.kode_jabatan as kode_jabatan,
                            master_jabatan.level_user,
                            data_karyawan_temp.jatah_cuti,
                            data_karyawan_temp.tgl_aktif_bekerja,
                            data_karyawan_temp.join_date,
                            data_karyawan_temp.tgl_berhenti_bekerja,
                            data_karyawan_temp.status,
                            data_karyawan_temp.jenis_kelamin,
                            data_karyawan_temp.email,
                            data_karyawan_temp.telepon,
                            data_karyawan_temp.tempat_lahir,
                            data_karyawan_temp.tgl_lahir,
                            data_karyawan_temp.alamat_domisili,
                            data_karyawan_temp.golongan_darah,
                            data_karyawan_temp.agama,
                            data_karyawan_temp.username,
                            data_karyawan_temp.password")
            ->join('master_cabang', 'master_cabang.id_cabang = data_karyawan_temp.id_cabang', 'LEFT')
            ->join('master_departemen', 'master_departemen.id_departemen = data_karyawan_temp.id_departemen', 'LEFT')
            ->join('master_jabatan', 'master_jabatan.id_jabatan = data_karyawan_temp.id_jabatan', 'LEFT')
            ->where('data_karyawan_temp.id_company', $this->id_company)
            ->where("md5(data_karyawan_temp.id_temp)", $id)
            ->from($this->table)
            ->get()
            ->row();
        return $select;
    }

    public function save($data_pribadi, $id_temp = null, $level_user = null)
    {
        $id_temp = $this->fungsi->decrypt_idtemp($id_temp);

        if ($id_temp != null) {

            $cek_nik = $this->db->select("nik")
                ->from("data_karyawan")
                ->where("nik", $data_pribadi['nik'])
                ->where("id_karyawan !=", $id_karyawan)
                ->where("id_company", $this->id_company)
                ->get()
                ->num_rows();

            if ($cek_nik > 0) {
                $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_simpan_data_diri') . '</font>'];
                return __response_update(false, $message);
            }

            $cek_username = $this->db->select("username")
                ->from("users")
                ->where("username", $data_pribadi['username'])
                ->get()
                ->num_rows();

            if ($cek_username > 0) {
                $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_username_data_diri') . '</font>'];
                return __response_update(false, $message);
            }

            $this->db->trans_start();
            # BEGIN UPDATE DATA PRIBADI
            $this->db->where(array('id_temp' => $id_temp, 'id_company' => $this->id_company));
            $this->db->update($this->table, $data_pribadi);
            # END UPDATE DATA PRIBADI

            $this->db->trans_complete(); # Completing transaction

            if ($this->db->trans_status() === FALSE) {
                # Something went wrong.
                $this->db->trans_rollback();
                return __response_update(false);
            } else {
                # Everything is Perfect.
                # Committing data to the database.
                $this->db->trans_commit();

                $new_params = array("new_params" => array("id_temp" => md5($id_temp)));
                return __response_save(true, $new_params);
            }
        }
    }

    public function getDataExisting($id_karyawan = null)
    {
        $this->db->select("id_karyawan");
        $this->db->from("data_karyawan");
        $this->db->where("id_karyawan", $id_karyawan);
        $this->db->where("id_company", $this->id_company);

        $result = $this->db->get();
        return $result->num_rows();
    }

    public function getDataExisting_tem()
    {
        $this->db->select("id_karyawan");
        $this->db->from("data_karyawan_temp");
        $this->db->where("id_company", $this->id_company);

        $result = $this->db->get();
        return $result->num_rows();
    }

    public function insert_tunj_kehadiran_kosong($id_karyawan, $data)
    {
        $CI = &get_instance();
        $CI->load->model('Data_diri_m');

        $komponen_tunj_kehadiran = $CI->Data_diri_m->payroll_komponen('kehadiran');
        foreach ($komponen_tunj_kehadiran->result() as $row) {
            $data[] = [
                'id_item'               => $row->id_item,
                'no_urut'               => $row->no_urut,
                'id_karyawan'           => $id_karyawan,
                'nm_tunjangan'          => $row->nm_komponen,
                'flag_persentase_gapok' => $row->flag_persentase_gapok,
                'gapok_persen'          => $row->gapok_persen,
                'flag_bpjs'             => $row->flag_bpjs,
                'flag_pph21'            => $row->flag_pph21,
                'flag_pot_absensi'      => $row->flag_pot_absensi,
                'flag_cuti'             => $row->flag_cuti,
                'flag_izin'             => $row->flag_izin,
                'flag_sakit'            => $row->flag_sakit,
                'id_company'            => $row->id_company,
                'user_input'            => $this->nik . '-' . $this->nama_user
            ];
        }

        return [
            'data' => $data
        ];
    }

    public function insert_tunj_tetap_kosong($id_karyawan, $data)
    {
        $CI = &get_instance();
        $CI->load->model('Data_diri_m');

        $komponen_tunj_tetap = $CI->Data_diri_m->payroll_komponen('pendapatan');
        foreach ($komponen_tunj_tetap->result() as $row) {
            $data[] = [
                'id_item'               => $row->id_item,
                'no_urut'               => $row->no_urut,
                'jenis_komponen'        => $row->jenis_komponen,
                'jenis_master'          => $row->jenis_master,
                'id_karyawan'           => $id_karyawan,
                'nm_tunjangan'          => $row->nm_komponen,
                'flag_persentase_gapok' => $row->flag_persentase_gapok,
                'gapok_persen'          => $row->gapok_persen,
                'flag_bpjs'             => $row->flag_bpjs,
                'flag_pph21'            => $row->flag_pph21,
                'flag_pot_absensi'      => $row->flag_pot_absensi,
                'id_company'            => $row->id_company,
                'user_input'            => $this->nik . '-' . $this->nama_user
            ];
        }

        return [
            'data' => $data
        ];
    }

    public function insert_pot_tetap_kosong($id_karyawan, $data)
    {
        $CI = &get_instance();
        $CI->load->model('Data_diri_m');

        $komponen_pot_tetap = $CI->Data_diri_m->payroll_komponen('potongan');
        foreach ($komponen_pot_tetap->result() as $row) {
            $data[] = [
                'id_item'               => $row->id_item,
                'no_urut'               => $row->no_urut,
                'jenis_komponen'        => $row->jenis_komponen,
                'jenis_master'          => $row->jenis_master,
                'id_karyawan'           => $id_karyawan,
                'nm_potongan'           => $row->nm_komponen,
                'flag_persentase_gapok' => $row->flag_persentase_gapok,
                'gapok_persen'          => $row->gapok_persen,
                'flag_bpjs'             => $row->flag_bpjs,
                'flag_pph21'            => $row->flag_pph21,
                'flag_pot_absensi'      => $row->flag_pot_absensi,
                'id_company'            => $row->id_company,
                'user_input'            => $this->nik . '-' . $this->nama_user
            ];
        }

        return [
            'data' => $data
        ];
    }

    public function cek_level()
    {
        $this->db->select("kode_jabatan,level_user");
        $this->db->from("master_jabatan");
        $this->db->where("id_company", $this->id_company);
        $query = $this->db->get()->result();
        $data = [];
        foreach ($query as $row) {
            $key = $row->kode_jabatan;
            $data[$key] = $row->level_user;
        }

        return $data;
    }

    public function cek_level_list_data()
    {
        $this->db->select("id_jabatan,level_user");
        $this->db->from("master_jabatan");
        $this->db->where("id_company", $this->id_company);
        $query = $this->db->get()->result();
        $data = [];
        foreach ($query as $row) {
            $key = $row->id_jabatan;
            $data[$key] = $row->level_user;
        }

        return $data;
    }
}
