<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Data_keluarga extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Data_keluarga_m');
    }

    public function home($id_karyawan_md5)
    {
        $data['judul']           = $this->lang->line('menu_karyawan');
        $data['aktif']           = 'karyawan';
        $data['tab_karyawan']    = 'keluarga_verifikasi';
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['menu']            = $this->load->view('main_menu', $data, true);
        $data['content']         = $this->load->view('karyawan/menu', $data, true);
        $this->load->view('main_template', $data);
    }

    public function main($id_karyawan = null)
    {
        $data['id_karyawan_md5'] = $id_karyawan;
        $data['tab_aktif']       = 'verifikasi';
        $data['tab']             = $this->load->view('karyawan/data_keluarga/tab', $data, true);
        $this->load->view('karyawan/data_keluarga/home', $data);
    }

    public function list_data($id_karyawan = null)
    {
        $data['keluarga'] = $this->Data_keluarga_m->list_data($id_karyawan);
        $this->load->view('karyawan/data_keluarga/list_data', $data);
    }

    public function form($id_karyawan = null, $id_keluarga = null)
    {
        $data['id_karyawan'] = $id_karyawan;
        if ($id_keluarga != null) {
            $data['data'] = $this->Data_keluarga_m->getDataById($id_keluarga);
        }
        $this->load->view('karyawan/data_keluarga/form', $data);
    }

    public function save()
    {
        $this->load->helper('tanggal');
        $id                 = $this->input->post('id_keluarga');
        $id_karyawan        = $this->input->post('id_karyawan');
        $tanggal_perkawinan = $this->input->post('tanggal_perkawinan');

        $data = array(
            'nama'                => $this->input->post('nama'),
            'tempat_lahir'        => $this->input->post('tempat_lahir'),
            'tanggal_lahir'       => date('Y-m-d', strtotime($this->input->post('tanggal_lahir'))),
            'jenis_kelamin'       => $this->input->post('jenis_kelamin'),
            'agama'               => $this->input->post('agama'),
            'telepon'             => $this->input->post('telepon'),
            'pekerjaan'           => $this->input->post('pekerjaan'),
            'hub_keluarga'        => $this->input->post('hub_keluarga'),
            'nik'                 => $this->input->post('nik'),
            'no_bpjs'             => $this->input->post('no_bpjs'),
            'pendidikan_terakhir' => $this->input->post('pendidikan_terakhir'),
            'tanggal_perkawinan'  => format_tanggal_empty($tanggal_perkawinan),
            'status'              => $this->input->post('status'),
            'status_perkawinan'   => $this->input->post('status_perkawinan'),
            'id_company'          => $this->id_company,
            'id_karyawan'         => $this->input->post('id_karyawan')
        );

        $this->Data_keluarga_m->save_keluarga($data, $id);
    }

    public function delete()
    {
        $id = $this->input->post("id_keluarga");
        $this->Data_keluarga_m->delete($id);
    }
}
