<style>
    .icon_target_poin {
        border-radius: 10px;
        box-shadow: 0 1px 5px rgba(0, 0, 0, 0.1);
        padding: 7px;
        flex: 0 0 auto;
        height: 45px;
        width: 45px;
    }
</style>

<script type="text/javascript">
    $(function() {
        get_target_poin_harian_bulanan_karyawan();
        
        $("#filter .btn_filter:last").html('<button type="button" id="btn_filter" class="ladda-button btn btn-primary w-100" data-style="expand-left">FILTER</button>');

        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').on('error.dt', function(e, settings, techNote, message) {
            if (confirm('Terjadi kesalahan saat memproses data, muat ulang halaman ?')) {
                window.location.reload();
            }
        }).DataTable({
            'searching': false,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            'stateSave': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                <?php else : ?>
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('sales_activity.daily_activity.data', ['mulai' => date('Y-m-d'), 'selesai' => date('Y-m-d'), 'status' => 'all', 'pelanggan' => 'all', 'karyawan' => $karyawan, 'group' => 'all']) ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                    screenUp(200);
                }
            },
            "aoColumnDefs": [{
                    "targets": "_all",
                    "className": "align-top"
                },
                {
                    "render": function(data, type, row) {
                        return "<span style='white-space: nowrap;'>" + data + "</span>";
                    },
                    "targets": 1
                }
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $("td:eq(0)", nRow).css({
                    'text-align': 'center',
                    'width': '30px'
                });
                $("td:eq(1), td:eq(-1)", nRow).css({
                    'text-align': 'center',
                    'width': '100px'
                });
                <?php if ($this->is_sales_admin === true || $this->level_user == '1' || $this->is_sales_atasan === true) : ?>
                    $("td:eq(4)", nRow).css({
                        'text-align': 'center',
                        'width': '50px'
                    });
                <?php else : ?>
                    $("td:eq(3)", nRow).css({
                        'text-align': 'center',
                        'width': '50px'
                    });
                <?php endif; ?>
            }
        });

        /**
         * FILTER
         */

        // periode
        tanggal();
        pickrange();

        // status
        const pengajuanCheckbox = document.getElementById('pengajuan');
        const disetujuiCheckbox = document.getElementById('disetujui');
        const ditolakCheckbox = document.getElementById('ditolak');

        pengajuanCheckbox.addEventListener('change', validateCheckboxes);
        disetujuiCheckbox.addEventListener('change', validateCheckboxes);
        ditolakCheckbox.addEventListener('change', validateCheckboxes);

        function validateCheckboxes() {
            if (!pengajuanCheckbox.checked && !disetujuiCheckbox.checked && !ditolakCheckbox.checked) {
                this.checked = true;
            }
        }

        // pelanggan
        $("#pelanggan").select2({
            placeholder: "Semua Pelanggan",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.kanban.list_pelanggan") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        // karyawan
        $("#karyawan").select2({
            placeholder: "Semua Sales",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.kanban.list_sales") ?>',
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        search: params.term,
                        topic: "log_activity",
                        range: 1,
                        start: $("#tanggal_mulai").val(),
                        end: $("#tanggal_selesai").val()
                    };
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        // group
        $('#group').select2({
            placeholder: "Semua Group",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.kanban.list_group") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $("#btn_filter").on("click", function() {
            var loading = Ladda.create(this);
            let mulai = $("#tanggal_mulai").val();
            let selesai = $("#tanggal_selesai").val();
            let status = "all";
            let pelanggan = $("#pelanggan").val() ? $("#pelanggan").val() : "all";
            let karyawan = "";
            let group = "all";
            <?php if ($this->is_sales_admin === true || $this->level_user == '1' || $this->is_sales_atasan === true) : ?>
                karyawan = $("#karyawan").val() ? $("#karyawan").val() : "all";
                group = $("#group").val() ? $("#group").val() : "all";
            <?php else: ?>
                karyawan = "<?= $this->id_karyawan ?>";
            <?php endif; ?>

            if (!pengajuanCheckbox.checked || !disetujuiCheckbox.checked || !ditolakCheckbox.checked) {
                status = $("input[name='status[]']:checked").map(function() {
                    return this.value;
                }).get();
                status = status.join("_");
            }

            console.log(group);

            loading.start();
            list_data.ajax.url("<?= route('sales_activity.daily_activity.data', ['mulai' => '" + mulai + "', 'selesai' => '" + selesai + "', 'status' => '" + status + "', 'pelanggan' => '" + pelanggan + "', 'karyawan' => '" + karyawan + "', 'group' => '" + group + "']) ?>").load(function(response, status, xhr) {
                loading.stop();
            });
        });
    });

    function tanggal() {
        var d = new Date();
        d.setDate(d.getDate());
        $('.input-daterange input').each(function() {
            $(this).datepicker({
                orientation: "bottom",
                format: "dd-mm-yyyy",
                endDate: d,
                autoclose: true,
            });
        });
    }
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
        <label class="content-header-title" style="font-size: 16px"><?= $judul ?></label>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <?php
            if($this->level_user != "1"):
        ?>
                <div class="target_poin_per_karyawan content-header-right">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-2 mr-1">
                                    <div class="icon_target_poin" style="background-color:#007aff;">
                                        <img src="<?= $this->config->item('dir_assets') ?>images/icon/target_icon.png" style="width:30px;height:30px;">
                                    </div>
                                </div>
                                <div class="col-md-9">
                                    <label>Poin Anda Hari Ini</label><BR>
                                    <label id="target_poin_harian" class="font-weight-bold">0 / 0</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-2 pl-0">
                                    <div class="icon_target_poin" style="background-color:#ff9500;">
                                        <img src="<?= $this->config->item('dir_assets') ?>images/icon/target_icon.png" style="width:30px;height:30px;">
                                    </div>
                                </div>
                                <div class="col-md-9">
                                    <label>Realisasi Poin Anda Bulan Ini</label><BR>
                                    <label id="target_poin_bulanan" class="font-weight-bold">0 / 0</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        <?php
            endif;
        ?>
    </div>
</div>
<hr>



<div id="filter">
    <div class="row">
        <div class="col-md-9 my-1">
            <div class="row">
                <div class="col-md-2">
                    <label><?= $this->lang->line('periode'); ?></label>
                </div>
                <div class="col-md-8">
                    <div class="input-group input-daterange">
                        <input type="text" class="form-control masktanggal" value="<?= $periode_mulai; ?>" id="tanggal_mulai" required>
                        <span class="align-self-center mx-1"><?= $this->lang->line('s/d'); ?></span>
                        <input type="text" class="form-control masktanggal" value="<?= $periode_selesai; ?>" id="tanggal_selesai" required>
                    </div>
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-2">
                    <label>Status</label>
                </div>
                <div class="col-md-8">
                    <span class="pr-1">
                        <input id="pengajuan" type="checkbox" name="status[]" value="pengajuan" checked>
                        <label for="pengajuan"><?= $this->lang->line('pengajuan') ?></label>
                    </span>
                    <span class="pr-1">
                        <input id="disetujui" type="checkbox" name="status[]" value="approve" checked>
                        <label for="disetujui"><?= $this->lang->line('disetujui') ?></label>
                    </span>
                    <span class="pr-1">
                        <input id="ditolak" type="checkbox" name="status[]" value="tolak" checked>
                        <label for="ditolak"><?= $this->lang->line('ditolak') ?></label>
                    </span>
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-2">
                    <label>Pelanggan</label>
                </div>
                <div class="col-md-8">
                    <select id="pelanggan" class="select2 form-control"></select>
                </div>
                <div class="col-md-2 btn_filter"></div>
            </div>
            <?php if ($this->is_sales_admin === true || $this->level_user == '1' || $this->is_sales_atasan === true) : ?>
                <div class="row mt-1">
                    <div class="col-md-2">
                        <label>Sales</label>
                    </div>
                    <div class="col-md-8">
                        <select id="karyawan" class="select2 form-control"></select>
                    </div>
                    <div class="col-md-2 btn_filter"></div>
                </div>
            <?php endif; ?>
            <?php if ($this->level_user === '1' || $this->fungsi->cek_adm_satu_grup() == false) : ?>
                <div class="row mt-1">
                    <div class="col-md-2">
                        <label>Group</label>
                    </div>
                    <div class="col-md-8">
                        <select id="group" class="select2 form-control" style="width: 100%;"></select>
                    </div>
                    <div class="col-md-2 btn_filter"></div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<hr>

<div class="table-responsive">
    <table id="list_data" class="table table-bordered table-striped" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle">NO</th>
                <th class="text-center align-middle">TANGGAL</th>
                <?php if ($this->is_sales_admin === true || $this->level_user == '1' || $this->is_sales_atasan === true) : ?>
                    <th class="text-center align-middle">SALES</th>
                <?php endif; ?>
                <th class="text-center align-middle">AKTIVITAS</th>
                <th class="text-center align-middle">POIN</th>
                <th class="text-center align-middle">KETERANGAN</th>
                <th class="text-center align-middle">PELANGGAN</th>
                <th class="text-center align-middle">LEAD SOURCE</th>
                <th class="text-center align-middle">STATUS</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
