<?php
$CI = &get_instance();
?>
<script type="text/javascript">
    $(function() {

        datatables_calendar();

        $(document).on('click', '#btn_tab_kalender_view', function() {
            thumbnail_calendar()
        });

        $(document).on('click', '#btn_tab_list_view', function() {
            datatables_calendar();
        });


        $(document).on('click', '#btn_search', function() {
            datatables_calendar();
        });

        $('.datepicker').datepicker({
            autoclose: true,
            language: "id",
            locale: "id",
            todayHighlight: true
        });

        $(".dateonly").keydown(function(e) {
            // Allow: backspace, delete, tab, escape, enter and
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 189]) !== -1 ||
                // Allow: Ctrl+A
                (e.keyCode == 65 && e.ctrlKey === true) ||
                // Allow: home, end, left, right, down, up
                (e.keyCode >= 35 && e.keyCode <= 40)) {
                // let it happen, don't do anything
                return;
            }
            // Ensure that it is a number and stop the keypress
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
                $("#jumlah_barang").focus();
                return false();
            }
        });

        $(document).on('click', '.btn_tambah', function() {
            $('#tampil_form').load("<?= route('pengaturan.harilibur.form.tambah') ?>", function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('<?= $this->lang->line('button_form_simpan') ?>');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click', '.btn_edit', function() {
            const id = $(this).attr('id');
            $('#tampil_form').load("<?= route('pengaturan.harilibur.form.edit', ['id' => '"+id+"']) ?>", function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
                $(".btn_update").addClass("btn_update btn btn-warning");
                $(".btn_update").append('<i class="fa fa-edit (alias)"></i> ');
                $(".btn_update").append('<?= $this->lang->line('button_form_perbarui') ?>');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click', '.btn_delete', function() {
            const id = $(this).attr('id');
            $('#tampil_form').load("<?= route('pengaturan.harilibur.form.hapus', ['id' => '"+id+"']) ?>", function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
                $('#form_input input[type=text]').prop("disabled", true);
                $('#form_input input[type=date]').prop("disabled", true);
                $('#form_input select').prop("disabled", true);
                $(".btn_update").append('<i class="fa fa-trash"></i> ');
                $(".btn_update").append('<?= $this->lang->line('button_form_hapus') ?>');
                $(".btn_update").removeClass("btn_update").addClass("btn_hapus btn btn-danger");
            });
        });

        $(document).on('click', '#btn_new_input', function() {
            $('#form_input input[type=text]').prop("disabled", false);
            $("#form_input input[type=text]").val('');
            $('#form_input input[type=date]').prop("disabled", false);
            $("#form_input input[type=date]").val('');
            $('#form_input select').prop("disabled", false);
            $("#form_input select").val('');

            $('#tanggal').datepicker('clearDates'); // kosongkan datepicker
            $('#datepicker-tags-container').html('<span class="placeholder-text">dd-mm-yyyy</span>');

            $('.btn_save').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });

        $(document).on("click", ".btn_save", function(e) {
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            if ($("#tanggal").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tanggal_libur') ?></font>");
                $("#tanggal").focus();
                return false;
            } else if ($("#keterangan").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_keterangan_libur') ?></font>");
                $('#keterangan').focus();
                return false;
            } else if (!$("#jenis").val()) {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jenis_libur') ?></font>");
                $('#jenis').focus();
                return false;
            }

            loading.start();

            var param = 'tanggal=' + $("#tanggal").val() +
                '&keterangan=' + $("#keterangan").val() +
                '&jenis=' + $("#jenis").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('pengaturan.harilibur.save') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        if (result.type == 'save') {
                            $("#form_input :input").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }
                        thumbnail_calendar();
                    }
                    loading.stop();
                    $('#modal_form #message').show();
                    $('#modal_form #message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#modal_form #message').show();
                    $('#modal_form #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });

        $(document).on("click", ".btn_update", function(e) {
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            if ($("#tanggal").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tanggal_libur') ?></font>");
                $("#tanggal").focus();
                return false;
            } else if ($("#keterangan").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_keterangan_libur') ?></font>");
                $('#keterangan').focus();
                return false;
            } else if (!$("#jenis").val()) {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jenis_libur') ?></font>");
                $('#jenis').focus();
                return false;
            }

            loading.start();

            var param = 'id=' + $("#id").val() +
                '&tanggal=' + $("#tanggal").val() +
                '&keterangan=' + $("#keterangan").val() +
                '&jenis=' + $("#jenis").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('pengaturan.harilibur.update') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        if (result.type == 'save') {
                            $("#form_input :input").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }
                        thumbnail_calendar();
                    }
                    loading.stop();
                    $('#modal_form #message').show();
                    $('#modal_form #message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#modal_form #message').show();
                    $('#modal_form #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });

        // PROSES DELETE
        $(document).on('click', '.btn_hapus', function() {
            var loading = Ladda.create(this);
            loading.start();
            $.ajax({
                type: 'POST',
                url: "<?= route('pengaturan.harilibur.delete') ?>",
                data: 'id=' + $("#id").val(),
                dataType: 'JSON',
                success: function(result) {
                    showMsg(result.message);
                },
                error: function() {
                    loading.stop();
                    showMsg('error', false);
                }
            });
        });

        $('#tahun').select2({
            placeholder: "Pilih tahun"
        });

        $("#btn_export").click(function(e) {
            e.preventDefault();
            var tahun = $('#tahun').val();
            window.location.href = "<?= route('pengaturan.harilibur.export', ['id' => '"+tahun+"']) ?>";
        });
    });

    function datatables_calendar() {
        $('#view_list').load("<?= route('pengaturan.harilibur.view.list') ?>");
    }

    function thumbnail_calendar() {
        $("#thumbnail_view").load('<?= route("pengaturan.harilibur.view.thumbnail") ?>');
    }


    function detail_holiday(event) {
        $("#modal_update_kalender .card-body").show();
        $("#modal_update_kalender .card-footer").show();
        $("#modal_update_kalender .title").html("Form");
        $('#modal_update_kalender #message').hide();
        $('#modal_update_kalender #id_hari_libur').val(event.id_holiday);
        $('#modal_update_kalender .title').html(moment(event.start).format('DD MMMM YYYY'));
        $('#modal_update_kalender #tanggal').val(moment(event.start).format('YYYY-MM-DD'));
        $('#modal_update_kalender #tanggal').prop("disabled", true);
        $('#modal_update_kalender #keterangan').val(event.title);
        $('#modal_update_kalender #jenis').val(event.jenis);
        $('#modal_update_kalender').modal('show');
    }

    function editDataHoliday(event) {
        $('#modal_update_kalender #btn_update').click(function(e) {
            e.preventDefault();
            var loading = Ladda.create(this);
            loading.start();

            var param = 'id=' + $("#modal_update_kalender #id_hari_libur").val() +
                '&tanggal=' + $("#modal_update_kalender #tanggal").val() +
                '&keterangan=' + $("#modal_update_kalender #keterangan").val() +
                '&jenis=' + $("#modal_update_kalender #jenis").val();
            $.ajax({
                url: '<?= route('pengaturan.harilibur.update') ?>',
                type: 'POST',
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        $('#modal_update_kalender').modal('hide');
                        showMsg(result.message, true, 1500);
                        setTimeout(() => {
                            thumbnail_calendar();
                        }, 1500);
                    }
                    loading.stop();
                    $('#modal_update_kalender #message').html(result.message);
                    $('#modal_update_kalender #message').show();
                },
                error: function() {
                    loading.stop();
                    $('#modal_update_kalender #message').show();
                    $('#modal_update_kalender #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        })
    }

    function deleteDataHoliday(event) {
        $('#modal_update_kalender .delete_holiday').click(function() {
            var loading = Ladda.create(this);
            loading.start();

            $.ajax({
                url: '<?= route('pengaturan.harilibur.delete') ?> ',
                type: 'POST',
                data: 'id=' + event.id_holiday,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        $('#modal_update_kalender').modal('hide');
                        showMsg(result.message, true, 1500);
                        setTimeout(() => {
                            thumbnail_calendar();
                        }, 1500);
                    }
                    loading.stop();
                    $('#modal_update_kalender #message').html(result.message);
                    $('#modal_update_kalender #message').show();
                },
                error: function() {
                    loading.stop();
                    $('#modal_update_kalender #message').show();
                    $('#modal_update_kalender #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        })
    };
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_pengaturan'); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <?php
            if (in_array($this->session->userdata('level_user'), array("1"))) {
            ?>
                <div class="float-md-right">
                    <!-- <a href='<?= base_url("kalender/template_kalender.xlsx") ?>' target = '_blank' class='btn btn-warning'><i class="fa fa-file"></i> Template</a>
                <button class=" btn btn-info" id="btn_export"><i class="fa fa-download"></i> Download</button>
                <button class=" btn btn-success" data-toggle="modal" data-target="#modal_import" id="btn_import"><i class="fa fa-upload"></i> Upload</button> -->
                    <button type="button" class="btn_tambah btn btn-biru">
                        <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
                    </button>
                </div>
            <?php } ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <ul class="nav nav-tabs" role="tablist">
                <li class="nav-item">
                    <a id="btn_tab_list_view" class="nav-link active" href="#profile" role="tab" data-toggle="tab"><?= $this->lang->line('daftar_tabel') ?></a>
                </li>
                <li class="nav-item">
                    <a id="btn_tab_kalender_view" class="nav-link" href="#thumbnail_view" role="tab" data-toggle="tab">
                        <?php
                        $text = $this->lang->line('kalender');
                        $text = ucwords(strtolower($text));
                        echo $text;
                        ?>
                    </a>
                </li>
            </ul>

            <!-- Tab panes -->
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="profile">
                    <br>
                    <div id="view_list" class="col-md-12 bbna"></div>

                </div>
                <!-- <div id="buzz" role="tabpanel" class="tab-pane"></div> -->
                <div id="thumbnail_view" role="tabpanel" class="tab-pane"></div>
            </div>
        </div>
    </div>
</div>

<!-- <div id="modal_import" class="modal fade" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modal-title">Import Data</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div id="box-body" class="modal-body">
                <?= form_open('', "id='form_data_import'") ?>
                <input type="file" name="file" id="file" class="form-control " />
                <?= form_close() ?>
            </div>
            <div class="modal-footer">
                <span id="alert-success-import" style="color:#009900;font-weight: bold"><i class="fa fa-check-square">&nbsp;</i><span id="message-success-import"> <?= $this->lang->line('success_save'); ?></span></span>
                <span id="alert-danger-import" style="color:#eb3a28;font-weight: bold"><i class="fa fa-window-close">&nbsp;</i><span id="message-danger-import"> <?= $this->lang->line('failed_save'); ?> </span></span>
                <button type="button" id="btn_save-import" class=" btn btn-success btn-save ladda-button" data-style="expand-left">
                    <span class="ladda-label"><?= $this->lang->line('button_form_simpan'); ?></span>
                </button>
            </div>
        </div>
    </div>
</div> -->

<script type="text/javascript">
    $(document).ready(function() {

        // $(document).on('click', '#btn_import', function() {
        //     $("#alert-success-import, #alert-danger-import").hide();
        // });

        // $(document).on('click', '#btn_save-import', function() {
        //     $('#btn_save-import').prop('disabled', true);
        //     var loading = Ladda.create(this);
        //     loading.start();

        //     var form = $('#form_data_import')[0];
        //     var data = new FormData(form);

        //     $.ajax({
        //         type: 'POST',
        //         url: "<?= route('pengaturan.harilibur.import') ?>",
        //         data: data,
        //         async: false,
        //         cache: false,
        //         contentType: false,
        //         enctype: 'multipart/form-data',
        //         processData: false,
        //         dataType: "json",
        //         success: function(result) {
        //             if (result.status === 'success') {
        //                 $("#message-success-import").text("<?= $this->lang->line('success_update_reimburse'); ?>");
        //                 $("#alert-success-import").show();
        //             } else {
        //                 $("#message-danger-import").text("<?= $this->lang->line('failed_update_reimburse'); ?>");
        //                 $("#alert-danger-import").show();
        //             }

        //             $('#btn_save-import').prop('disabled', false);
        //             loading.stop();
        //         },
        //         error: function() {
        //             $("#message-danger-import").text("<?= $this->lang->line('failed_update_reimburse'); ?>");
        //             $("#alert-danger-import").show();
        //             $('#btn_save-import').prop('disabled', false);
        //             loading.stop();
        //         }
        //     });

        // });

    });
</script>

<script type="text/javascript">
    function checkAvailability() {
        $("#user-availability-status").hide();
        $("#loaderIcon").show();
        jQuery.ajax({
            url: "<?= route('pengaturan.harilibur.cek_tanggal') ?>",
            data: 'tanggal=' + $("#tanggal").val(),
            type: "POST",
            success: function(data) {
                if (data == 'sudah') {
                    $("#user-availability-status").show();
                    $("#user-availability-status").html("<span class='status-not-available' style='color: red;'> <?= $this->lang->line('error_tanggal_libur_2'); ?></span>");
                    $("#loaderIcon").hide();
                    $(".btn_save").prop('disabled', true);
                } else {
                    $("#user-availability-status").show();
                    $("#user-availability-status").html("<span class='status-not-available' style='color: green;'>  <?= $this->lang->line('error_tanggal_libur_3'); ?></span>");
                    $("#loaderIcon").hide();
                    $(".btn_save").prop('disabled', false);
                }
            },
        })
    }
</script>
