[//]: # ([author] Anderson Salas, translated by Julio Cedeño)
[//]: # ([meta_description] Luthier CI routes also work for the command line, and here we explain how to use them)

# Command line

### Contents

1. [Introduction](#introduction)
2. [Syntax](#syntax)
3. [Using CLI routes](#using-cli-routes)
4. [Built-in CLI tools](#built-in-cli-tools)
    1. [Activation](#activation)
    2. ['luthier make' command](#luthier-make)
    3. ['luthier migrate' command](#luthier-migrate)

### <a name="introduction"></a> Introduction

Thanks to Luthier CI you can take advantage of the possibilities offered by the framework through the command line interface (CLI).

### <a name="syntax"></a> Sintaxis

The CLI routes are similar to the HTTP and AJAX routes in their syntax. CLI routes must be defined in the `application/routes/cli.php` file

Example:

```php
<?php
# application/routes/cli.php

// Using anonymous functions
Route::cli('test', function(){ // <- (note that here the method is 'cli' and not 'get', 'post', etc.)
    echo 'Hello world!';
});

// Pointing to an existing controller
Route::cli('test2', 'foo@bar');
```

CLI routes share the same properties as their HTTP/AJAX counterparts, you can learn more about them [here](./routes#syntax).

### <a name="using-cli-routes"></a> Using CLI routes

To access the CLI routes you must call the PHP interpreter from the command line in the `index.php` file of the root folder of your application, separating each segment of the desired route with spaces, for example:

```
$ php path/to/app/index.php [segment1] [segument2] ... [segmentN]
```

So, having this route:

```php
Route::cli('make/controller/{name}', function($name){
    echo 'Making the controller ' . $name ;
});
```

It can be accessed by running:

```
$ php path/to/app/index.php make controller test
```

And the result would be:

```
Making the controller test
```

### <a name="built-in-cli-tools"></a> Built-in CLI tools

As of version 0.2.0 Luthier CI comes with several command line tools that will help you with some repetitive tasks.

<div class="alert alert-warning">
    <i class="fa fa-warning" aria-hidden="true"></i>
    <strong>Writing permissions</strong>
    <br />
    Make sure that the <code>application</code> folder has write permissions so that these commands work correctly
</div>

<div class="alert alert-info">
    <i class="fa fa-info-circle" aria-hidden="true"></i>
    <strong>Only available for development</strong>
    <br />
    For security reasons, these commands will be disabled if your application is configured with the <code>testing</code> or <code>production</code> environments
</div>

#### <a name="activation"></a> Activation

CLI tools are disabled by default. To activate them, just add a couple of lines to your routes file:

```php
<?php
# application/routes/cli.php

Luthier\Cli::maker();      // 'luthier make' command
Luthier\Cli::migrations(); // 'luthier migrate' command
```

#### <a name="luthier-make"></a> <kbd>luthier make</kbd> command

This allows generating a wide variety of framework files.

Syntax:

```
$ php index.php luthier make [resource] [name] [type?(sequenatial|date)=date]
```

Where `resource` is the resource type (`controller`, `model`, ` helper`, `library`, ` middleware` or `migration`), `name` is the name
of the resource and `type` (in case of creating a migration) is the type of migration to generate.

Examples:

```
// Creating a controller:
$ php index.php luthier make controller ControllerName

// Creating a model:
$ php index.php luthier make model ModelName

// Creating a library:
$ php index.php luthier make library LibraryName

// Creating a helper:
$ php index.php luthier make helper HelperName

// Creating a middleware:
$ php index.php luthier make middleware MiddlewareName

// Creating a migration (by default, migrations are created by date)
$ php index.php luthier make migration create_users_table
$ php index.php luthier make migration create_users_table date
$ php index.php luthier make migration create_users_table sequential
```

#### <a name="luthier-migrate"></a> <kbd>luthier migrate</kbd> command

Runs (or rollback) a migration.

Syntax:

```
$ php index.php luthier migrate [version?=latest]
```

Where `version` is the version of the migration to run. If it's omitted, it will proceed to migrate to the latest available version.

It's also possible to use one of these special values as `version`:

* `reverse`: reverses ALL migrations
* `refresh`: reverses ALL migrations and then proceeds to migrate to the latest available version

Examples:

```
$ php index.php luthier migrate reverse
$ php index.php luthier migrate refresh
```
