<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Riwayat_pendidikan_pengajuan_m extends CI_Model {
    var $table = 'riwayat_pendidikan_p';

    public function list_data($id_karyawan = null){
      $query = $this->db->select("id_riwayat_pendidikan,
                                  nama_sekolah,
                                  jenjang,
                                  jurusan,
                                  lulusan_asal,
                                  gelar,
                                  tahun_masuk,
                                  tahun_lulus,
                                  ijazah,
                                  transkrip,
                                  status_pengajuan,
                                  action,
                                  ket_revisi")
                          ->from($this->table)
                          ->where("MD5(id_karyawan)",$id_karyawan)
                          ->order_by("jenjang = 'SD', jenjang = 'SMP/MTS', jenjang = 'SMA/SMK/', jenjang = 'Dlipoma', jenjang = 'Sarjana', jenjang = 'Magister', jenjang = 'Doctor'")
                          ->get()
                          ->result();
      return $query;
    }

    function get_data_pengajuan($id_karyawan_md5) {
      $this->db->where('md5(id_karyawan)', $id_karyawan_md5);
      $this->db->where('id_company', $this->session->userdata('id_company'));
      $this->db->where_in('status_pengajuan', array('1','3','4'));
      return $this->db->get($this->table);
    }

    function total_pengajuan() {
      $this->db->where('id_company', $this->session->userdata('id_company'));
      $this->db->where_in('status_pengajuan', array('1','3','4'));
      return $this->db->get($this->table);
    }

    function get_data($id_karyawan_md5) {
      $this->db->where('md5(id_karyawan)', $id_karyawan_md5);
      $this->db->where('id_company', $this->session->userdata('id_company'));
      return $this->db->get($this->table);
    }
    function getDataById($id_riwayat_pendidikan) {
      $this->db->where('md5(id_riwayat_pendidikan)', $id_riwayat_pendidikan);
      $this->db->where('id_company', $this->session->userdata('id_company'));
      return $this->db->get($this->table);
    }

    function delete($id_riwayat_pendidikan) {
      $this->db->where('md5(id_riwayat_pendidikan)', $id_riwayat_pendidikan);
      $this->db->where('id_company', $this->session->userdata('id_company'));
      return $this->db->delete($this->table);
    }

    function approve($id, $status, $keterangan = '') {

      $this->db->set('status_pengajuan', $status);
      if($keterangan != '') {
        $this->db->set('ket_revisi', $keterangan);
      }
      $this->db->where('md5(id_riwayat_pendidikan)', $id);
      $this->db->where('id_company', $this->session->userdata('id_company'));
      return $this->db->update($this->table);
    }

    function insert_history($id, $folder_transkip, $folder_ijazah) {
      $sql = "INSERT INTO riwayat_pendidikan_h (
                            id_riwayat_pendidikan,
                            id_karyawan,
                            nama_sekolah,
                            jenjang,
                            jurusan,
                            lulusan_asal,
                            gelar,
                            tahun_masuk,
                            tahun_lulus,
                            ijazah,
                            transkrip,
                            action,
                            id_company
                                        )
                     SELECT riwayat_pendidikan.id_riwayat_pendidikan,
                            riwayat_pendidikan.id_karyawan,
                            riwayat_pendidikan.nama_sekolah,
                            riwayat_pendidikan.jenjang,
                            riwayat_pendidikan.jurusan,
                            riwayat_pendidikan.lulusan_asal,
                            riwayat_pendidikan.gelar,
                            riwayat_pendidikan.tahun_masuk,
                            riwayat_pendidikan.tahun_lulus,
                            '{$folder_ijazah}',
                            '{$folder_transkip}',
                            riwayat_pendidikan_p.action,
                            riwayat_pendidikan.id_company
              FROM riwayat_pendidikan 
              JOIN riwayat_pendidikan_p ON riwayat_pendidikan_p.id_riwayat_pendidikan = riwayat_pendidikan.id_riwayat_pendidikan
              WHERE md5(riwayat_pendidikan.id_riwayat_pendidikan) = ? AND riwayat_pendidikan.id_company = ?";
      return $this->db->query($sql, array($id, $this->session->userdata('id_company')));
    }

    function insert_master($id, $folder_transkip, $folder_ijazah) {
      $sql = "INSERT INTO riwayat_pendidikan (
                            id_riwayat_pendidikan,
                            id_karyawan,
                            nama_sekolah,
                            jenjang,
                            jurusan,
                            lulusan_asal,
                            gelar,
                            tahun_masuk,
                            tahun_lulus,
                            ijazah,
                            transkrip,
                            id_company
                                        )
                    SELECT id_riwayat_pendidikan,
                            id_karyawan,
                            nama_sekolah,
                            jenjang,
                            jurusan,
                            lulusan_asal,
                            gelar,
                            tahun_masuk,
                            tahun_lulus,
                            '{$folder_ijazah}',
                            '{$folder_transkip}',
                            id_company
              FROM riwayat_pendidikan_p WHERE md5(id_riwayat_pendidikan) = ? AND id_company = ?";
      return $this->db->query($sql, array($id, $this->session->userdata('id_company')));
    }

    function update_data($id, $folder_transkip, $folder_ijazah) {
      $sql = "UPDATE riwayat_pendidikan a
              JOIN riwayat_pendidikan_p b ON b.id_riwayat_pendidikan = a.id_riwayat_pendidikan AND a.id_karyawan = b.id_karyawan AND a.id_company = b.id_company
              SET a.nama_sekolah = b.nama_sekolah,
                  a.jenjang = b.jenjang,
                  a.jurusan = b.jurusan,
                  a.lulusan_asal = b.lulusan_asal,
                  a.gelar = b.gelar,
                  a.tahun_masuk = b.tahun_masuk,
                  a.tahun_lulus = b.tahun_lulus,
                  a.ijazah = '{$folder_ijazah}',
                  a.transkrip = '{$folder_transkip}'
              WHERE md5(a.id_riwayat_pendidikan) = ? AND a.id_company = ?";
      return $this->db->query($sql, array($id, $this->session->userdata('id_company')));
    }

    function hapus_data($id) {
      $this->db->where('md5(id_riwayat_pendidikan)', $id);
      return $this->db->delete('riwayat_pendidikan');
    }

    function cek_id($id) {
      $this->db->join('riwayat_pendidikan','riwayat_pendidikan.id_riwayat_pendidikan = riwayat_pendidikan_p.id_riwayat_pendidikan');
      $this->db->where('md5(riwayat_pendidikan_p.id_riwayat_pendidikan)', $id);
      return $this->db->get('riwayat_pendidikan_p')->num_rows();
    }

    function update_path_foto_history($id, $folder_history_transkip, $folder_history_ijazah) 
    {
        // update path foto yang sama dengan master diisi path foto yang sudah dipindah ke history
        $sql = "UPDATE riwayat_pendidikan_h history 
            JOIN riwayat_pendidikan master 
                on master.id_riwayat_pendidikan = history.id_riwayat_pendidikan 
                    and master.transkrip = history.transkrip 
                    and master.ijazah = history.ijazah 
            SET history.transkrip = ?, history.ijazah = ? 
            WHERE md5(history.id_riwayat_pendidikan) = ?";
        $this->db->query($sql, [$folder_history_transkip, $folder_history_ijazah, $id]);
    }
}
