<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Data_diri_m extends CI_Model
{
    var $table = 'data_karyawan';

    public function __construct()
    {
        parent::__construct();
        $this->nik = $this->session->userdata("nik");
        $this->nama_user = $this->session->userdata("nama_user");
        $this->id_company = $this->session->userdata("id_company");
    }

    public function getDataById($id_karyawan = null)
    {
        $select = $this->db->select("dk.id_karyawan,
                                    dk.nik,
                                    dk.nama_lengkap,
                                    dk.gelar_depan,
                                    dk.gelar_belakang,
                                    dk.no_ktp,
                                    dk.jenis_kelamin,
                                    dk.golongan_darah,
                                    dk.agama,
                                    dk.tempat_lahir,
                                    dk.tgl_lahir,
                                    dk.alamat_ktp,
                                    dk.alamat_domisili,
                                    dk.rt,
                                    dk.rw,
                                    master_provinsi.id_prov,
                                    master_provinsi.nama as nama_prov,
                                    master_kota.id_kota,
                                    master_kota.nama as nama_kota,
                                    master_kecamatan.id_kecamatan,
                                    master_kecamatan.nama as nama_kec,
                                    master_kelurahan.id_kelurahan,
                                    master_kelurahan.nama as nama_kel,
                                    dk.kode_pos,
                                    dk.telepon,
                                    dk.email,
                                    dk.join_date,
                                    dk.tgl_aktif_bekerja,
                                    dk.tgl_berhenti_bekerja,
                                    dk.id_departemen,
                                    dk.id_cabang,
                                    dk.id_jabatan,
                                    dk.supervisi,
                                    dk.jatah_cuti,
                                    dk.pendidikan_terakhir,
                                    dk.status,
                                    dk.foto,
                                    dk.no_bpjs_kes,
                                    dk.no_bpjs_tk,
                                    dk.jml_anak,
                                    master_cabang.id_cabang,
                                    master_cabang.kode as kode_cabang,
                                    master_cabang.nama as nama_cabang,
                                    master_departemen.id_departemen,
                                    master_departemen.kode as kode_departemen,
                                    master_departemen.nama as nama_departemen,
                                    master_jabatan.id_jabatan,
                                    master_jabatan.kode_jabatan,
                                    master_jabatan.nama as nama_jabatan,
                                    master_jabatan.level_user,
                                    spv.id_karyawan as id_supervisi,
                                    spv.nik as nik_supervisi,
                                    spv.nama_lengkap as nama_supervisi")
            ->join("master_cabang", "master_cabang.id_cabang = dk.id_cabang", "LEFT")
            ->join("master_departemen", "master_departemen.id_departemen = dk.id_departemen", "LEFT")
            ->join("master_jabatan", "master_jabatan.id_jabatan = dk.id_jabatan", "LEFT")
            ->join("master_provinsi", "master_provinsi.id_prov = dk.id_prov", "LEFT")
            ->join("data_karyawan AS spv", "spv.id_karyawan = dk.supervisi", "LEFT")
            ->join("master_kota", "master_kota.id_kota = dk.id_kab", "LEFT")
            ->join("master_kecamatan", "master_kecamatan.id_kecamatan = dk.id_kec", "LEFT")
            ->join("master_kelurahan", "master_kelurahan.id_kelurahan = dk.id_kel", "LEFT")
            ->where("MD5(dk.id_karyawan)", $id_karyawan)
            ->from("data_karyawan AS dk")
            ->get()
            ->row();
        return $select;
    }

    public function getDataById_numrows()
    {
        $select = $this->db->select("dk.id_karyawan,
                                    master_jabatan.level_user")
            ->join("master_cabang", "master_cabang.id_cabang = dk.id_cabang", "LEFT")
            ->join("master_departemen", "master_departemen.id_departemen = dk.id_departemen", "LEFT")
            ->join("master_jabatan", "master_jabatan.id_jabatan = dk.id_jabatan", "LEFT")
            ->join("master_provinsi", "master_provinsi.id_prov = dk.id_prov", "LEFT")
            ->join("data_karyawan AS spv", "spv.id_karyawan = dk.supervisi", "LEFT")
            ->join("master_kota", "master_kota.id_kota = dk.id_kab", "LEFT")
            ->join("master_kecamatan", "master_kecamatan.id_kecamatan = dk.id_kec", "LEFT")
            ->join("master_kelurahan", "master_kelurahan.id_kelurahan = dk.id_kel", "LEFT")
            ->where("dk.id_company", $this->id_company)
            ->where("master_jabatan.level_user", 1)
            ->from("data_karyawan AS dk")
            ->get()
            ->num_rows();
        return $select;
    }

    public function save($data_pribadi, $data_akun, $id_karyawan = null, $level_user = null)
    {
        $id_karyawan = $this->fungsi->decrypt_idkaryawan($id_karyawan);

        if ($id_karyawan != null) {
            $status_lama = $this->db->select("status")
                ->from("data_karyawan")
                ->where("id_karyawan", $id_karyawan)
                ->where("id_company", $this->id_company)
                ->get()
                ->row('status');
            if (in_array($status_lama, ["5", "6", "7"])) {  # JIKA STATUS SEBELUMNYA ADALAH TIDAK AKTIF
                if (in_array($data_pribadi["status"], ["1", "2", "3", "4"])) {  # JIKA STATUS BARU AKTIF
                    $cek_limit =  $this->_cekLimitJumlahKaryawan();
                    if ($cek_limit !== true) {
                        return $cek_limit;
                    }
                }
            }

            # BEGIN CEK NIK YANG SAMA
            $cek_nik = $this->db->select("nik")
                ->from("data_karyawan")
                ->where("nik", $data_pribadi['nik'])
                ->where("id_karyawan !=", $id_karyawan)
                ->where("id_company", $this->id_company)
                ->get()
                ->num_rows();

            if ($cek_nik > 0) {
                $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_simpan_data_diri') . '</font>'];
                return __response_update(false, $message);
            }
            # END CEK NIK YANG SAMA

            if ($data_pribadi['foto'] == "") {
                $predir_foto = $this->db->select("foto")
                    ->from($this->table)
                    ->where("id_karyawan", $id_karyawan)
                    ->where("id_company", $this->id_company)
                    ->get()
                    ->row("foto");
            }

            $this->db->trans_start();

            # BEGIN PENGATURAN KEPALA CABANG
            if ($level_user == "5") {
                $cek_p_kacab = $this->db->select("id")
                    ->from("p_kacab")
                    ->where("id_karyawan", $id_karyawan)
                    ->where("id_cabang", $data_pribadi["id_cabang"])
                    ->where("id_company", $this->id_company)
                    ->get()
                    ->num_rows();
                if ($cek_p_kacab > 0) {
                    # UPDATE CABANG UTAMA
                    $this->db->where("id_karyawan", $id_karyawan);
                    $this->db->where("id_cabang", $data_pribadi["id_cabang"]);
                    $this->db->where("id_company", $this->id_company);
                    $this->db->update("p_kacab", ["flag" => "1"]);

                    # UPDATE CABANG YANG LAIN MENJADI CABANG TAMBAHAN
                    $this->db->where("id_karyawan", $id_karyawan);
                    $this->db->where("id_cabang !=", $data_pribadi["id_cabang"]);
                    $this->db->where("id_company", $this->id_company);
                    $this->db->update("p_kacab", ["flag" => "0"]);
                } else {
                    # DELETE KEDEP
                    $this->_deleteKedep($id_karyawan);

                    # DELETE KACAB LAMA
                    $this->_deleteKacab($id_karyawan);

                    # INSERT KACAB BARU
                    $id_kacab = $this->fungsi->getNextId('p_kacab', 'id', $this->id_company, 3);
                    $data_kacab = array(
                        "id" => $id_kacab,
                        "id_karyawan" => $id_karyawan,
                        "id_cabang" => $data_pribadi["id_cabang"],
                        "flag" => "1",
                        "id_company" => $this->id_company
                    );

                    $this->db->insert('p_kacab', $data_kacab);
                }
            } else {
                $this->_deleteKacab($id_karyawan);
            }
            # END PENGATURAN KEPALA CABANG

            # BEGIN PENGATURAN KEPALA DEPARTEMEN
            if ($level_user == "2") {
                $cek_p_kedep = $this->db->select("id")
                    ->from("p_kedep")
                    ->where("id_karyawan", $id_karyawan)
                    ->where("id_cabang", $data_pribadi["id_cabang"])
                    ->where("id_departemen", $data_pribadi["id_departemen"])
                    ->where("id_company", $this->id_company)
                    ->get()
                    ->num_rows();

                if ($cek_p_kedep > 0) {
                    # UPDATE KEDEP UTAMA
                    $this->db->where("id_karyawan", $id_karyawan);
                    $this->db->where("id_departemen", $data_pribadi["id_departemen"]);
                    $this->db->where("id_company", $this->id_company);
                    $this->db->update("p_kedep", ["flag" => "1"]);

                    # UPDATE KEDEP YANG LAIN MENJADI KEDEP TAMBAHAN
                    $this->db->where("id_karyawan", $id_karyawan);
                    $this->db->where("id_departemen !=", $data_pribadi["id_departemen"]);
                    $this->db->where("id_company", $this->id_company);
                    $this->db->update("p_kedep", ["flag" => "0"]);
                } else {
                    # DELETE KACAB
                    $this->_deleteKacab($id_karyawan);

                    # DELETE KEDEP LAMA
                    $this->_deleteKedep($id_karyawan);

                    $id_kedep = $this->fungsi->getNextId('p_kedep', 'id', $this->id_company, 3);
                    $data_kedep = array(
                        "id" => $id_kedep,
                        "id_karyawan" => $id_karyawan,
                        "id_cabang" => $data_pribadi["id_cabang"],
                        "id_departemen" => $data_pribadi["id_departemen"],
                        "flag" => "1",
                        "id_company" => $this->id_company
                    );

                    # INSERT KEDEP BARU
                    $this->db->insert('p_kedep', $data_kedep);
                }
            } else {
                $this->db->where('id_karyawan', $id_karyawan);
                $this->db->where('id_company', $this->id_company);
                $this->db->delete("p_kedep");
            }
            # END PENGATURAN KEPALA DEPARTEMEN

            #JIKA TIDAK SUPERVISI
            if ($level_user != "7") {
                $this->db->where(['(supervisi)' => $id_karyawan, 'id_company' => $this->id_company]);
                $this->db->update($this->table, ["supervisi" => ""]);
            }

            # BEGIN UPDATE DATA PRIBADI
            $this->db->where(array('id_karyawan' => $id_karyawan, 'id_company' => $this->id_company));
            $this->db->update($this->table, $data_pribadi);
            $this->logger->create_log('master_karyawan', 'edit', $this->db->last_query());
            # END UPDATE DATA PRIBADI

            // update data sales
            if ($this->paket_arr['sales_activity'] === true) {
                if (in_array($data_pribadi['status'], ["5", "6", "7"])) {
                    $status_sales = array('status' => "0");
                }

                $this->db->where(array('id_karyawan' => $id_karyawan, 'id_company' => $this->id_company));
                $this->db->update('sales_approver', $status_sales);
            }

            $this->db->trans_complete(); # Completing transaction

            if ($this->db->trans_status() === FALSE) {
                # Something went wrong.
                $this->db->trans_rollback();
                return __response_update(false);
            } else {
                # Everything is Perfect.
                # Committing data to the database.
                $this->db->trans_commit();

                # DELETE FILE FOTO
                if ($data_pribadi['foto'] == "") {
                    $this->fungsi->delete_fileupload($predir_foto);
                }

                $new_params = array("new_params" => array("id_karyawan" => md5($id_karyawan)));
                return __response_save(true, $new_params);
            }
        } else {
            # CEK LIMIT JUMLAH KARYAWAN
            $cek_limit =  $this->_cekLimitJumlahKaryawan();
            if ($cek_limit !== true) {
                return $cek_limit;
            }

            # CEK NIK READY
            $cek_nik = $this->db->select("nik")
                ->from("data_karyawan")
                ->where("nik", $data_pribadi['nik'])
                ->where("id_company", $this->id_company)
                ->get()
                ->num_rows();

            if ($cek_nik > 0) {
                $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_simpan_data_diri') . '</font>'];
                return __response_save(false, $message);
            }

            # CEK USERNAME READY
            $cek_username = $this->db->select("username")
                ->from("users")
                ->where("username", $data_akun['username'])
                ->get()
                ->num_rows();

            if ($cek_username > 0) {
                $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_username_data_diri') . '</font>'];
                return __response_save(false, $message);
            }


            # CEK ID KARYAWAN READY
            $cek_id_karyawan = $this->db->select("id_karyawan")
                ->from("data_karyawan")
                ->where("id_company", $this->id_company)
                ->where("id_karyawan", $data_pribadi['id_karyawan'])
                ->get()
                ->num_rows();

            if ($cek_id_karyawan > 0) {
                $data_pribadi['id_karyawan'] .= 'X';
            }

            $this->db->trans_start(); # Starting Transaction
            $this->db->trans_strict(FALSE); # See Note 01. If you wish can remove as well

            # INSERT DATA KARYAWAN
            $this->db->insert('data_karyawan', $data_pribadi); # Inserting data

            # INSERT DATA USERS
            $this->db->insert('users', $data_akun); # Inserting data

            # INSERT KEPALA CABANG
            if ($level_user == "5") {
                $id_kacab = $this->fungsi->getNextId('p_kacab', 'id', $this->id_company, 3);
                $data_kacab = array(
                    "id" => $id_kacab,
                    "id_karyawan" => $data_pribadi["id_karyawan"],
                    "id_cabang" => $data_pribadi["id_cabang"],
                    "flag" => "1",
                    "id_company" => $this->id_company
                );

                $this->db->insert('p_kacab', $data_kacab);
            }

            # INSERT KEPALA DEPARTEMEN
            if ($level_user == "2") {
                $id_kedep = $this->fungsi->getNextId('p_kedep', 'id', $this->id_company, 3);
                $data_kedep = array(
                    "id" => $id_kedep,
                    "id_karyawan" => $data_pribadi["id_karyawan"],
                    "id_cabang" => $data_pribadi["id_cabang"],
                    "id_departemen" => $data_pribadi["id_departemen"],
                    "flag" => "1",
                    "id_company" => $this->id_company
                );

                # INSERT KEDEP BARU
                $this->db->insert('p_kedep', $data_kedep);
            }

            // insert payroll
            if ($level_user != "1") {
                $this->insert_payroll($data_pribadi["id_karyawan"]);
            }

            $this->db->trans_complete(); # Completing transaction


            if ($this->db->trans_status() === FALSE) {
                # Something went wrong.
                $this->db->trans_rollback();
                return __response_save(false);
            } else {
                # Everything is Perfect.
                # Committing data to the database.
                $this->db->trans_commit();
                $new_params = array("new_params" => array("id_karyawan" => md5($data_pribadi['id_karyawan'])));
                return __response_save(true, $new_params);
            }
        }
    }

    public function insert_payroll($id_karyawan)
    {
        $paket_payroll = $this->session->userdata('paket_payroll');
        // jika paket payroll aktif
        if ($paket_payroll == '1') {
            // insert gapok kosong
            $this->insert_gapok_kosong($id_karyawan);
            // insert master tunjangan tetap
            $this->insert_tunj_tetap($id_karyawan);
            // insert master tunjangan tetap
            $this->insert_tunj_kehadiran($id_karyawan);
            // insert master potongan tetap
            $this->insert_pot_tetap($id_karyawan);
        }
    }

    private function insert_gapok_kosong($id_karyawan)
    {
        $CI = &get_instance();
        $CI->load->model('karyawan_detail/Informasi_gaji_m');
        $CI->Informasi_gaji_m->update_gapok('payroll_gapok_m', 0, 0, $id_karyawan, false);
    }

    public function insert_tunj_tetap($id_karyawan)
    {
        $cek_tunj_tetap = $this->cek_tunj_tetap($id_karyawan);
        $gapok          = $this->get_gapok($id_karyawan);
        if ($cek_tunj_tetap == 0) {
            $komponen_tunj_tetap = $this->payroll_komponen('pendapatan');
            $data                = [];
            // $id_temp             = $this->fungsi->getNextId('payroll_tunj_tetap_m','id_item',$this->id_company,5);
            foreach ($komponen_tunj_tetap->result() as $row) {
                $temp = [
                    'id_item'               => $row->id_item,
                    'no_urut'               => $row->no_urut,
                    'jenis_komponen'        => $row->jenis_komponen,
                    'jenis_master'          => $row->jenis_master,
                    'id_karyawan'           => $id_karyawan,
                    'nm_tunjangan'          => $row->nm_komponen,
                    'flag_persentase_gapok' => $row->flag_persentase_gapok,
                    'gapok_persen'          => $row->gapok_persen,
                    'flag_bpjs'             => $row->flag_bpjs,
                    'flag_pph21'            => $row->flag_pph21,
                    'flag_pot_absensi'      => $row->flag_pot_absensi,
                    'id_company'            => $row->id_company,
                    'user_input'            => $this->nik . '-' . $this->nama_user
                ];

                if ($row->flag_persentase_gapok == '1') {
                    $temp['nominal_tunjangan'] = $gapok * ($row->gapok_persen / 100);
                } else {
                    $temp['nominal_tunjangan'] = 0;
                }

                $data[] = $temp;
                // $last_id = substr($id_temp, -5);
                // $next_id = $last_id + 1;
                // $id_temp = substr($id_temp, 0, -5) . sprintf("%05d", $next_id);
            }

            $this->db->insert_batch('payroll_tunj_tetap_m', $data);
        }
    }

    public function insert_tunj_kehadiran($id_karyawan)
    {
        $cek_tunj_kehadiran = $this->db->from('payroll_tunj_kehadiran_m')
            ->where('id_karyawan', $id_karyawan)
            ->where('id_company', $this->id_company)
            ->count_all_results();

        $gapok = $this->get_gapok($id_karyawan);
        if ($cek_tunj_kehadiran == 0) {
            $komponen_tunj_kehadiran = $this->payroll_komponen('kehadiran');
            $data                    = [];
            foreach ($komponen_tunj_kehadiran->result() as $row) {
                $temp = [
                    'id_item'               => $row->id_item,
                    'no_urut'               => $row->no_urut,
                    'id_karyawan'           => $id_karyawan,
                    'nm_tunjangan'          => $row->nm_komponen,
                    'flag_persentase_gapok' => $row->flag_persentase_gapok,
                    'gapok_persen'          => $row->gapok_persen,
                    'flag_bpjs'             => $row->flag_bpjs,
                    'flag_pph21'            => $row->flag_pph21,
                    'flag_pot_absensi'      => $row->flag_pot_absensi,
                    'flag_cuti'             => $row->flag_cuti,
                    'flag_izin'             => $row->flag_izin,
                    'flag_sakit'            => $row->flag_sakit,
                    'id_company'            => $row->id_company,
                    'user_input'            => $this->nik . '-' . $this->nama_user
                ];

                if ($row->flag_persentase_gapok == '1') {
                    $temp['nominal_tunjangan'] = $gapok * ($row->gapok_persen / 100);
                } else {
                    $temp['nominal_tunjangan'] = 0;
                }

                $data[] = $temp;
            }

            $this->db->insert_batch('payroll_tunj_kehadiran_m', $data);
        }
    }

    private function get_gapok($id_karyawan)
    {
        $this->db->from('payroll_gapok_m');
        $this->db->where('id_company', $this->id_company);
        $this->db->where('id_karyawan', $id_karyawan);
        $gapok = $this->db->get();
        if ($gapok->num_rows() > 0) {
            return $gapok->row()->nominal;
        } else {
            return 0;
        }
    }

    public function cek_tunj_tetap($id_karyawan)
    {
        $this->db->from('payroll_tunj_tetap_m');
        $this->db->where('id_karyawan', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->count_all_results();
    }

    public function payroll_komponen($jenis)
    {
        $this->db->from('payroll_komponen_m');
        $this->db->where('id_company', $this->id_company);
        $this->db->where('jenis_komponen', 'tetap');
        $this->db->where('jenis_master', $jenis);
        $this->db->order_by('no_urut', 'asc');
        return $this->db->get();
    }

    public function insert_pot_tetap($id_karyawan)
    {
        $cek_pot_tetap = $this->cek_pot_tetap($id_karyawan);
        $gapok         = $this->get_gapok($id_karyawan);
        if ($cek_pot_tetap == 0) {
            $komponen_pot_tetap = $this->payroll_komponen('potongan');
            $data               = [];
            // $id_temp = $this->fungsi->getNextId('payroll_pot_tetap_m', 'id_item', $this->id_company, 5);
            foreach ($komponen_pot_tetap->result() as $row) {
                $temp = [
                    'id_item'               => $row->id_item,
                    'no_urut'               => $row->no_urut,
                    'jenis_komponen'        => $row->jenis_komponen,
                    'jenis_master'          => $row->jenis_master,
                    'id_karyawan'           => $id_karyawan,
                    'nm_potongan'           => $row->nm_komponen,
                    'flag_persentase_gapok' => $row->flag_persentase_gapok,
                    'gapok_persen'          => $row->gapok_persen,
                    'flag_bpjs'             => $row->flag_bpjs,
                    'flag_pph21'            => $row->flag_pph21,
                    'flag_pot_absensi'      => $row->flag_pot_absensi,
                    'id_company'            => $row->id_company,
                    'user_input'            => $this->nik . '-' . $this->nama_user
                ];

                if ($row->flag_persentase_gapok == '1') {
                    $temp['nominal_potongan'] = $gapok * ($row->gapok_persen / 100);
                } else {
                    $temp['nominal_potongan'] = 0;
                }

                $data[] = $temp;
                // $last_id = substr($id_temp, -5);
                // $next_id = $last_id + 1;
                // $id_temp = substr($id_temp, 0, -5) . sprintf("%05d", $next_id);
            }
            $this->db->insert_batch('payroll_pot_tetap_m', $data);
        }
    }

    public function cek_pot_tetap($id_karyawan)
    {
        $this->db->from('payroll_pot_tetap_m');
        $this->db->where('id_karyawan', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->count_all_results();
    }

    private function _deleteKacab($id_karyawan = null)
    {
        $this->db->where('id_karyawan', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->delete("p_kacab");
    }

    private function _deleteKedep($id_karyawan = null)
    {
        $this->db->where('id_karyawan', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->delete("p_kedep");
    }

    private function _cekLimitJumlahKaryawan()
    {
        $max_karyawan = $this->db->select("SUM(master_company.custom_jumlah_karyawan + tb_paket.max_karyawan) AS max_jml_karyawan")
            ->from("master_company")
            ->join("tb_paket", "tb_paket.id_tb_paket = master_company.id_tb_paket")
            ->where("master_company.id_company", $this->id_company)
            ->get()
            ->row("max_jml_karyawan");

        $jumlah_karyawan_aktif = $this->db->select("data_karyawan.id_karyawan")
            ->from("data_karyawan")
            ->join("master_jabatan", "master_jabatan.id_jabatan = data_karyawan.id_jabatan")
            ->where_in("data_karyawan.status", ["1", "2", "3", "4"])
            ->where_not_in("master_jabatan.level_user", ["1", "6"])
            ->where("data_karyawan.id_company", $this->id_company)
            ->get()
            ->num_rows();

        if ($jumlah_karyawan_aktif >= $max_karyawan) {
            $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_limit_karyawan_data_diri') . '</font>'];
            return __response_update(false, $message);
        } else {
            return true;
        }
    }
}
