<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Laporan_pph_uu24 extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('payroll/laporan_pph/Laporan_pph_uu24_m', 'model');
        $this->load->model('payroll/gaji/Komponen_m');
        $this->load->helper('payroll');
        $this->load->library(array('PHPExcel/Excel', 'PHPExcel/PHPExcel'));
    }

    public function index()
    {
        $data['judul']   = 'Laporan PPH21';
        $data['aktif']   = 'laporan_pph';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('payroll/laporan_pph_uu24/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function view_data($bulan = "00-0000", $cabang = "all", $departemen = "all", $karyawan = "all")
    {
        $data['judul']         = 'Laporan PPH21';
        $data['aktif']         = 'laporan_pph';
        $data['bulan']         = $bulan;
        $data['id_cabang']     = $cabang;
        $data['id_departemen'] = $departemen;
        $data['id_karyawan']   = $karyawan;
        $this->load->view('payroll/laporan_pph_uu24/list_data', $data, false);
    }

    /**
     * mengubah angka minus menjadi kurung
     * ex. -1000 menjadi (1000)
     *
     * @param string|int $num
     * @return string
     */
    private function payroll_minus($num)
    {
        if (substr($num, 0, 1) == '-') {
            $num = substr($num, 1);
            return '(' . number_format($num, 0, ',', '.') . ')';
        }
        return number_format($num, 0, ',', '.');
    }

    public function list_data($bulan = "00-0000", $cabang = "all", $departemen = "all", $karyawan = "all")
    {
        $bulan       = $this->periode($bulan);
        list($y, $m) = explode('-', $bulan);
        $list        = $this->model->get_datatables($bulan, $cabang, $departemen, $karyawan);
        $data        = array();
        $no          = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = (int)$m;
            $row[] = $y;
            $row[] = $field->status_karyawan;
            $row[] = $field->nm_karyawan;
            $row[] = $field->no_ktp;
            $row[] = '';
            $row[] = $field->kd_ptkp;
            $row[] = $field->nm_jabatan;
            $row[] = $field->fasilitas == 'N' ? 'N/A' : $field->fasilitas;
            $row[] = $field->kd_objek_pajak;
            $row[] = $this->payroll_minus($field->gaji_bruto);
            $row[] = $field->ter_persen;
            $row[] = $field->id_tku;
            $row[] = date('d/m/Y', strtotime($field->tgl_pemotongan));

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($bulan, $cabang, $departemen, $karyawan),
            "recordsFiltered" => $this->model->count_filtered($bulan, $cabang, $departemen, $karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function download_excel($periode = "00-0000", $cabang = "all", $departemen = "all", $karyawan = "all")
    {
        $periode             = $this->periode($periode);
        list($tahun, $bulan) = explode('-', $periode);

        // FILENAME
        if ($karyawan != "all") {
            $nama_karyawan = $this->model->nama_karyawan($karyawan);
            $filename      = "DATA PPH21 " . $bulan . " " . $nama_karyawan;
        } else {
            if ($departemen != "all") {
                $nama_cab = $this->model->nama_cabang($cabang);
                $nama_dep = $this->model->nama_departemen($departemen);
                $nama     = "DATA PPH21 " . $bulan . " Cabang " . $nama_cab . " Departemen " . str_replace("/", "-", $nama_dep);
                $filename = $nama;
            } else {
                if ($cabang != "all") {
                    $nama     = $this->model->nama_cabang($cabang);
                    $filename = "DATA PPH21 " . $bulan . " Cabang " . $nama . " Semua Departemen";
                } else {
                    $nama     = "DATA PPH21 " . $bulan . " Semua Cabang";
                    $filename = $nama;
                }
            }
        }

        $data["filename"] = $filename;
        $data["periode"]  = $this->fungsi->konversi_bulan($bulan) . " " . $tahun;
        $data["data"]     = $this->model->get_datatables($periode, $cabang, $departemen, $karyawan);
        $sb_view          = $this->load->view('payroll/laporan_pph_uu24/download_excel', $data, true);
        // print_r($sb_view);
        // exit;
        $column_settings = ['A' => ['width' => 10, 'align' => 'center', 'valign' => 'middle']];
        $column_nominal  = ['O', 'R'];
        for ($i = 'A'; $i < 'S'; $i++) {
            if (in_array($i, $column_nominal)) {
                $column_settings[$i] = ['rupiah' => true, 'format' => 'text', 'valign' => 'middle'];
            } else {
                $column_settings[$i] = ['align' => 'left', 'format' => 'text', 'valign' => 'middle'];
            }
        }
        $param = [
            'download'     => true,
            'cLength'      => 17,
            'file_name'    => strtoupper(str_replace(" ", "_", $filename) . '_' . $bulan),
            'paper_size'   => 'A4',
            'font-size'    => 9,
            // 'pagebreak'   => true,
            'page_margin'  => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'  => 'potrait',
            'header'       => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold']
            ],
            'freezecolumn' => ['A5'],
            'thead'        => ['4'],
            'thead_styles' => ['row' => 4, 'height' => 30],
            'tbody'        => [
                'start'  => '4',
                'height' => 15,
                'wrap'   => ['B', 'C'],
                'column' => $column_settings,
            ],
        ];

        $this->load->library('PHPExcel/Excel');
        $this->excel->generateExcel($sb_view, $param);
    }

    private function periode($bulan)
    {
        return date_format(date_create("01-" . $bulan), "Y-m");
    }
}
