<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Keterlambatan extends MY_Controller {

	public function __construct(){
        parent::__construct();
	}

	public function index(){
	}

    public function data($id_cabang="all", $tgl_mulai="", $tgl_selesai=""){

        $tgl_mulai = date_format(date_create($tgl_mulai),"Y-m-d");
        $tgl_selesai = date_format(date_create($tgl_selesai),"Y-m-d");

        $label_arr = $this->_label($id_cabang);
        $ttl_karyawan_arr= $this->_ttl_karyawan($id_cabang, $tgl_mulai, $tgl_selesai);
        $terlambat_arr = $this->_terlambat($id_cabang, $tgl_mulai, $tgl_selesai);
        $tepat_waktu_arr = $this->_tepatWaktu($id_cabang, $tgl_mulai, $tgl_selesai);
        // $var
        $lbl_val_arr = [];
        $lbl_terlambat_arr = [];
        $lbl_tepat_waktu_arr = [];
        $lbl_ttl_karyawan_arr = [];
        foreach ($label_arr as $key=>$val) {
            $lbl_val_arr[] = $val;
            $lbl_terlambat_arr[] = (isset($terlambat_arr[$key]))?$terlambat_arr[$key]:0;
            $lbl_tepat_waktu_arr[] = (isset($tepat_waktu_arr[$key]))?$tepat_waktu_arr[$key]:0;
            $lbl_ttl_karyawan_arr[] = (isset($ttl_karyawan_arr[$key]))?$ttl_karyawan_arr[$key]:0;
        }

        $response = ["success" => true,
                    "data" =>[
                        "label"         => $lbl_val_arr,
                        "terlambat"     => $lbl_terlambat_arr,
                        "tepat_waktu"   => $lbl_tepat_waktu_arr,
                        "ttl_karyawan"  => $lbl_ttl_karyawan_arr
                    ]
                ];
        // var_dump($lbl_terlambat_arr);
        echo json_encode($response);
    }

    private function _label($id_cabang="all"){
        $this->db->where("dk.id_company", $this->id_company);
        // $this->db->where("am.tgl_absen",date('Y-m-d'));

        if($id_cabang != "all"){
            $this->db->where("dk.id_cabang", $id_cabang);
        }

        $this->db->select("md.id_departemen,
                            md.kode");
        // $this->db->join("data_karyawan dk","dk.id_karyawan = am.id_karyawan");
        $this->db->join("master_departemen md","md.id_departemen = dk.id_departemen");
        $this->db->group_by("md.id_departemen");
        $this->db->order_by("md.kode ASC");
        $query = $this->db->get("data_karyawan dk")->result();

        $data = [];
        foreach($query as $row){
            $data[$row->id_departemen] = $row->kode;
        }

        return $data;
    }


    private function _terlambat($id_cabang = "all", $tgl_mulai="", $tgl_selesai=""){
        $this->db->where("am.id_company", $this->id_company);
        $this->db->where("am.tgl_absen >= '$tgl_mulai'");
        $this->db->where("am.tgl_absen <= '$tgl_selesai'");
        $this->db->where("am.terlambat > 0");

        if($id_cabang != "all"){
            $this->db->where("dk.id_cabang", $id_cabang);
        }

        $this->db->select("md.id_departemen, count(am.id_karyawan) as total");
        $this->db->join("data_karyawan dk","dk.id_karyawan = am.id_karyawan");
        $this->db->join("master_departemen md","md.id_departemen = dk.id_departemen");
        $this->db->group_by("md.id_departemen");
        $this->db->order_by("md.kode asc");
        $query = $this->db->get("absensi_masuk am")->result();

        $data = [];
        foreach($query as $row){
            $data[$row->id_departemen] = $row->total;
        }

        return $data;
    }

    private function _tepatWaktu($id_cabang = "all", $tgl_mulai="", $tgl_selesai=""){
        $this->db->where("am.id_company", $this->id_company);
        // $this->db->where("am.tgl_absen",date('Y-m-d'));
        $this->db->where("am.tgl_absen >= '$tgl_mulai'");
        $this->db->where("am.tgl_absen <= '$tgl_selesai'");
        $this->db->where("am.terlambat",0);

        if($id_cabang != "all"){
            $this->db->where("dk.id_cabang", $id_cabang);
        }

        $this->db->select("md.id_departemen, count(am.id_karyawan) as total");
        $this->db->join("data_karyawan dk","dk.id_karyawan = am.id_karyawan");
        $this->db->join("master_departemen md","md.id_departemen = dk.id_departemen");
        $this->db->group_by("md.id_departemen");
        $this->db->order_by("md.kode asc");
        $query = $this->db->get("absensi_masuk am")->result();

        $data = [];
        foreach($query as $row){
            $data[$row->id_departemen] = $row->total;
        }

        return $data;
    }

    private function _ttl_karyawan($id_cabang = "all", $tgl_mulai="", $tgl_selesai=""){
        $this->db->where("dk.id_company", $this->id_company);

        $this->db->where("am.tgl_absen >= '$tgl_mulai'");
        $this->db->where("am.tgl_absen <= '$tgl_selesai'");

        if($id_cabang != "all"){
            $this->db->where("dk.id_cabang", $id_cabang);
        }

        $this->db->select("dk.id_departemen");
        $this->db->join("data_karyawan dk","dk.id_karyawan = am.id_karyawan ");
        $this->db->group_by("dk.id_karyawan");
        $this->db->order_by("dk.id_departemen");
        $query = $this->db->get("absensi_masuk am")->result();
        // echo $this->db->last_query();

        $data = [];

        $ttl_pegawai = 0;
        $id_departemen = "";
        foreach($query as $row){
            $ttl_pegawai = $ttl_pegawai + 1;
            if($id_departemen == $row->id_departemen){
                $data[$row->id_departemen] = $ttl_pegawai;
            }else{
                $ttl_pegawai = 1;
                $data[$row->id_departemen] = $ttl_pegawai;
            }
            $id_departemen = $row->id_departemen;

        }
        // var_dump($data);

        return $data;
    }

    public function dropdown_cabang(){

        $search = $this->input->get("q");

        $this->db->select('dk.id_cabang,
                            mc.kode as kd_cabang,
                            mc.nama as nm_cabang');
        $this->db->join('master_cabang mc','mc.id_cabang = dk.id_cabang');
        $this->db->where('dk.id_company', $this->id_company);
        $this->db->group_start();
        $this->db->like('mc.kode', $search);
        $this->db->or_like('mc.nama', $search);
        $this->db->group_end();
        $this->db->group_by('dk.id_cabang');
        $this->db->order_by('mc.kode', 'ASC');

        $result = $this->db->get('data_karyawan dk')->result();

        $json = [];
        foreach ($result as $row) {
            $json[] = ['id'     => $row->id_cabang,
                        'text'  => $row->kd_cabang." - ".$row->nm_cabang];
        }
        echo json_encode($json);

    }

    public function dropdown_departemen($id_cabang = "all"){
        $search = $this->input->get("q");

        $this->db->select('dk.id_departemen,
                            md.kode as kd_departemen,
                            md.nama as nm_departemen');
        $this->db->join('master_departemen md','md.id_departemen = dk.id_departemen');
        $this->db->where('dk.id_company', $this->id_company);
        $this->db->where('dk.id_cabang', $id_cabang);
        $this->db->group_start();
        $this->db->like('md.kode', $search);
        $this->db->or_like('md.nama', $search);
        $this->db->group_end();
        $this->db->group_by('dk.id_departemen');
        $this->db->order_by('md.kode', 'ASC');

        $result = $this->db->get('data_karyawan dk')->result();

        $json = [];
        foreach ($result as $row) {
            $json[] = ['id'     => $row->id_departemen,
                        'text'  => $row->kd_departemen." - ".$row->nm_departemen];
        }
        echo json_encode($json);
    }
}
