<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Atasan_khusus extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Atasan_khusus_m');
    }

	public function index(){
		$data['judul'] = 'Pengaturan Atasan Khusus';
		$data['aktif'] = 'atasan_khusus';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('pengaturan/atasan_khusus/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$list = $this->Atasan_khusus_m->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->kode_cabang." - ".$this->fungsi->get_nama_cab($field->id_cabang);			
			$row[] = $field->kode_departemen." - ".$this->fungsi->get_data_nama_dep($field->id_departemen);
			$row[] = $field->kode_jabatan_a." - ".$this->fungsi->get_nama_jab($field->id_jabatan);
			$row[] = $field->kode_jabatan_b." - ".$this->fungsi->get_nama_jab($field->atasan);

			if(in_array($this->session->userdata('level_user'), array("1"))) {
			$row[] = '<a href="#" class="text-warning" title="EDIT">
							<i id="'.md5($field->id).'" class="btn_edit fa fa-edit (alias) "> </i></a>&nbsp;
						<a href="#" class="text-danger" title="HAPUS">
							<i id="'.md5($field->id).'" class="btn_delete fa fa-trash"></i>
						</a>';
			}

	
			$data[] = $row;
		}
	
			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Atasan_khusus_m->count_all(),
							"recordsFiltered" => $this->Atasan_khusus_m->count_filtered(),
							"data"            => $data);
	
		$output = __response($this->MY_response, $output);
				
		echo json_encode($output);
	}

	public function form($id=null){
		if($id==null){
			$this->load->view('pengaturan/atasan_khusus/form');
		}else{
			$data['data'] = $this->Atasan_khusus_m->getDataById($id);
		
			$this->load->view('pengaturan/atasan_khusus/form',$data);
		}		
	}

	public function save(){
		$id = $this->input->post('id');
		
		$data = array('id_cabang'		=>$this->input->post('cabang'),
					'id_departemen'		=>$this->input->post('departemen'),
					'id_jabatan'		=>$this->input->post('jabatan'),
					'atasan'			=>$this->input->post('atasan'),
					'id_company' 		=>$_SESSION['id_company']);
	
		$this->Atasan_khusus_m->save($data,$id); 
	}

	public function delete(){
		$id = $this->input->post("id");
		$this->Atasan_khusus_m->delete($id);
	}

	public function get_atasan($id = null){
		$search = $this->input->get("q");
		$this->Atasan_khusus_m->get_atasan($id, $search);
	}
}
