<!-- Select2 -->
<link href="<?= base_url('assets/plugins/select2/css/select2.min.css')?>" rel="stylesheet">
<!-- Select2 -->
<script src="<?php echo base_url('assets/plugins/select2/js/select2.full.min.js') ?>"></script>
<body>
  <div class="content-body">
    <div class="container">
      <!-- MultiStep Form -->
      <div class="container-fluid">
        <div class="row justify-content-center mt-0">
          <div class="col-11 col-sm-9 col-md-7 col-lg-9 text-center p-0 mt-3">
            <div class="card px-0 pt-2 pb-0" style="background-color: transparent;">
              <div class="row">
                <div class="col-md-12 mx-0">
                  <form id="msform">
                    <!-- progressbar -->
                    <div class="section-progressbar">
                      <h2 id="judul" class="fs-title text-center">Quick Setup</h2>
                      <ul id="progressbar">
                        <li class="active" id="lokasi"><span></span> Lokasi Absensi</li>
                        <li class="active" id="akun"><span></span> Akun</li>
                        <li id="finish"><span></span> Finish</li>
                      </ul>
                    </div>
                    <fieldset id="formKepalaDepartemen">
                      <div class="form-card">
                        <h2 class="fs-title">Tambah Staff</h2>
                        <div class="row">
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="control-label">Nomor Induk Karyawan * <i class="fa fa-info-circle"  data-toggle="tooltip" data-placement="top" title="Harap melengkapi kolom isian dibawah ini"></i></label>
                              <input type="text" id="nik" class="form-control" placeholder="">
                            </div>
                            <div class="form-group">
                              <label class="control-label">Nama Staff *</label>
                              <input type="text" id="nama" class="form-control" placeholder="">
                            </div>
                            <div class="form-group">
                              <label class="control-label">Nama Departemen *</label>
                              <select type="text" id="departemen" class="form-control">
                                <option value="<?= $data->id_departemen ?>" selected="selected"><?= $data->kode.' - '.$data->nama ?></option>
                              </select>
                            </div>
                            <div class="form-group">
                              <label class="control-label">Username * <i class="fa fa-info-circle"  data-toggle="tooltip" data-placement="top" title="Anda dapat merubah username"></i></label>
                              <input type="text" id="username" class="form-control" placeholder="">
                            </div>
                            <div class="form-group">
                              <label class="control-label" hidden>Password *</label>
                              <input type="hidden" id="password" class="form-control" placeholder="">
                            </div>
                          </div>
                        </div>
                        <div class="input-control text-left">
                            <div id="message"></div>
                        </div>
                      </div>
                      <a href="<?= route('wizard.selesai') ?>"><button type="button" name="previous" class="previous action-button-previous float-left"> Kembali </button></a>
                      <button type="button" name="next" class="next action-button float-right ladda-button" data-style="expand-left">Berikutnya </button>
                    </fieldset>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="footer">
      Copyright © 2021 Absenku Profesional
    </div>
  </div>
</body>
<script>
$(function () {
  $('[data-toggle="tooltip"]').tooltip();
});
/*ketika username kepala departemen diisi otomatis mengisi password kepala departemen*/
$("#username").keyup(function() {
  var teks = $(this).val();
	var temp = teks.replace(/\s/g, '');
	$(this).val(temp);
  if(temp != '') {
    cek_username(temp);
  }
});

$("#nik").keyup(function() {
  var nik = $(this).val().trim();
  $('#nik').val(nik);
  if(nik != '') {
    $("#username").val(nik);
    cek_username(nik);
    $("#password").val(nik);
  }
});

$('#departemen').select2({
  placeholder: 'Pilih Departemen',
  ajax: {
    // type: 'POST',
            url: '<?= site_url("wizard/select2_departemen_staff")  ?>',
            dataType: 'json',
            delay: 250,
            processResults: function (data) {
            return {
                    results: data
                };
            },
            cache: false
        },
        minLength: 3
});

/*mengecek username sudah digunakan atau belum*/
function cek_username(name) {
  var result;
  $("#message").html("");
  $.ajax({
      url: "<?= site_url('wizard/cek_username') ?>",
      type: 'get',
      dataType: 'json',
      async: false,
      data : {username : name},
      success: function(data) {
          result = data.username;
          /*menampilkan pesan jika username sudah digunakan*/
          if(result) {
            $("#message").html("<span class='text-danger'>username sudah digunakan</span>");
          } else {
            $("#message").html("");
          }
      }
   });
   return result;
}

$(document).on("click",".action-button",function(e){
    e.preventDefault();
    $('#message').html("");
    var loading = Ladda.create(this);

    if(!$("#nik").val()){
        $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> NIK belum diisi</font>");
        $("#nik").focus();
        return false;
    }else if(!$("#nama").val()){
        $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama belum diiisi</font>");
        $('#nama').focus();
        return false;
    }else if(!$("#departemen").val()){
        $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Departemen belum diiisi</font>");
        $('#departemen').focus();
        return false;
    }else if(!$("#username").val()){
        $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Username belum diiisi</font>");
        $('#jarak').$('#username').keyup(function() {
	var teks = $(this).val();
	var temp = teks.replace(/\s/g, '');
	$(this).val(temp);
});focus();
        return false;
    }else if($("#username").val()) {
      if(cek_username($("#username").val())) {
        $("#username").focus();
        return false;
      }
    }else if(!$("#password").val()){
        $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Password belum diiisi</font>");
        $('#password').focus();
        return false;
    }
    loading.start();

    var param = 'nik='+$("#nik").val()+
                '&nama='+$("#nama").val()+
                '&departemen='+$("#departemen").val()+
                '&username='+$("#username").val()+
                '&password='+$("#password").val();

    $.ajax({
        type: 'POST',
        url: "<?= route('wizard.akun.staff.insert') ?>",
        data: param,
        dataType:'JSON',
        success: function(result) {
            loading.stop();
            if(result.success == true){
                if(result.type == 'save'){
                    $('#message').html("");
                    window.location.href = "<?= route('wizard.selesai') ?>";
                }
            } else {
              $('#message').html(result.message);
            }
        },
        error:function(){
            loading.stop();
            $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
        }
    });
});
</script>
</html>
