<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({ 
                    'searching'   : true,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'lengthMenu'  : [1, 10],
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'NIK/Nama Karyawan'
                                },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                        "url": "<?= route('pengaturan.notif.listdata') ?>",
                                        "type": "POST",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false },
                                        { "aTargets": [4], "bSortable": false }
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center'});
                            $('td:eq(4)', nRow).css({'text-align':'center'});
            
                            $('td:eq(0)', nRow).css({'width':'10px'});
                            $('td:eq(4)', nRow).css({'width':'100px'});
                    }
        
        });


        $(document).on('click','.btn_tambah',function(){
            $('#tampil_form').load("<?= route('pengaturan.notif.form.tambah') ?>",function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Tambah Data");
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('SIMPAN');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click','.btn_edit',function(){
            $('#tampil_form').load("<?= route('pengaturan.notif.form.edit') ?>"+"/"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Edit Data");
                $(".btn_save").addClass("btn_save btn btn-warning");
                $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
                $(".btn_save").append('PERBARUI');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click','.btn_delete',function(){
            $('#tampil_form').load("<?= route('pengaturan.notif.form.hapus') ?>"+"/"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Apakah Anda ingin menghapus data ini?");
                $('#id_karyawan').prop("disabled",true);
                $('#form_input input[type=radio]').prop("disabled",true);
                $(".btn_save").append('<i class="fa fa-trash"></i> ');
                $(".btn_save").append('HAPUS');
                $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            });
        });

        $(document).on('click','#btn_new_input', function(){
            $('#form_input input[type=text]').prop("disabled",false);
            $("#form_input input[type=text]").val('');

            $('#id_karyawan').prop("disabled",false);
            $("#id_karyawan").val('').trigger('change');

            $('#form_input input[type=radio]').prop("disabled",false);
            
            $('.btn_save').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });

        $(document).on("click",".btn_save",function(e){
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);
        
            if($("#id_karyawan").val()==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Karyawan belum dipilih</font>");
                $("#id_karyawan").focus();
                return false;
            }
            
            loading.start();
        
            var param = 'id_notification='+$("#id_notification").val()+
                        '&id_karyawan='+$("#id_karyawan").val()+
                        '&hak_akses='+$("input[name='hak_akses']:checked").val();
        
            $.ajax({
                type: 'POST',
                url: "<?= route('pengaturan.notif.save') ?>",
                data: param,
                dataType:'JSON',
                success: function(result) {
                    if(result.success == true){
                        if(result.type == 'save'){
                            $("#form_input :input").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error:function(){
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        // PROSES DELETE
        $(document).on('click','.btn_hapus',function(){
            var loading = Ladda.create(this);
            loading.start();
            var param = {};
            param.id_notification=$("#id_notification").val();
            $.ajax({
                type: 'POST',
                url: "<?php echo route('pengaturan.notif.delete') ?>",
                data: param,
                dataType:'JSON',
                success: function(result){
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message);
                    
                },
                error:function(){
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
        
    });
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">Pengaturan</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <button type="button" class="btn_tambah btn btn-biru">
                    <i class="fa fa-plus"></i> Tambah Data
                </button>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th class="text-center">NO</th>
                            <th class="text-left">NAMA KARYAWAN</th>
                            <th class="text-left">NOTIF HRD</th>
                            <th class="text-left">NOTIF FINANCE</th>
                            <th class="text-center">AKSI</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->


