
<script type="text/javascript">
    $(function() {
        $('#cabang').select2({
            tags: true,
            // minLength: 3,
            placeholder: 'Pilih Cabang',
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            templateSelection: function(tag, container) {

                var $option = $('#cabang option[value="' + tag.id + '"]');
                if ($option.attr('locked')) {
                    $(container).addClass('locked-tag');
                    tag.locked = true;
                }
                return tag.text;
            },
        });
    });
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <div class="form-group">
        <label>Karyawan</label><br>
        <label class="font-weight-bold"><?= $karyawan->nik . " - " . $karyawan->nama_lengkap ?></label>
        <input type="hidden" id="id_karyawan" class="form-control" value="<?= $karyawan->id_karyawan ?>">
    </div>
    <div class="form-group">
        <label>Cabang <i class="text-danger">*</i></label>
        <select id="cabang" multiple="multiple" style="border-radius: 5px; width: 100%;">
            <?php
            foreach ($cabang as $rows) {
                if($rows->flag == "1"){
                    $locked = 'locked="locked"';
                }else{
                    $locked = '';
                }
                echo '<option value="'.$rows->id_cabang.'"  '.$locked.' selected>' . $rows->kode_cabang . ' - ' . $rows->nama_cabang . '</option>';
            }
            ?>
        </select>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button class="btn_save ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>