<script type="text/javascript">
    $(function(){
        datepicker(null,'<?= date("d-m-Y") ?>');
        dropdown_kota();
        $('#id_prov').select2({
            placeholder: 'Pilih Provinsi',
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.provinsi")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        }).on('change', function (e) {
            $('#id_kota').val("");
            dropdown_kota();
        });
    });

    function dropdown_kota(){
        $('#id_kota').select2({
            placeholder: 'Pilih Kota/Kabupaten',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.kota")."/" ?>'+$('#id_prov').val(),
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id_karyawan" class="form-control" value="<?= $id_karyawan ?>">
    <input type="hidden" id="id_riwayat_pekerjaan" class="form-control" value="<?= ((isset($data))?md5($data->id_riwayat_pekerjaan):'') ?>">
    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label>Nama Perusahaan <i class="text-danger">*</i></label>
                <input type="text" id="nama_perusahaan" class="form-control" value="<?= ((isset($data))?$data->nama_perusahaan:'') ?>">
            </div>
        </div>
    </div>
    
    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Jenis Perusahaan <i class="text-danger">*</i></label>
                <input type="text" id="jenis_perusahaan" class="form-control" value="<?= ((isset($data))?$data->jenis_perusahaan:'') ?>">
            </div>

            <div class="col-md-6">
                <label>Jabatan Terakhir <i class="text-danger">*</i></label>
                <input type="text" id="jabatan_terakhir" class="form-control" value="<?= ((isset($data))?$data->jabatan:'') ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label>Alamat Perusahaan <i class="text-danger">*</i></label><br>
                <input type="text" id="alamat_perusahaan" class="form-control" value="<?= ((isset($data))?$data->alamat_perusahaan:'') ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Provinsi <i class="text-danger">*</i></label>
                <select id="id_prov" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                    <?php
                        if(isset($data) && !empty($data->id_prov)){
                    ?>
                            <option value="<?= $data->id_prov ?>" selected><?= $data->provinsi ?></option>
                    <?php
                        }
                    ?>
                </select>
            </div>

            <div class="col-md-6">
                <label>Kota <i class="text-danger">*</i></label>
                <select id="id_kota" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                    <?php
                        if(isset($data) && !empty($data->id_kota)){
                    ?>
                            <option value="<?= $data->id_kota ?>" selected><?= $data->kota ?></option>
                    <?php
                        }
                    ?>
                </select>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Tanggal Masuk Kerja <i class="text-danger">*</i></label>
                <?php
                    if (isset($data)) {
                        $tanggal_masuk = date('d-m-Y', strtotime($data->tgl_masuk));
                    }else{
                        $tanggal_masuk = "";
                    }
                ?>
                <input type="text" id="tgl_masuk" class="form-control datepicker" value="<?= $tanggal_masuk ?>" placeholder="dd-mm-yyyy" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'">
            </div>

            <div class="col-md-6">
                <label>Tanggal Berhenti Kerja <i class="text-danger">*</i></label>
                <?php
                    if (isset($data)) {
                        $tanggal_keluar = date('d-m-Y', strtotime($data->tgl_keluar));
                    }else{
                        $tanggal_keluar = "";
                    }
                ?>
                <input type="text" id="tgl_keluar" class="form-control datepicker" value="<?= $tanggal_keluar ?>" placeholder="dd-mm-yyyy" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label>Alasan Berhenti</label>
                <input type="text" id="alasan_berhenti" class="form-control" value="<?= ((isset($data))?$data->alasan_berhenti:'') ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Upload File Pendukung</label>
                <?php
                    if(empty($data->file)){
                        $file = "";
                    }else{
                        $file = $this->config->item('base_image').'imagebiodata?_t=file&_d='.$data->file;
                    } 
                ?>
                <input type="file" name="file" id="file" id="input-file-now-custom-1" class="dropify" data-default-file="<?= $file ?>" />
                <input type="hidden" name="file_lama" id="file_lama" value="<?= $data->file ?>">
            </div>
        </div>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button class="btn_save_pengalaman ladda-button" id="btn_save_pengalaman" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>

<script>
    $(document).ready(function() {
        
        $('.dropify').dropify({
            messages: {
                'default': 'Seret dan lepas atau klik disini',
                'replace': 'Seret dan lepas atau klik disini',
                'remove':  'Hapus',
                'error':   'Ooops, terjadi kesalahan.',
            },
            error: {
                'fileSize': 'The file size is too big ({{ value }} max).',
                'minWidth': 'The image width is too small ({{ value }}}px min).',
                'maxWidth': 'The image width is too big ({{ value }}}px max).',
                'minHeight': 'The image height is too small ({{ value }}}px min).',
                'maxHeight': 'The image height is too big ({{ value }}px max).',
                'imageFormat': 'Format file tidak diperbolehkan ({{ value }} only).'
            }
            
        });
        
        file = $('#form_input #file').dropify();

        file.on('dropify.afterClear', function(event, element){
            $("#form_input #file_lama").val("");
        });
    });
</script> 