<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Kepala_cabang_m extends CI_Model {
    var $table = 'p_kacab';
    public function __construct(){
        parent::__construct();

        $this->id_company = $this->session->userdata("id_company");
    }


    function get_datatables(){
        $this->_get_datatables_query();
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all(){
        $this->db->select("p_kacab.id");
        $this->db->from($this->table);
        $this->db->join('data_karyawan', 'data_karyawan.id_karyawan = p_kacab.id_karyawan');
        $this->db->where("p_kacab.id_company",$this->id_company);
        $this->db->where("data_karyawan.status IN ('1','2','3','4')");
        $this->db->group_by('p_kacab.id_karyawan');
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("p_kacab.id, 
                            p_kacab.id_cabang,
                            data_karyawan.id_karyawan,
                            data_karyawan.nik,
                            data_karyawan.nama_lengkap,
                            p_kacab.id_company,
                            master_cabang.kode as kode_cabang,
                            master_cabang.nama as nama_cabang,
                            COUNT(p_kacab.id_cabang) as jumlah_cabang");
        $this->db->from($this->table);
        $this->db->join('master_cabang', 'master_cabang.id_cabang = p_kacab.id_cabang');
        $this->db->join('data_karyawan', 'data_karyawan.id_karyawan = p_kacab.id_karyawan');
        $this->db->where("p_kacab.id_company",$this->id_company);
        $this->db->where("data_karyawan.status IN ('1','2','3','4')");
        $this->db->group_by('p_kacab.id_karyawan');
        $column_search = array('data_karyawan.nama_lengkap','data_karyawan.nik');
        $i = 0;
    
        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST
    
                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }
    
                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }
    
        $column_order = array('','p_kacab.id_karyawan','p_kacab.id_cabang');
    
        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } 
        else{
            $order_by = array("p_kacab.id"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getKaryawan($id_karyawan=null){
        $select = $this->db->select("p_kacab.id as id_p_kacab,
                                    dk.id_karyawan,
                                    dk.nik,
                                    dk.nama_lengkap")
                            ->from($this->table)
                            ->join("data_karyawan AS dk","dk.id_karyawan = p_kacab.id_karyawan")
                            ->where("MD5(p_kacab.id_karyawan)",$id_karyawan)
                            ->group_by("p_kacab.id_karyawan")
                            ->get()
                            ->row();
        return $select;
    }

    public function getCabang($id_karyawan=null){
        $select = $this->db->select("mc.id_cabang,
                                    mc.kode as kode_cabang,
                                    mc.nama as nama_cabang,
                                    p_kacab.flag")
                            ->from($this->table)
                            ->join("master_cabang AS mc","mc.id_cabang = p_kacab.id_cabang")
                            ->where("MD5(p_kacab.id_karyawan)",$id_karyawan)
                            ->order_by("mc.kode ASC")
                            ->get()
                            ->result();
        return $select;
    }

    public function update($data_insert = null,$id_karyawan = null,$id_company = null){
    
        $this->db->trans_start();

        $this->db->where("id_company",$id_company);
        $this->db->where("id_karyawan",$id_karyawan);
        $this->db->where("flag","0");
        $this->db->delete($this->table);

        if(!empty($data_insert)){
            $this->db->insert_batch($this->table, $data_insert);
        }

        $this->db->trans_complete();

        if($this->db->trans_status() === FALSE){
            $this->db->trans_rollback();
            return  __response_update(false);
        }else{
            $this->db->trans_commit();
            return  __response_update(true);
        }
    }
}