<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Wizard_lokasi extends MY_Controller{

  public function __construct()
  {
    parent::__construct();
    //Codeigniter : Write Less Do More
  }

  function index() {
    $data_lokasi = $this->db->where('id_company', $this->session->userdata('id_company'))->get('data_lokasi_kantor');
    if($data_lokasi->num_rows() == 0) {
      //jika belum ada lokasi
      $this->tambah();
    } else {
      //jika sudah ada maka edit
      $data = $data_lokasi->row();
      $this->edit($data);
    }
  }

  function tambah()
  {//view tambah lokasi
    $data['id_cabang'] = $this->session->userdata('id_cabang');
    $this->load->view('wizard/header');
    $this->load->view('wizard/lokasi/tambah', $data);
    $this->load->view('wizard/footer');
  }

  function edit($data_lokasi) {
    //view edit lokasi
    $data['id_cabang'] = $this->session->userdata('id_cabang');
    $data['data'] = $data_lokasi;
    $this->load->view('wizard/header');
    $this->load->view('wizard/lokasi/edit', $data);
    $this->load->view('wizard/footer');
  }

  function insert(){
    //simpan lokasi baru
      $json['status'] = 'gagal';
      $lat = $this->input->post('lat');
      $lon = $this->input->post('lng');
      $distance = $this->input->post('jarak') / 1000;
      $R = 6371; //constant earth radius. You can add precision here if you wish

      $maxLat = $lat + rad2deg($distance / $R);
      $minLat = $lat - rad2deg($distance / $R);
      $maxLon = $lon + rad2deg(asin($distance / $R) / cos(deg2rad($lat)));
      $minLon = $lon - rad2deg(asin($distance / $R) / cos(deg2rad($lat)));

      $nextId = $this->fungsi->getNextId('data_lokasi_kantor','id_lokasi_kantor',$_SESSION['id_company'],3);

      $data = array(
          'id_lokasi_kantor' => $nextId,
          'nama_kantor' => $this->input->post('kantor'),
          'lat_asli' => $lat,
          'lat_min' => $minLat,
          'lat_max' => $maxLat,
          'long_asli' => $lon,
          'long_min' => $maxLon,
          'long_max' => $minLon,
          'jarak' => $this->input->post('jarak'),
          'id_company' => $this->session->userdata('id_company'),
          'id_cabang' => $this->input->post('cabang'),
          'flag' => $this->input->post('flag')
      );

      $add = $this->db->insert('data_lokasi_kantor', $data);
      $this->update_status_wizard();

      return __response_save($add);
  }

  public function update(){
    //update lokasi
      $json['status'] = 'gagal';
      $lat = $this->input->post('lat');
      $lon = $this->input->post('lng');
      $distance = $this->input->post('jarak') / 1000;
      $kode_lokasi = $this->input->post('kode_lokasi');
      $R = 6371; //constant earth radius. You can add precision here if you wish

      $maxLat = $lat + rad2deg($distance / $R);
      $minLat = $lat - rad2deg($distance / $R);
      $maxLon = $lon + rad2deg(asin($distance / $R) / cos(deg2rad($lat)));
      $minLon = $lon - rad2deg(asin($distance / $R) / cos(deg2rad($lat)));
      $flag = $this->input->post('flag');

      //echo $maxLat, "<br>", $minLat, "<br>", $maxLon, "<br>", $minLon;
      $data = array(
          'nama_kantor' => $this->input->post('kantor'),
          'lat_asli' => $lat,
          'lat_min' => $minLat,
          'lat_max' => $maxLat,
          'long_asli' => $lon,
          'long_min' => $maxLon,
          'long_max' => $minLon,
          'jarak' => $this->input->post('jarak'),
          'id_company' => $this->session->userdata('id_company'),
          'id_cabang' => $this->input->post('cabang'),
          'flag' => $flag
      );

      $update = $this->db->update('data_lokasi_kantor', $data, array('id_lokasi_kantor' => $this->input->post('id_lok')));
      $this->update_status_wizard();

      return  __response_update($update);
  }

  function update_status_wizard() {
    //update status data_lokasi pada tabel wizard
    $id_company = $this->session->userdata('id_company');
    $this->db->set('data_lokasi','1')->where('id_company', $id_company)->update('wizard');
  }
}
