<?php
$array_bulan_short = $this->lang->line('array_bulan');
$months            = str_replace(["[", "]", "'"], "", $array_bulan_short);
$months_array      = explode(", ", $months);
?>

<div class="position-relative pull-right" style="top: -2.5em;">
    <button id="view-diagram" type="button" class="ml-1 btn btn-warning ladda-button" data-style="expand-left">
        <i class="fa fa-bar-chart"></i> View Diagram
    </button>
</div>

<div class="table-responsive mt-2">
    <div id="data-actions" class="pull-right ml-1">
        <button id="download" type="button" class="btn btn-primary ladda-button" disabled data-style="expand-left">
            <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
        </button>
    </div>
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th rowspan="2" class="text-center align-middle">NO</th>
                <th rowspan="2" class="text-center align-middle">NAMA</th>

                <?php
                foreach ($months_array as $value) {
                    echo '<th colspan="2" class="text-center text-uppercase">' . $value . '</th>';
                }
                ?>

                <th colspan="2" class="text-center align-middle">TOTAL POIN</th>
            </tr>
            <tr>
                <?php
                foreach ($months_array as $value) {
                    echo '<th class="text-center">TARGET</th>';
                    echo '<th class="text-center">REALISASI</th>';
                }
                ?>

                <th class="text-center">TARGET</th>
                <th class="text-center">REALISASI</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<script>
    $(function () {
        list_data = $('#list_data').DataTable({
            'searching': false,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            'fixedColumns': {
                leftColumns: 2
            },
            'language': {
                <?php if ($this->code_lang == 'id'): ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Nama karyawan'
                <?php else: ?> 'searchPlaceholder': 'Employees Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "layout": {
                "topEnd": [
                    $("#data-actions")
                ]
            },
            "ajax": {
                "url": "<?= route('sales_activity.report.poin.bulanan.table.data.list') ?>",
                "type": "GET",
                "data": function (d) {
                    delete d.columns;
                    d.periode = $(".filter #periode").val();
                    d.id_group = !$(".filter #id_group").val() ? 'all' : $(".filter #id_group").val();
                    d.id_karyawan = !$(".filter #id_karyawan").val() ? 'all' : $(".filter #id_karyawan").val();
                },
                "complete": function (data) {
                    let loading = Ladda.create(document.getElementById("download"));
                    loading.stop();
                    $("#download").prop("disabled", false);
                    reconfigure(data);
                    screenUp(250);
                }
            },
            "aoColumnDefs": [{
                render: function (data, type, full, meta) {
                    return "<div style='text-wrap:wrap !important; width:200px'>" + data + "</div>";
                },
                targets: 1
            }],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });

                for (var i = 2; i <= 25; i++) {
                    $('td:eq(' + i + ')', nRow).css({
                        'text-align': 'center'
                    });
                }

                // i++;
                $('td:eq(' + i + ')', nRow)
                    .css({
                        'text-align': 'center',
                        'background-color': '#ccedff',
                        'border-top': '1px solid #fff',
                        'border-right': '1px solid #fff',
                        'border-left': '1px solid #fff'
                    });

                i++;
                $('td:eq(' + i + ')', nRow)
                    .css({
                        'text-align': 'center',
                        'background-color': '#ccedff',
                        'border-top': '1px solid #fff',
                    });
            },
        });

        $("#download").click(function () {
            let periode = $(".filter #periode").val();
            let id_group = !$(".filter #id_group").val() ? 'all' : $(".filter #id_group").val();
            let nm_group = !$(".filter #id_group").val() ? 'Semua Group' : $(".filter #id_group").select2('data')[0]['nm-group'];
            let id_karyawan = !$(".filter #id_karyawan").val() ? 'all' : $(".filter #id_karyawan").val()
            let nm_karyawan = !$(".filter #id_karyawan").val() ? 'Semua Sales' : $(".filter #id_karyawan").select2('data')[0]['nm-karyawan'];

            urlExcel = "<?= route('sales_activity.report.poin.bulanan.table.download') ?>" +
                '?periode=' + periode +
                '&id_group=' + id_group +
                '&nm_group=' + nm_group +
                '&id_karyawan=' + id_karyawan +
                '&nm_karyawan=' + nm_karyawan;
            downloadFile(urlExcel, this);
        });

        $("#view-diagram").click(function () {
            list_datatable("diagram", this);
        });
    });
</script>