<script type="text/javascript">
    $(function() {
        dropdown_filter_group_area();

        $("#btn_filter").on("click", function() {
            var loading = Ladda.create(this);
            loading.start();
            list_data.ajax.reload(function() {
                loading.stop();
            });
        });

        list_data = $('#list_data').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'NIK/Nama'
                <?php else : ?> 'searchPlaceholder': 'Employee Code/Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('sales_activity.master.target.poin.list.data') ?>",
                "type": "GET",
                "data"  : function (d) {
                    delete d.columns;
                    d.id_group_m = $(".filter #id_group_m").val() ? $(".filter #id_group_m").val() : 'all';
                },
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({'text-align': 'center', 'width': '10px'});
                $('td:eq(2)', nRow).css({'text-align': 'left', 'width': '200px'});
                $('td:eq(3)', nRow).css({'text-align': 'center', 'width': '200px'});
                $('td:eq(-1)', nRow).css({'text-align': 'center', 'width': '50px'});
            }
        });
    });

    function dropdown_filter_group_area(){
        var opsi_all = "no";
        $(".filter #id_group_m").select2({
            placeholder: "Semua Group",
            allowClear: true,
            // width: 'resolve',
            ajax: {
                url: '<?= route("sales_activity.master.dropdown.group.area") ?>' + '/' + opsi_all,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 mb-md-0 mb-1">
        <h5 class="dark-blue-color"><?= $this->lang->line('target_poin_harian') ?></h5>
    </div>
</div>

<hr>

<?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
    <div class="filter mt-2">
        <div class="row">
            <div class="col-md-1 align-self-center">
                <label class="font-weight-bold"><?=$this->lang->line('group_area'); ?></label>
            </div>
            <div class="col-md-4">
                <select class="form-control" id="id_group_m" style="width: 100%"></select>
            </div>
            <div class="col-md-1">
                <button type="button" id="btn_filter" class="ladda-button btn btn-primary" data-style="expand-left">FILTER</button>
            </div>
        </div>
    </div>
<?php endif; ?>

<div class="table-responsive mt-3">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle text-uppercase">NO</th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('nama_karyawan') ?></th>

                <?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
                    <th class="text-center align-middle text-uppercase"><?= $this->lang->line('group_area') ?></th>
                <?php endif; ?>
                
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('poin') ?></th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('aksi') ?></th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
